/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.transition;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.cybersecurity.test.transition.CyberTopDownTransitionTestCase;

public class CybersecurityMiscTransitionTest
extends CyberTopDownTransitionTestCase {
    Threat threat1;
    Threat threat2;
    Threat threat3;
    PrimaryAsset pa1;
    PrimaryAsset pa2;
    PrimaryAsset pa3;

    @Override
    protected void init() {
        Session session = this.getSession(this.getRequiredTestModels().get(0));
        this.project = SessionHelper.getCapellaProject((Session)session);
        this.services = new CybersecurityServices();
        this.oaArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.OA, (Project)this.project);
        this.saArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.SA, (Project)this.project);
        this.laArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.LA, (Project)this.project);
        this.paArch = BlockArchitectureExt.getBlockArchitecture((BlockArchitectureExt.Type)BlockArchitectureExt.Type.PA, (Project)this.project);
        this.oaPkg = this.services.getDefaultCyberSecurityPackage((EObject)this.oaArch, true);
        this.threat1 = CybersecurityFactory.eINSTANCE.createThreat();
        this.threat2 = CybersecurityFactory.eINSTANCE.createThreat();
        this.threat3 = CybersecurityFactory.eINSTANCE.createThreat();
        this.pa1 = CybersecurityFactory.eINSTANCE.createFunctionalPrimaryAsset();
        this.pa2 = CybersecurityFactory.eINSTANCE.createInformationPrimaryAsset();
        this.pa3 = CybersecurityFactory.eINSTANCE.createEnterprisePrimaryAsset();
        this.oaPkg.getOwnedThreats().add((Object)this.threat1);
        this.oaPkg.getOwnedThreats().add((Object)this.threat2);
        this.oaPkg.getOwnedThreats().add((Object)this.threat3);
        this.oaPkg.getOwnedPrimaryAssets().add((Object)this.pa1);
        this.oaPkg.getOwnedPrimaryAssets().add((Object)this.pa2);
        this.oaPkg.getOwnedPrimaryAssets().add((Object)this.pa3);
    }

    @Override
    public void doTest() {
        this.saPkg = this.testContext(this.oaPkg);
        this.laPkg = this.testContext(this.saPkg);
        this.paPkg = this.testContext(this.laPkg);
    }

    protected CybersecurityPkg testContext(CybersecurityPkg pkgSrc) {
        CybersecurityMiscTransitionTest.assertNotNull((Object)pkgSrc);
        String pa1Id = this.pa1.getId();
        String pa2Id = this.pa2.getId();
        String pa3Id = this.pa3.getId();
        String threat1Id = this.threat1.getId();
        String threat2Id = this.threat2.getId();
        String threat3Id = this.threat3.getId();
        this.performPrimaryAssetTransition(this.getObjects(new String[]{pa1Id}));
        this.pa1 = (PrimaryAsset)this.mustBeTransitioned(pa1Id);
        this.shouldNotBeTransitioned(threat1Id);
        this.shouldNotBeTransitioned(threat2Id);
        this.shouldNotBeTransitioned(pa2Id);
        BlockArchitecture ba = BlockArchitectureExt.getRootBlockArchitecture((EObject)this.pa1);
        CybersecurityPkg pkgDest = new CybersecurityServices().getRootCibersecurityPkg(ba);
        CybersecurityMiscTransitionTest.assertNotNull((String)"Cybersecurity package not created!", (Object)pkgDest);
        int countThreats = pkgDest.getOwnedThreats().size();
        int countPAs = pkgDest.getOwnedPrimaryAssets().size();
        this.performThreatTransition(this.getObjects(new String[]{threat1Id}));
        this.mustBeTransitioned(threat1Id, (EObject)pkgDest);
        this.shouldNotBeTransitioned(threat2Id);
        this.shouldNotBeTransitioned(pa2Id);
        this.threat1.setLevel(2);
        this.performThreatTransition(this.getObjects(new String[]{threat1Id}));
        this.threat1 = (Threat)this.mustBeTransitioned(threat1Id, (EObject)pkgDest);
        CybersecurityMiscTransitionTest.assertEquals((int)this.threat1.getLevel(), (int)2);
        this.performCybersecurityTransition(this.getObjects(new String[]{pa1Id, threat1Id, threat2Id}));
        this.threat2 = (Threat)this.mustBeTransitioned(threat2Id, (EObject)pkgDest);
        CybersecurityMiscTransitionTest.assertEquals((int)pkgDest.getOwnedThreats().size(), (int)(countThreats + 2));
        CybersecurityMiscTransitionTest.assertEquals((int)pkgDest.getOwnedPrimaryAssets().size(), (int)countPAs);
        this.performCybersecurityTransition(this.getObjects(new String[]{pkgSrc.getId()}));
        this.threat3 = (Threat)this.mustBeTransitioned(threat3Id, (EObject)pkgDest);
        this.pa2 = (PrimaryAsset)this.mustBeTransitioned(pa2Id, (EObject)pkgDest);
        this.pa3 = (PrimaryAsset)this.mustBeTransitioned(pa3Id, (EObject)pkgDest);
        return pkgDest;
    }
}

