/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.rules.testcases.cy_dcon;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.skeleton.CapellaModelSkeleton;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.test.common.DynamicValidationTest;

public abstract class Abstract_Rule_CY_DCON_03<T>
extends DynamicValidationTest {
    protected String RULE;
    private T elementOA;
    private T elementOAko;
    private T elementSA;
    private T elementSAko;
    private T elementLA;
    private T elementLAko;
    private T elementPA;

    @Override
    protected void initModel(CapellaModelSkeleton skeleton2) {
        this.elementOA = this.createElement("OA");
        this.elementOAko = this.createElement("OA");
        this.elementSA = this.createElement("SA");
        this.elementSAko = this.createElement("SA");
        this.linkElements((TraceableElement)this.elementSA, (TraceableElement)this.elementOA);
        this.elementLA = this.createElement("LA");
        this.elementLAko = this.createElement("LA");
        this.linkElements((TraceableElement)this.elementLA, (TraceableElement)this.elementSA);
        this.elementPA = this.createElement("PA");
        this.linkElements((TraceableElement)this.elementPA, (TraceableElement)this.elementLA);
        this.setRule();
    }

    public void test() throws Exception {
        this.ok((EObject)this.elementOA, this.RULE);
        this.ok((EObject)this.elementSA, this.RULE);
        this.ok((EObject)this.elementLA, this.RULE);
        this.ko((EObject)this.elementOAko, this.RULE);
        this.ko((EObject)this.elementSAko, this.RULE);
        this.ko((EObject)this.elementLAko, this.RULE);
        this.ok((EObject)this.elementPA, this.RULE);
    }

    private T createElement(String arhitecture) {
        CybersecurityPkg pkg = CybersecurityFactory.eINSTANCE.createCybersecurityPkg();
        T element = this.createElement();
        this.getElementsFromCybersecurityPkg(pkg).add(element);
        if (arhitecture.equals("OA")) {
            this.skeleton.getOperationalAnalysis().getOwnedExtensions().add((Object)pkg);
        } else if (arhitecture.equals("SA")) {
            this.skeleton.getSystemAnalysis().getOwnedExtensions().add((Object)pkg);
        } else if (arhitecture.equals("LA")) {
            this.skeleton.getLogicalArchitecture().getOwnedExtensions().add((Object)pkg);
        } else if (arhitecture.equals("PA")) {
            this.skeleton.getPhysicalArchitecture().getOwnedExtensions().add((Object)pkg);
        }
        return element;
    }

    private void linkElements(TraceableElement source, TraceableElement target) {
        TransfoLink link = CapellacommonFactory.eINSTANCE.createTransfoLink();
        link.setSourceElement(source);
        link.setTargetElement(target);
        this.addLinkIntoArhitecture(link, source);
    }

    private void addLinkIntoArhitecture(TransfoLink link, TraceableElement element) {
        BlockArchitecture arhitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        if (arhitecture instanceof OperationalAnalysis) {
            this.skeleton.getOperationalAnalysis().getOwnedTraces().add((Object)link);
        } else if (arhitecture instanceof SystemAnalysis) {
            this.skeleton.getSystemAnalysis().getOwnedTraces().add((Object)link);
        } else if (arhitecture instanceof LogicalArchitecture) {
            this.skeleton.getLogicalArchitecture().getOwnedTraces().add((Object)link);
        } else if (arhitecture instanceof PhysicalArchitecture) {
            this.skeleton.getPhysicalArchitecture().getOwnedTraces().add((Object)link);
        }
    }

    protected abstract void setRule();

    protected abstract T createElement();

    protected abstract EList<T> getElementsFromCybersecurityPkg(CybersecurityPkg var1);
}

