/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.diagram;

import java.util.Arrays;
import java.util.List;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.diagram.DDiagram;
import org.junit.Assert;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.test.diagram.CyberPABDiagram;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.EObjectHelper;
import org.polarsys.capella.test.framework.helpers.SessionHelper;

public class CyberDagramStatus
extends BasicTestCase {
    private static final String projectTestName = "CybersecurityModel";
    private static final String diagramName = "[PAB] Structure Test Dirty";
    private static final String PA_ID = "c7bd438d-76f0-4c37-a4f6-de3a82fa6550";

    public void test() throws Exception {
        Session session = this.getSession(projectTestName);
        SessionContext context = new SessionContext(session);
        CapellaModel model = this.getTestModel(this.getRequiredTestModels().get(0));
        CyberPABDiagram diagram = CyberPABDiagram.openDiagram(context, diagramName);
        Assert.assertTrue((String)"Session is dirty", (boolean)SessionStatus.SYNC.equals((Object)session.getStatus()));
        boolean ret = DiagramHelper.refreshDiagram((DDiagram)diagram.getDiagram());
        Assert.assertTrue((String)"Failed to refresh diagram", (boolean)ret);
        Assert.assertTrue((String)"Session is dirty", (boolean)SessionStatus.SYNC.equals((Object)session.getStatus()));
        PrimaryAsset pa = (PrimaryAsset)EObjectHelper.getObject((IModel)model, (String)PA_ID);
        diagram.insertPrimaryAsset(pa);
        Assert.assertTrue((String)"Session is dirty", (boolean)SessionStatus.DIRTY.equals((Object)session.getStatus()));
        SessionHelper.saveSession((Session)this.getSession(projectTestName));
        DiagramHelper.refreshDiagram((DDiagram)diagram.getDiagram());
        Assert.assertTrue((String)"Session is dirty", (boolean)SessionStatus.SYNC.equals((Object)session.getStatus()));
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList(projectTestName);
    }
}

