/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.engine.ir.VisibilityRuleDesign;
import org.eclipse.birt.report.engine.parser.ReportParser;

public class EngineIRParserTest
extends TestCase {
    protected Report loadDesign(String design) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(design);
        EngineIRParserTest.assertTrue((in != null ? 1 : 0) != 0);
        ReportParser parser = new ReportParser();
        return parser.parse("", in);
    }

    public void testReportItemDesign() throws Exception {
        Report report = this.loadDesign("report_item_test.rptdesign");
        ReportItemDesign item = report.getContent(0);
        long ID = item.getID();
        String name = item.getName();
        String extend = item.getExtends();
        String javaClass = item.getJavaClass();
        DimensionType x = item.getX();
        DimensionType y = item.getY();
        DimensionType width = item.getWidth();
        DimensionType height = item.getHeight();
        Expression onCreate = item.getOnCreate();
        Expression onRender = item.getOnRender();
        Expression onPageBreak = item.getOnPageBreak();
        boolean useCachedResult = item.useCachedResult();
        EngineIRParserTest.assertEquals((long)7L, (long)ID);
        EngineIRParserTest.assertEquals((String)"name", (String)name);
        EngineIRParserTest.assertEquals(null, (String)extend);
        EngineIRParserTest.assertEquals((String)"javaEventHandle", (String)javaClass);
        EngineIRParserTest.assertEquals((String)"1in", (String)x.toString());
        EngineIRParserTest.assertEquals((String)"1in", (String)y.toString());
        EngineIRParserTest.assertEquals((String)"1in", (String)width.toString());
        EngineIRParserTest.assertEquals((String)"1in", (String)height.toString());
        EngineIRParserTest.assertEquals((String)"onCreate", (String)onCreate.getScriptText());
        EngineIRParserTest.assertEquals((String)"onRender", (String)onRender.getScriptText());
        EngineIRParserTest.assertEquals((String)"onPageBreak", (String)onPageBreak.getScriptText());
        EngineIRParserTest.assertEquals((boolean)false, (boolean)useCachedResult);
    }

    public void testBookmark() throws Exception {
        Report report = this.loadDesign("bookmark_test.rptdesign");
        ReportItemDesign item = report.getContent(0);
        Expression bookmark = item.getBookmark();
        EngineIRParserTest.assertEquals((int)1, (int)bookmark.getType());
        EngineIRParserTest.assertEquals((String)"bookmark-expr", (String)bookmark.getScriptText());
        item = report.getContent(1);
        bookmark = item.getBookmark();
        EngineIRParserTest.assertEquals((int)0, (int)bookmark.getType());
        EngineIRParserTest.assertEquals((String)"bookmark-value", (String)bookmark.getScriptText());
    }

    public void testTOC() throws Exception {
        Report report = this.loadDesign("toc_test.rptdesign");
        ReportItemDesign item = report.getContent(0);
        Expression toc = item.getTOC();
        EngineIRParserTest.assertEquals((int)1, (int)toc.getType());
        EngineIRParserTest.assertEquals((String)"toc-expr", (String)toc.getScriptText());
        item = report.getContent(1);
        toc = item.getTOC();
        EngineIRParserTest.assertEquals((int)0, (int)toc.getType());
        EngineIRParserTest.assertEquals((String)"toc-value", (String)toc.getScriptText());
    }

    public void testUserProperty() throws Exception {
        Report report = this.loadDesign("user_property_test.rptdesign");
        Map exprs = report.getUserProperties();
        EngineIRParserTest.assertEquals((int)1, (int)exprs.size());
        EngineIRParserTest.assertExpression("report_expr", (Expression)exprs.get("report_expr"));
        ReportItemDesign item = report.getContent(0);
        exprs = item.getUserProperties();
        EngineIRParserTest.assertEquals((int)7, (int)exprs.size());
        EngineIRParserTest.assertExpression("name_expression", (Expression)exprs.get("name_expr"));
        EngineIRParserTest.assertExpression("name_value", (Expression)exprs.get("name_value"));
        EngineIRParserTest.assertConstant("string", (Expression)exprs.get("name_string"));
        EngineIRParserTest.assertConstant("1", (Expression)exprs.get("name_integer"));
        EngineIRParserTest.assertConstant("true", (Expression)exprs.get("name_boolean"));
        EngineIRParserTest.assertConstant("2009-06-03 00:00:00", (Expression)exprs.get("name_datetime"));
        EngineIRParserTest.assertConstant("1.0", (Expression)exprs.get("name_float"));
    }

    public void testMap() throws Exception {
        Report report = this.loadDesign("map_test.rptdesign");
        ReportItemDesign item = report.getContent(0);
        MapDesign map = item.getMap();
        EngineIRParserTest.assertEquals((int)4, (int)map.getRuleCount());
        MapRuleDesign rule = map.getRule(0);
        EngineIRParserTest.assertEquals((String)"value", (String)rule.getDisplayText());
        EngineIRParserTest.assertEquals((String)"value-key", (String)rule.getDisplayKey());
        EngineIRParserTest.assertEquals((String)"between", (String)rule.getOperator());
        EngineIRParserTest.assertConstant("value", rule.getTestExpression());
        EngineIRParserTest.assertConstant("value", rule.getValue1());
        EngineIRParserTest.assertConstant("value", rule.getValue2());
        rule = map.getRule(1);
        EngineIRParserTest.assertEquals((String)"expr", (String)rule.getDisplayText());
        EngineIRParserTest.assertEquals((String)"expr-key", (String)rule.getDisplayKey());
        EngineIRParserTest.assertEquals((String)"between", (String)rule.getOperator());
        EngineIRParserTest.assertExpression("expr", rule.getTestExpression());
        EngineIRParserTest.assertExpression("expr", rule.getValue1());
        EngineIRParserTest.assertExpression("expr", rule.getValue2());
        rule = map.getRule(2);
        EngineIRParserTest.assertEquals((String)"value", (String)rule.getDisplayText());
        EngineIRParserTest.assertEquals((String)"value-key", (String)rule.getDisplayKey());
        EngineIRParserTest.assertEquals((String)"in", (String)rule.getOperator());
        EngineIRParserTest.assertConstant("value", rule.getTestExpression());
        List exprs = rule.getValue1List();
        EngineIRParserTest.assertEquals((int)3, (int)exprs.size());
        for (Expression expr : exprs) {
            EngineIRParserTest.assertConstant("value", expr);
        }
        EngineIRParserTest.assertEquals(null, (Object)rule.getValue2());
        rule = map.getRule(3);
        EngineIRParserTest.assertEquals((String)"expr", (String)rule.getDisplayText());
        EngineIRParserTest.assertEquals((String)"expr-key", (String)rule.getDisplayKey());
        EngineIRParserTest.assertEquals((String)"in", (String)rule.getOperator());
        EngineIRParserTest.assertExpression("expr", rule.getTestExpression());
        exprs = rule.getValue1List();
        EngineIRParserTest.assertEquals((int)3, (int)exprs.size());
        for (Expression expr : exprs) {
            EngineIRParserTest.assertExpression("expr", expr);
        }
        EngineIRParserTest.assertEquals(null, (Object)rule.getValue2());
    }

    public void testHighlight() throws Exception {
        Report report = this.loadDesign("highlight_test.rptdesign");
        ReportItemDesign item = report.getContent(0);
        HighlightDesign highlight = item.getHighlight();
        EngineIRParserTest.assertEquals((int)1, (int)highlight.getRuleCount());
        HighlightRuleDesign rule = highlight.getRule(0);
        EngineIRParserTest.assertEquals((String)"between", (String)rule.getOperator());
        Expression expr = rule.getTestExpression();
        EngineIRParserTest.assertEquals((int)1, (int)expr.getType());
        EngineIRParserTest.assertEquals((String)"expr", (String)expr.getScriptText());
        expr = rule.getValue1();
        EngineIRParserTest.assertEquals((int)1, (int)expr.getType());
        EngineIRParserTest.assertEquals((String)"expr", (String)expr.getScriptText());
        expr = rule.getValue2();
        EngineIRParserTest.assertEquals((int)1, (int)expr.getType());
        EngineIRParserTest.assertEquals((String)"expr", (String)expr.getScriptText());
        IStyle style = rule.getStyle();
        EngineIRParserTest.assertEquals((int)1, (int)style.getLength());
        EngineIRParserTest.assertEquals((String)"serif", (String)style.getFontFamily());
    }

    public void testVisibility() throws Exception {
        Report report = this.loadDesign("visibility_test.rptdesign");
        ReportItemDesign item = report.getContent(0);
        VisibilityDesign visibility = item.getVisibility();
        EngineIRParserTest.assertEquals((int)1, (int)visibility.count());
        VisibilityRuleDesign rule = visibility.getRule(0);
        Expression expr = rule.getExpression();
        EngineIRParserTest.assertEquals((String)"all", (String)rule.getFormat());
        EngineIRParserTest.assertEquals((int)1, (int)expr.getType());
        EngineIRParserTest.assertEquals((String)"true", (String)expr.getScriptText());
        item = report.getContent(1);
        visibility = item.getVisibility();
        EngineIRParserTest.assertEquals((int)1, (int)visibility.count());
        rule = visibility.getRule(0);
        expr = rule.getExpression();
        EngineIRParserTest.assertEquals((String)"all", (String)rule.getFormat());
        EngineIRParserTest.assertEquals((int)0, (int)expr.getType());
        EngineIRParserTest.assertEquals((String)"true", (String)expr.getScriptText());
    }

    public void testAction() throws Exception {
        Report report = this.loadDesign("action_test.rptdesign");
        ActionDesign action = report.getContent(0).getAction();
        EngineIRParserTest.assertEquals((int)1, (int)action.getActionType());
        EngineIRParserTest.assertEquals((String)"_blank", (String)action.getTargetWindow());
        EngineIRParserTest.assertExpression("uri-expr", action.getHyperlink());
        EngineIRParserTest.assertEquals((String)"tooltips", (String)action.getTooltip());
        EngineIRParserTest.assertEquals(null, (Object)action.getBookmark());
        EngineIRParserTest.assertEquals(null, (Object)action.getDrillThrough());
        action = report.getContent(1).getAction();
        EngineIRParserTest.assertEquals((int)1, (int)action.getActionType());
        EngineIRParserTest.assertConstant("uri-value", action.getHyperlink());
        action = report.getContent(2).getAction();
        EngineIRParserTest.assertEquals((int)2, (int)action.getActionType());
        EngineIRParserTest.assertEquals(null, (Object)action.getHyperlink());
        EngineIRParserTest.assertExpression("bookmark-expr", action.getBookmark());
        EngineIRParserTest.assertEquals(null, (Object)action.getDrillThrough());
        action = report.getContent(3).getAction();
        EngineIRParserTest.assertEquals((int)2, (int)action.getActionType());
        EngineIRParserTest.assertConstant("bookmark-value", action.getBookmark());
        action = report.getContent(4).getAction();
        EngineIRParserTest.assertEquals((int)3, (int)action.getActionType());
        EngineIRParserTest.assertEquals(null, (Object)action.getBookmark());
        EngineIRParserTest.assertEquals(null, (Object)action.getHyperlink());
        DrillThroughActionDesign drill = action.getDrillThrough();
        EngineIRParserTest.assertEquals((String)"report-design", (String)drill.getTargetFileType());
        EngineIRParserTest.assertConstant("design-expr", drill.getReportName());
        EngineIRParserTest.assertEquals((boolean)true, (boolean)drill.getBookmarkType());
        EngineIRParserTest.assertExpression("bookmark-expr", drill.getBookmark());
        EngineIRParserTest.assertEquals((String)"xls", (String)drill.getFormat());
        Map exprs = drill.getParameters();
        EngineIRParserTest.assertEquals((int)2, (int)exprs.size());
        EngineIRParserTest.assertExpression("param-expr", (Expression)((List)exprs.get("param-expr")).get(0));
        EngineIRParserTest.assertConstant("param-value", (Expression)((List)exprs.get("param-value")).get(0));
        action = report.getContent(5).getAction();
        EngineIRParserTest.assertEquals((int)3, (int)action.getActionType());
        drill = action.getDrillThrough();
        EngineIRParserTest.assertEquals((String)"report-design", (String)drill.getTargetFileType());
        EngineIRParserTest.assertConstant("design-value", drill.getReportName());
        EngineIRParserTest.assertEquals((boolean)false, (boolean)drill.getBookmarkType());
        EngineIRParserTest.assertConstant("bookmark-value", drill.getBookmark());
        action = report.getContent(6).getAction();
        EngineIRParserTest.assertEquals((int)3, (int)action.getActionType());
        drill = action.getDrillThrough();
        EngineIRParserTest.assertEquals((String)"report-document", (String)drill.getTargetFileType());
        EngineIRParserTest.assertConstant("document-expr", drill.getReportName());
        action = report.getContent(7).getAction();
        EngineIRParserTest.assertEquals((int)3, (int)action.getActionType());
        drill = action.getDrillThrough();
        EngineIRParserTest.assertEquals((String)"report-document", (String)drill.getTargetFileType());
        EngineIRParserTest.assertConstant("document-value", drill.getReportName());
    }

    public void testCell() throws Exception {
        Report report = this.loadDesign("cell_test.rptdesign");
        GridItemDesign grid = (GridItemDesign)report.getContent(0);
        RowDesign row = grid.getRow(0);
        CellDesign cell = row.getCell(0);
        EngineIRParserTest.assertEquals((String)"blue", (String)cell.getDiagonalColor());
        EngineIRParserTest.assertEquals((int)1, (int)cell.getDiagonalNumber());
        EngineIRParserTest.assertEquals((String)"solid", (String)cell.getDiagonalStyle());
        EngineIRParserTest.assertEquals((String)"thick", (String)cell.getDiagonalWidth().toString());
        EngineIRParserTest.assertEquals((String)"red", (String)cell.getAntidiagonalColor());
        EngineIRParserTest.assertEquals((int)1, (int)cell.getAntidiagonalNumber());
        EngineIRParserTest.assertEquals((String)"solid", (String)cell.getAntidiagonalStyle());
        EngineIRParserTest.assertEquals((String)"thick", (String)cell.getAntidiagonalWidth().toString());
        EngineIRParserTest.assertEquals((String)"colgroup", (String)cell.getScope());
        EngineIRParserTest.assertExpression("bookmark-expr", cell.getBookmark());
        EngineIRParserTest.assertExpression("header-expr", cell.getHeaders());
        cell = row.getCell(1);
        EngineIRParserTest.assertConstant("bookmark-value", cell.getBookmark());
        EngineIRParserTest.assertConstant("header-value", cell.getHeaders());
    }

    protected static void assertConstant(String value, Expression expr) {
        EngineIRParserTest.assertEquals((int)0, (int)expr.getType());
        EngineIRParserTest.assertEquals((String)value, (String)expr.getScriptText());
    }

    protected static void assertExpression(String value, Expression expr) {
        EngineIRParserTest.assertEquals((int)1, (int)expr.getType());
        EngineIRParserTest.assertEquals((String)value, (String)expr.getScriptText());
    }
}

