/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.testutil;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PrivateAccessor {
    private PrivateAccessor() {
    }

    public static Object getField(Object object, String name) throws NoSuchFieldException {
        if (object == null) {
            throw new IllegalArgumentException("Invalid null object argument");
        }
        Class<?> cls = object.getClass();
        while (cls != null) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return field.get(object);
            }
            catch (Exception exception) {
                cls = cls.getSuperclass();
            }
        }
        throw new NoSuchFieldException("Could get value for field " + object.getClass().getName() + "." + name);
    }

    public static Object getField(Class cls, String name) throws NoSuchFieldException {
        if (cls == null) {
            throw new IllegalArgumentException("Invalid null cls argument");
        }
        Class base = cls;
        while (base != null) {
            try {
                Field field = base.getDeclaredField(name);
                field.setAccessible(true);
                return field.get(base);
            }
            catch (Exception exception) {
                base = base.getSuperclass();
            }
        }
        throw new NoSuchFieldException("Could get value for static field " + cls.getName() + "." + name);
    }

    public static void setField(Object object, String name, Object value) throws NoSuchFieldException {
        if (object == null) {
            throw new IllegalArgumentException("Invalid null object argument");
        }
        Class<?> cls = object.getClass();
        while (cls != null) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                field.set(object, value);
                return;
            }
            catch (Exception exception) {
                cls = cls.getSuperclass();
            }
        }
        throw new NoSuchFieldException("Could set value for field " + object.getClass().getName() + "." + name);
    }

    public static void setField(Class cls, String name, Object value) throws NoSuchFieldException {
        if (cls == null) {
            throw new IllegalArgumentException("Invalid null cls argument");
        }
        Class base = cls;
        while (base != null) {
            try {
                Field field = base.getDeclaredField(name);
                field.setAccessible(true);
                field.set(base, value);
                return;
            }
            catch (Exception exception) {
                base = base.getSuperclass();
            }
        }
        throw new NoSuchFieldException("Could set value for static field " + cls.getName() + "." + name);
    }

    public static Object invoke(Object object, String name, Class[] parameterTypes, Object[] args) throws Throwable {
        if (object == null) {
            throw new IllegalArgumentException("Invalid null object argument");
        }
        Class<?> cls = object.getClass();
        while (cls != null) {
            try {
                Method method = cls.getDeclaredMethod(name, parameterTypes);
                method.setAccessible(true);
                return method.invoke(object, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception exception) {
                cls = cls.getSuperclass();
            }
        }
        throw new NoSuchMethodException("Failed method invocation: " + object.getClass().getName() + "." + name + "()");
    }

    public static Object invoke(Class cls, String name, Class[] parameterTypes, Object[] args) throws Throwable {
        if (cls == null) {
            throw new IllegalArgumentException("Invalid null cls argument");
        }
        Class base = cls;
        while (base != null) {
            try {
                Method method = base.getDeclaredMethod(name, parameterTypes);
                method.setAccessible(true);
                return method.invoke(base, args);
            }
            catch (InvocationTargetException e) {
                throw (Exception)e.getTargetException();
            }
            catch (Exception exception) {
                base = base.getSuperclass();
            }
        }
        throw new NoSuchMethodException("Failed static method invocation: " + cls.getName() + "." + name + "()");
    }

    public static Object newInstance(Class cls) throws Exception {
        return PrivateAccessor.newInstance(cls, new Class[0], new Object[0]);
    }

    public static Object newInstance(Class cls, Class[] types, Object[] args) throws Exception {
        if (cls == null) {
            throw new IllegalArgumentException("Invalid null object argument");
        }
        Constructor constructor = cls.getDeclaredConstructor(types);
        constructor.setAccessible(true);
        return constructor.newInstance(args);
    }
}

