/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.IChartComputation;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.device.TextRendererAdapter;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.swing.SwingRendererImpl;
import org.eclipse.birt.chart.device.swing.SwingTextMetrics;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.util.ChartUtil;

final class SwingTextRenderer
extends TextRendererAdapter {
    SwingTextRenderer(IDisplayServer sxs) {
        super(sxs);
    }

    public void renderShadowAtLocation(IPrimitiveRenderer idr, int iLabelPosition, Location lo, Label la) throws ChartException {
        if (!ChartUtil.isShadowDefined((Label)la)) {
            return;
        }
        ColorDefinition cdShadow = la.getShadowColor();
        if (cdShadow == null) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingTextMetrics.exception.undefined.shadow.color", Messages.getResourceBundle(this._sxs.getULocale()));
        }
        Graphics2D g2d = (Graphics2D)((IDeviceRenderer)idr).getGraphicsContext();
        g2d.setFont((Font)this._sxs.createFont(la.getCaption().getFont()));
        this.computeTextAntialiasing(g2d, la.getCaption().getFont());
        switch (iLabelPosition & 0x3F) {
            case 4: {
                this.showTopValue(idr, lo, la, iLabelPosition, true);
                break;
            }
            case 8: {
                this.showBottomValue(idr, lo, la, iLabelPosition, true);
                break;
            }
            case 1: {
                this.showLeftValue(idr, lo, la, iLabelPosition, true);
                break;
            }
            case 2: {
                this.showRightValue(idr, lo, la, iLabelPosition, true);
            }
        }
    }

    public void renderTextAtLocation(IPrimitiveRenderer ipr, int iLabelPosition, Location lo, Label la) throws ChartException {
        ColorDefinition cdText = la.getCaption().getColor();
        if (cdText == null) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingTextMetrics.exception.undefined.text.color", Messages.getResourceBundle(this._sxs.getULocale()));
        }
        Graphics2D g2d = (Graphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
        g2d.setFont((Font)this._sxs.createFont(la.getCaption().getFont()));
        this.computeTextAntialiasing(g2d, la.getCaption().getFont());
        switch (iLabelPosition & 0x3F) {
            case 4: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showTopValue(ipr, lo, la, iLabelPosition, true);
                }
                this.showTopValue(ipr, lo, la, iLabelPosition, false);
                break;
            }
            case 8: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showBottomValue(ipr, lo, la, iLabelPosition, true);
                }
                this.showBottomValue(ipr, lo, la, iLabelPosition, false);
                break;
            }
            case 1: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showLeftValue(ipr, lo, la, iLabelPosition, true);
                }
                this.showLeftValue(ipr, lo, la, iLabelPosition, false);
                break;
            }
            case 2: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showRightValue(ipr, lo, la, iLabelPosition, true);
                }
                this.showRightValue(ipr, lo, la, iLabelPosition, false);
                break;
            }
            case 32: {
                if (ChartUtil.isShadowDefined((Label)la)) {
                    this.showCenterValue(ipr, lo, la, true);
                }
                this.showCenterValue(ipr, lo, la, false);
            }
        }
    }

    public void renderTextInBlock(IDeviceRenderer idr, Bounds boBlock, TextAlignment taBlock, Label la) throws ChartException {
        Text t = la.getCaption();
        String sText = t.getValue();
        FontDefinition fd = t.getFont();
        ColorDefinition cdText = t.getColor();
        if (cdText == null) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingTextMetrics.exception.undefined.text.color", Messages.getResourceBundle(this._sxs.getULocale()));
        }
        IDisplayServer xs = idr.getDisplayServer();
        Graphics2D g2d = (Graphics2D)idr.getGraphicsContext();
        g2d.setFont((Font)xs.createFont(fd));
        this.computeTextAntialiasing(g2d, la.getCaption().getFont());
        la.getCaption().setValue(sText);
        BoundingBox bb = idr.getChartComputation().computeBox(xs, 4, la, 0.0, 0.0);
        if (taBlock == null) {
            taBlock = goFactory.createTextAlignment();
            taBlock.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            taBlock.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
        }
        HorizontalAlignment haBlock = taBlock.getHorizontalAlignment();
        VerticalAlignment vaBlock = taBlock.getVerticalAlignment();
        switch (haBlock.getValue()) {
            case 1: {
                bb.setLeft(boBlock.getLeft() + (boBlock.getWidth() - bb.getWidth()) / 2.0);
                break;
            }
            case 0: {
                bb.setLeft(boBlock.getLeft());
                break;
            }
            case 2: {
                bb.setLeft(boBlock.getLeft() + boBlock.getWidth() - bb.getWidth());
            }
        }
        switch (vaBlock.getValue()) {
            case 0: {
                bb.setTop(boBlock.getTop());
                break;
            }
            case 1: {
                bb.setTop(boBlock.getTop() + (boBlock.getHeight() - bb.getHeight()) / 2.0);
                break;
            }
            case 2: {
                bb.setTop(boBlock.getTop() + boBlock.getHeight() - bb.getHeight());
            }
        }
        bb.setLeft(bb.getLeft() + bb.getHotPoint());
        if (ChartUtil.isShadowDefined((Label)la)) {
            this.showTopValue((IPrimitiveRenderer)idr, goFactory.createLocation(bb.getLeft(), bb.getTop() + bb.getHeight()), la, 0, true);
        }
        this.showTopValue((IPrimitiveRenderer)idr, goFactory.createLocation(bb.getLeft(), bb.getTop() + bb.getHeight()), la, 0, false);
    }

    private void showLeftValue(IPrimitiveRenderer ipr, Location lo, Label la, int iLabelPosition, boolean bShadow) {
        IDeviceRenderer idr = (IDeviceRenderer)ipr;
        IChartComputation cComp = idr.getChartComputation();
        Graphics2D g2d = (Graphics2D)idr.getGraphicsContext();
        FontDefinition fd = la.getCaption().getFont();
        double dAngleInDegrees = fd.getRotation();
        if (bShadow) {
            bShadow = la.getShadowColor() != null;
        }
        Color clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        Color clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        double dSineTheta = Math.sin(dAngleInRadians);
        double dCosTheta = Math.cos(dAngleInRadians);
        ITextMetrics itm = cComp.getTextMetrics(this._sxs, la, 0.0);
        AffineTransform afTransform = g2d.getTransform();
        lo = this.adjustTextPosition(iLabelPosition, lo, itm, dAngleInDegrees);
        double dX = lo.getX();
        double dY = lo.getY();
        try {
            double dFW = itm.getFullWidth();
            double dH = itm.getHeight();
            double dD = itm.getDescent();
            double dFH = itm.getFullHeight();
            double dXOffset = 0.0;
            double dW = 0.0;
            int iLC = itm.getLineCount();
            Insets ins = la.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
            double shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
            boolean bEmptyText = "".equals(la.getCaption().getValue());
            HorizontalAlignment ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
            boolean bRightAligned = ha.getValue() == 2;
            boolean bCenterAligned = ha.getValue() == 1;
            double dRotateX = dX - dFW;
            double dRotateY = dY + dH / 2.0;
            dX -= dFW;
            dY += dH / 2.0;
            if (dAngleInDegrees == 0.0) {
                double dYHalfOffset = (dFH + dH) / 2.0;
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dYHalfOffset + ins.getTop() + dH * (double)(i + 1) - dD));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                double dDeltaX = dFW - dFW * dCosTheta;
                double dDeltaY = dFW * dSineTheta + dH / 2.0 - dH * dCosTheta / 2.0;
                dX += dDeltaX;
                dY -= dDeltaY;
                g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < itm.getLineCount()) {
                            int index = iLC - i - 1;
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(index);
                            if (bRightAligned) {
                                dW = itm.getWidth(index);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(index);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                double dDeltaX = dFW - dFW * dCosTheta - dH * dSineTheta;
                double dDeltaY = dFW * dSineTheta - dH / 2.0 + dH * dCosTheta / 2.0;
                dX += dDeltaX;
                dY -= dDeltaY;
                g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees == 90.0) {
                double dDeltaX = dFW;
                double dDeltaY = (dFW - dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)(iLC - i - 1) + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees == -90.0) {
                double dDeltaX = dFW - dH;
                double dDeltaY = (dFW + dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            }
        }
        finally {
            g2d.setTransform(afTransform);
            cComp.recycleTextMetrics(itm);
        }
    }

    private void showRightValue(IPrimitiveRenderer ipr, Location lo, Label la, int iLabelPosition, boolean bShadow) {
        IDeviceRenderer idr = (IDeviceRenderer)ipr;
        IChartComputation cComp = idr.getChartComputation();
        Graphics2D g2d = (Graphics2D)idr.getGraphicsContext();
        FontDefinition fd = la.getCaption().getFont();
        double dAngleInDegrees = fd.getRotation();
        if (bShadow) {
            bShadow = la.getShadowColor() != null;
        }
        Color clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        Color clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        ITextMetrics itm = cComp.getTextMetrics(this._sxs, la, 0.0);
        AffineTransform afTransform = g2d.getTransform();
        lo = this.adjustTextPosition(iLabelPosition, lo, itm, dAngleInDegrees);
        double dX = lo.getX();
        double dY = lo.getY();
        dY += 1.0;
        try {
            double dFW = itm.getFullWidth();
            double dH = itm.getHeight();
            double dD = itm.getDescent();
            double dFH = itm.getFullHeight();
            double dXOffset = 0.0;
            double dW = 0.0;
            int iLC = itm.getLineCount();
            Insets ins = la.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
            double shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
            boolean bEmptyText = "".equals(la.getCaption().getValue());
            HorizontalAlignment ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
            boolean bRightAligned = ha.getValue() == 2;
            boolean bCenterAligned = ha.getValue() == 1;
            double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
            int iRotateX = (int)dX;
            int iRotateY = (int)(dY + dH / 2.0);
            dY += dH / 2.0;
            double dCosTheta = Math.abs(Math.cos(dAngleInRadians));
            if (dAngleInDegrees == 0.0) {
                double dYHalfOffset = (dFH + dH) / 2.0;
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dYHalfOffset + ins.getTop() + dH * (double)(i + 1) - dD));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                double dDeltaX = dH * Math.sin(dAngleInRadians);
                double dDeltaY = dH / 2.0 - dH * dCosTheta / 2.0;
                dX -= dDeltaX;
                dY += dDeltaY;
                g2d.rotate(dAngleInRadians, (double)iRotateX - dDeltaX, (double)iRotateY + dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                double dDeltaY = -dH / 2.0 + dH * dCosTheta / 2.0;
                dY += dDeltaY;
                g2d.rotate(dAngleInRadians, iRotateX, (double)iRotateY + dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)(iLC - i - 1) - ins.getBottom()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees == 90.0) {
                double dDeltaX = dH;
                double dDeltaY = (dFW - dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees == -90.0) {
                double dDeltaX = 0.0;
                double dDeltaY = (dFW + dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            }
        }
        finally {
            g2d.setTransform(afTransform);
            cComp.recycleTextMetrics(itm);
        }
    }

    private void showBottomValue(IPrimitiveRenderer ipr, Location lo, Label la, int iLabelPosition, boolean bShadow) {
        IDeviceRenderer idr = (IDeviceRenderer)ipr;
        IChartComputation cComp = idr.getChartComputation();
        Graphics2D g2d = (Graphics2D)idr.getGraphicsContext();
        FontDefinition fd = la.getCaption().getFont();
        double dAngleInDegrees = fd.getRotation();
        Color clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        Color clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        ITextMetrics itm = cComp.getTextMetrics(this._sxs, la, 0.0);
        AffineTransform afTransform = g2d.getTransform();
        lo = this.adjustTextPosition(iLabelPosition, lo, itm, dAngleInDegrees);
        double dX = lo.getX();
        double dY = lo.getY();
        try {
            double dFW = itm.getFullWidth();
            double dH = itm.getHeight();
            double dD = itm.getDescent();
            double dFH = itm.getFullHeight();
            double dXOffset = 0.0;
            double dW = 0.0;
            int iLC = itm.getLineCount();
            Insets ins = la.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
            double shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
            boolean bEmptyText = "".equals(la.getCaption().getValue());
            HorizontalAlignment ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
            boolean bRightAligned = ha.getValue() == 2;
            boolean bCenterAligned = ha.getValue() == 1;
            dX -= dFW / 2.0;
            dY += dH;
            double dSineTheta = Math.abs(Math.sin(dAngleInRadians));
            double dCosTheta = Math.abs(Math.cos(dAngleInRadians));
            if (dAngleInDegrees == 0.0) {
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                double dDeltaX = dFW * dCosTheta - dH * dSineTheta / 2.0 - dFW / 2.0;
                double dDeltaY = dH * dCosTheta + dFW * dSineTheta - dH;
                g2d.rotate(dAngleInRadians, dX -= dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                g2d.rotate(dAngleInRadians, dX += dFW / 2.0 + dH * dSineTheta / 2.0, dY - dH);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees == 90.0) {
                double dYHalfOffset = (dFH + dH) / 2.0;
                double dDeltaX = (dFW + dH) / 2.0;
                double dDeltaY = dFW - dH;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - ((double)(iLC - i) * dH - (double)(iLC + 1) * dH / 2.0) + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees == -90.0) {
                dX += dFW / 2.0;
                double dYHalfOffset = (dFH + dH) / 2.0;
                double dDeltaX = dYHalfOffset - dFH / 2.0;
                g2d.rotate(dAngleInRadians, dX -= dDeltaX, dY -= dH);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dYHalfOffset + dH * (double)(i + 1) + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            }
        }
        finally {
            g2d.setTransform(afTransform);
            cComp.recycleTextMetrics(itm);
        }
    }

    private void showTopValue(IPrimitiveRenderer ipr, Location lo, Label la, int iLabelPosition, boolean bShadow) {
        IDeviceRenderer idr = (IDeviceRenderer)ipr;
        IChartComputation cComp = idr.getChartComputation();
        Graphics2D g2d = (Graphics2D)idr.getGraphicsContext();
        FontDefinition fd = la.getCaption().getFont();
        double dAngleInDegrees = fd.getRotation();
        Color clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        Color clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        ITextMetrics itm = cComp.getTextMetrics(this._sxs, la, 0.0);
        AffineTransform afTransform = g2d.getTransform();
        lo = this.adjustTextPosition(iLabelPosition, lo, itm, dAngleInDegrees);
        double dX = lo.getX();
        double dY = lo.getY();
        try {
            double dFW = itm.getFullWidth();
            double dH = itm.getHeight();
            double dD = itm.getDescent();
            double dFH = itm.getFullHeight();
            double dXOffset = 0.0;
            double dW = 0.0;
            int iLC = itm.getLineCount();
            Insets ins = goFactory.scaleInsets(la.getInsets(), (double)this._sxs.getDpiResolution() / 72.0);
            double shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
            boolean bEmptyText = "".equals(la.getCaption().getValue());
            HorizontalAlignment ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
            boolean bRightAligned = ha.getValue() == 2;
            boolean bCenterAligned = ha.getValue() == 1;
            double dCosTheta = Math.abs(Math.cos(dAngleInRadians));
            double dSineTheta = Math.abs(Math.sin(dAngleInRadians));
            dX -= dFW / 2.0;
            if (dAngleInDegrees == 0.0) {
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < itm.getLineCount()) {
                            int index = iLC - i - 1;
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(index);
                            if (bRightAligned) {
                                dW = itm.getWidth(index);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(index);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                double dDeltaX = dFW / 2.0 + dH * dSineTheta / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < itm.getLineCount()) {
                            TextLayout tl = new TextLayout(itm.getLine(iLC - i - 1), g2d.getFont().getAttributes(), g2d.getFontRenderContext());
                            if (bRightAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = tl.getBounds().getWidth();
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                g2d.rotate(dAngleInRadians, dX += -dFW * dCosTheta - dH * dSineTheta / 2.0 + dFW / 2.0, dY -= dFW * dSineTheta);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < itm.getLineCount()) {
                            int index = iLC - i - 1;
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(index);
                            if (bRightAligned) {
                                dW = itm.getWidth(index);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(index);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees == 90.0) {
                double dYHalfOffset = (dFH + dH) / 2.0;
                double dDeltaX = (dFW + dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < itm.getLineCount()) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - ((double)(itm.getLineCount() - i) * dH - (double)(iLC + 1) * dH / 2.0) + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees == -90.0) {
                double dYHalfOffset = (dFH + dH) / 2.0;
                double dDeltaX = (dFW - dH) / 2.0;
                double dDeltaY = dFW;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < itm.getLineCount()) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - ((double)(itm.getLineCount() - i) * dH - (double)(iLC + 1) * dH / 2.0) + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            }
        }
        finally {
            g2d.setTransform(afTransform);
            cComp.recycleTextMetrics(itm);
        }
    }

    private void showCenterValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean bShadow) {
        IDeviceRenderer idr = (IDeviceRenderer)ipr;
        IChartComputation cComp = idr.getChartComputation();
        Graphics2D g2d = (Graphics2D)idr.getGraphicsContext();
        double dX = lo.getX();
        double dY = lo.getY();
        FontDefinition fd = la.getCaption().getFont();
        double dAngleInDegrees = fd.getRotation();
        if (bShadow) {
            bShadow = la.getShadowColor() != null;
        }
        Color clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        Color clrBackground = null;
        if (la.getBackground() != null) {
            clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
        }
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        double dSineTheta = Math.sin(dAngleInRadians);
        double dCosTheta = Math.cos(dAngleInRadians);
        ITextMetrics itm = cComp.getTextMetrics(this._sxs, la, 0.0);
        AffineTransform afTransform = g2d.getTransform();
        try {
            double dFW = itm.getFullWidth();
            double dH = itm.getHeight();
            double dD = itm.getDescent();
            double dFH = itm.getFullHeight();
            double dXOffset = 0.0;
            double dW = 0.0;
            int iLC = itm.getLineCount();
            Insets ins = la.getInsets().scaledInstance((double)this._sxs.getDpiResolution() / 72.0);
            double shadowness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
            boolean bEmptyText = "".equals(la.getCaption().getValue());
            HorizontalAlignment ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
            boolean bRightAligned = ha.getValue() == 2;
            boolean bCenterAligned = ha.getValue() == 1;
            double dRotateX = dX;
            double dRotateY = dY;
            dX -= dFW / 2.0;
            dY += dH / 2.0;
            if (dAngleInDegrees == 0.0) {
                double dYHalfOffset = (dFH + dH) / 2.0;
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dYHalfOffset + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dYHalfOffset + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dYHalfOffset, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dYHalfOffset + ins.getTop() + dH * (double)(i + 1) - dD));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees > 0.0 && dAngleInDegrees < 90.0) {
                double dDeltaX = dFW - dFW * dCosTheta;
                double dDeltaY = dFW * dSineTheta + dH / 2.0;
                dX += dDeltaX;
                dY -= dDeltaY;
                g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < itm.getLineCount()) {
                            int index = iLC - i - 1;
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(index);
                            if (bRightAligned) {
                                dW = itm.getWidth(index);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(index);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)i - ins.getBottom()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0) {
                double dDeltaX = dFW - dFW * dCosTheta - dH * dSineTheta;
                double dDeltaY = dFW * dSineTheta + dH / 2.0 - dH * dCosTheta;
                dX += dDeltaX;
                dY -= dDeltaY;
                g2d.rotate(dAngleInRadians, dRotateX + dDeltaX, dRotateY - dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees == 90.0) {
                double dDeltaX = dFW;
                double dDeltaY = (dFW - dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY += dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dFH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD - dH * (double)(iLC - i - 1) + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            } else if (dAngleInDegrees == -90.0) {
                double dDeltaX = dFW - dH;
                double dDeltaY = (dFW + dH) / 2.0;
                g2d.rotate(dAngleInRadians, dX += dDeltaX, dY -= dDeltaY);
                if (bShadow) {
                    g2d.setPaint(new GradientPaint(new Point2D.Double(dX + shadowness, dY - dFH + shadowness), (Color)this._sxs.getColor(la.getShadowColor()), new Point2D.Double(dX + shadowness + dFW, dY - dFH + shadowness + dFH), (Color)this._sxs.getColor(la.getShadowColor().translucent())));
                    g2d.fill(new Rectangle2D.Double(dX + shadowness, dY - dFH + shadowness, dFW, dFH));
                } else {
                    Rectangle2D.Double r2d = new Rectangle2D.Double(dX, dY - dH, dFW, dFH);
                    if (clrBackground != null) {
                        g2d.setColor(clrBackground);
                        g2d.fill(r2d);
                    }
                    if (!bEmptyText) {
                        g2d.setColor(clrText);
                        int i = 0;
                        while (i < iLC) {
                            TextLayout tl = ((SwingTextMetrics)itm).getLayout(i);
                            if (bRightAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                            } else if (bCenterAligned) {
                                dW = itm.getWidth(i);
                                dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                            }
                            tl.draw(g2d, (float)(dX + dXOffset + ins.getLeft()), (float)(dY - dD + dH * (double)i + ins.getTop()));
                            ++i;
                        }
                    }
                    this.renderOutline(ipr, la.getOutline(), r2d);
                }
            }
        }
        finally {
            g2d.setTransform(afTransform);
            cComp.recycleTextMetrics(itm);
        }
    }

    private void renderOutline(IPrimitiveRenderer ipr, LineAttributes lia, Rectangle2D.Double r2d) {
        if (lia != null && lia.isVisible() && lia.getColor() != null) {
            Graphics2D g2d = (Graphics2D)((IDeviceRenderer)ipr).getGraphicsContext();
            Stroke sPrevious = null;
            ColorDefinition cd = lia.getColor();
            Stroke sCurrent = ((SwingRendererImpl)ipr).getCachedStroke(lia);
            if (sCurrent != null) {
                sPrevious = g2d.getStroke();
                g2d.setStroke(sCurrent);
            }
            g2d.setColor((Color)this._sxs.getColor(cd));
            g2d.draw(r2d);
            if (sPrevious != null) {
                g2d.setStroke(sPrevious);
            }
        }
    }

    private void computeTextAntialiasing(Graphics2D g2d, FontDefinition font) {
        if (font.isBold() || font.getRotation() % 90.0 != 0.0 || font.getSize() > 13.0f) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }
}

