/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.StringReader;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.ir.EngineIRReader;
import org.eclipse.birt.report.engine.ir.EngineIRWriter;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.parser.ReportDesignWriter;
import org.eclipse.birt.report.engine.parser.ReportParser;

public class EngineIRReaderTest
extends EngineCase {
    static final String DESIGN_STREAM = "ir_io_test.rptdesign";
    static final String VALUE_V1_STREAM = "org/eclipse/birt/report/engine/ir/ir_io_test_V1.xml";
    static final String VALUE_V2_STREAM = "org/eclipse/birt/report/engine/ir/ir_io_test_V2.xml";
    static final String VALUE_V3_STREAM = "org/eclipse/birt/report/engine/ir/ir_io_test_V3.xml";
    static final String GOLDEN_V1_STREAM = "ir_io_test_V1.golden";
    static final String GOLDEN_V2_STREAM = "ir_io_test_V2.golden";
    static final String GOLDEN_V3_STREAM = "ir_io_test_V3.golden";

    public void testV1() throws Exception {
        String value = this.getValue(VALUE_V1_STREAM);
        String golden = this.getGolden(GOLDEN_V1_STREAM);
        EngineIRReaderTest.assertEquals((String)this.removeSpace(golden), (String)this.removeSpace(value));
    }

    public void testV2() throws Exception {
        String value = this.getValue(VALUE_V2_STREAM);
        String golden = this.getGolden(GOLDEN_V2_STREAM);
        EngineIRReaderTest.assertEquals((String)this.removeSpace(golden), (String)this.removeSpace(value));
    }

    public void testV3() throws Exception {
        String value = this.getValue(VALUE_V3_STREAM);
        String golden = this.getGolden(GOLDEN_V3_STREAM);
        EngineIRReaderTest.assertEquals((String)this.removeSpace(golden), (String)this.removeSpace(value));
    }

    private String getValue(String value) {
        assert (value != null);
        return new String(this.loadResource(value));
    }

    public String getCurrentStream() throws Exception {
        ReportParser parser = new ReportParser();
        Report report = parser.parse(".", ((Object)((Object)this)).getClass().getResourceAsStream(DESIGN_STREAM));
        EngineIRReaderTest.assertTrue((report != null ? 1 : 0) != 0);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new EngineIRWriter().write((OutputStream)out, report);
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        EngineIRReader reader = new EngineIRReader(false);
        Report report2 = reader.read((InputStream)in);
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        ReportDesignWriter writer = new ReportDesignWriter();
        writer.write((OutputStream)out2, report2);
        String value = new String(out2.toByteArray());
        return value;
    }

    private String getGolden(String fileName) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        EngineIRReaderTest.assertTrue((in != null ? 1 : 0) != 0);
        EngineIRReader reader = new EngineIRReader(false);
        Report report = reader.read(in);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ReportDesignWriter writer = new ReportDesignWriter();
        writer.write((OutputStream)outputStream, report);
        return new String(outputStream.toByteArray());
    }

    public void writeGolden() throws Exception {
        ReportParser parser = new ReportParser();
        Report report = parser.parse(".", ((Object)((Object)this)).getClass().getResourceAsStream(DESIGN_STREAM));
        EngineIRReaderTest.assertTrue((report != null ? 1 : 0) != 0);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new EngineIRWriter().write((OutputStream)out, report);
        out.close();
        File file = new File(GOLDEN_V2_STREAM);
        if (!file.exists()) {
            file.createNewFile();
            RandomAccessFile rf = new RandomAccessFile(file, "rw");
            rf.write(out.toByteArray());
        }
    }

    String removeSpace(String v) {
        StringBuilder sb = new StringBuilder(v.length());
        try {
            BufferedReader reader = new BufferedReader(new StringReader(v));
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).startsWith("<?xml ")) {
                    sb.append(line);
                    sb.append('\n');
                }
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }
}

