/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ComponentsInGridHandleTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("ComponentsInGridHandleTest.xml");
    }

    public void testHandle() throws Exception {
        GridHandle grid = (GridHandle)this.designHandle.findElement("My grid");
        ComponentsInGridHandleTest.assertNotNull((Object)grid);
        SlotHandle columns = grid.getColumns();
        ComponentsInGridHandleTest.assertEquals((int)2, (int)columns.getCount());
        ColumnHandle column = (ColumnHandle)columns.get(0);
        ComponentsInGridHandleTest.assertEquals((double)2.5, (double)column.getWidth().getMeasure(), (double)0.1);
        ComponentsInGridHandleTest.assertEquals((int)3, (int)column.getRepeatCount());
        ComponentsInGridHandleTest.assertEquals((String)"My-Style", (String)column.getStyle().getName());
        column.setRepeatCount(5);
        ComponentsInGridHandleTest.assertEquals((int)5, (int)column.getRepeatCount());
        SlotHandle rows = grid.getRows();
        ComponentsInGridHandleTest.assertEquals((int)2, (int)rows.getCount());
        RowHandle row = (RowHandle)rows.get(0);
        ComponentsInGridHandleTest.assertEquals((double)5.0, (double)row.getHeight().getMeasure(), (double)1.0);
        ComponentsInGridHandleTest.assertEquals((String)"This is bookmark for section.", (String)row.getBookmark());
        row.setBookmark("hello, new bookmark");
        ComponentsInGridHandleTest.assertEquals((String)"hello, new bookmark", (String)row.getBookmark());
        ComponentsInGridHandleTest.assertEquals((String)"My-Style", (String)row.getStyle().getName());
        SlotHandle cells = row.getCells();
        ComponentsInGridHandleTest.assertEquals((int)2, (int)cells.getCount());
        CellHandle cell = (CellHandle)cells.get(1);
        ComponentsInGridHandleTest.assertEquals((int)3, (int)cell.getColumnSpan());
        ComponentsInGridHandleTest.assertEquals((int)1, (int)cell.getRowSpan());
        ComponentsInGridHandleTest.assertEquals((String)"all", (String)cell.getDrop());
        ComponentsInGridHandleTest.assertEquals((String)"1.5mm", (String)cell.getHeight().getStringValue());
        ComponentsInGridHandleTest.assertEquals((String)"2mm", (String)cell.getWidth().getStringValue());
        ComponentsInGridHandleTest.assertEquals((String)"red", (String)cell.getPrivateStyle().getBackgroundColor().getStringValue());
        cell.setColumnSpan(2);
        cell.setRowSpan(2);
        cell.setDrop("detail");
        ComponentsInGridHandleTest.assertEquals((int)2, (int)cell.getColumnSpan());
        ComponentsInGridHandleTest.assertEquals((int)2, (int)cell.getRowSpan());
        ComponentsInGridHandleTest.assertEquals((String)"detail", (String)cell.getDrop());
        SlotHandle content = cell.getContent();
        LabelHandle label = (LabelHandle)content.get(0);
        ComponentsInGridHandleTest.assertEquals((String)"address", (String)label.getName());
    }
}

