/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.elements.structures.LevelAttribute;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.util.XPathUtil;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.VariableElement;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class LineNumberInfo {
    private Module module;
    private Map<Long, Integer> elementMap = null;
    private Map<String, Integer> xpathMap = null;
    private Map<String, Integer> includeLibStructMap = null;
    private Map<String, Integer> embeddedImageStructMap = null;
    private Map<String, Integer> includedCssStyleSheetStructMap = null;
    private Map<String, Integer> variablesMap = null;
    private int themeProp = 1;

    public static boolean isLineNumberSuppoerted(IStructure struct) {
        return struct instanceof IncludedCssStyleSheet || struct instanceof IncludedLibrary || struct instanceof EmbeddedImage || struct instanceof ResultSetColumn || struct instanceof LevelAttribute;
    }

    public LineNumberInfo(Module module) {
        this.module = module;
        this.elementMap = Collections.synchronizedMap(new HashMap());
        this.includeLibStructMap = Collections.synchronizedMap(new HashMap());
        this.embeddedImageStructMap = Collections.synchronizedMap(new HashMap());
        this.includedCssStyleSheetStructMap = Collections.synchronizedMap(new HashMap());
        this.xpathMap = Collections.synchronizedMap(new HashMap());
        this.variablesMap = Collections.synchronizedMap(new HashMap());
    }

    public void put(Object obj, Integer lineNo) {
        if (obj instanceof PropertyDefn) {
            this.themeProp = lineNo == null ? 1 : lineNo;
        } else if (obj instanceof DesignElement) {
            if (obj instanceof VariableElement) {
                this.variablesMap.put(((VariableElement)obj).getName(), lineNo);
            } else {
                this.elementMap.put(((DesignElement)obj).getID(), lineNo);
            }
        } else if (obj instanceof IStructure) {
            this.putStructure((IStructure)obj, lineNo);
        } else if (obj instanceof ContainerContext || obj instanceof PropertyHandle || obj instanceof SlotHandle) {
            this.putXPathLineNo(obj, lineNo);
        }
    }

    private void putXPathLineNo(Object obj, Integer lineNo) {
        String xpath = this.getXPath(obj);
        if (xpath == null) {
            assert (false);
            return;
        }
        this.xpathMap.put(xpath, lineNo);
    }

    private void putStructure(IStructure struct, Integer lineNo) {
        if (!LineNumberInfo.isLineNumberSuppoerted(struct)) {
            return;
        }
        if (struct instanceof IncludedLibrary) {
            this.includeLibStructMap.put(((IncludedLibrary)struct).getNamespace(), lineNo);
        } else if (struct instanceof EmbeddedImage) {
            this.embeddedImageStructMap.put(((EmbeddedImage)struct).getName(), lineNo);
        } else if (struct instanceof IncludedCssStyleSheet) {
            this.includedCssStyleSheetStructMap.put(((IncludedCssStyleSheet)struct).getFileName(), lineNo);
        } else {
            Structure structure = (Structure)struct;
            StructureHandle handle = new StructureHandle(structure.getElement().getHandle(this.module), structure.getContext());
            this.putXPathLineNo(handle, lineNo);
        }
    }

    public int get(Object obj) {
        Module tmpModule = null;
        if (obj instanceof Theme && (tmpModule = ((Theme)obj).getRoot()) instanceof Library && ((Library)tmpModule).getHost() != null) {
            return this.themeProp;
        }
        if (obj instanceof Library && ((Library)obj).getHost() != null) {
            return this.intValue(this.includeLibStructMap.get(((Library)obj).getNamespace()));
        }
        if (obj instanceof DesignElement) {
            if (obj instanceof VariableElement) {
                return this.variablesMap.get(((VariableElement)obj).getName());
            }
            return this.getElementLineNo(((DesignElement)obj).getID());
        }
        if (obj instanceof StructureHandle) {
            StructureHandle structHandle = (StructureHandle)obj;
            if (LineNumberInfo.isLineNumberSuppoerted(structHandle.getStructure())) {
                return this.getStructureLineNo(structHandle);
            }
        } else if (obj instanceof SlotHandle || obj instanceof PropertyHandle) {
            return this.getXPathLineNo(obj);
        }
        return 1;
    }

    private int getStructureLineNo(StructureHandle structHandle) {
        IStructure struct = structHandle.getStructure();
        if (struct instanceof EmbeddedImage) {
            return this.intValue(this.embeddedImageStructMap.get(((EmbeddedImage)struct).getName()));
        }
        if (struct instanceof IncludedCssStyleSheet) {
            return this.intValue(this.includedCssStyleSheetStructMap.get(((IncludedCssStyleSheet)struct).getFileName()));
        }
        if (struct instanceof IncludedLibrary) {
            return this.intValue(this.includeLibStructMap.get(((IncludedLibrary)struct).getNamespace()));
        }
        return this.getXPathLineNo(structHandle);
    }

    private int getXPathLineNo(Object obj) {
        String xpath = this.getXPath(obj);
        if (xpath == null) {
            assert (false);
            return 1;
        }
        return this.intValue(this.xpathMap.get(xpath));
    }

    public int getElementLineNo(long id) {
        return this.intValue(this.elementMap.get(id));
    }

    private int intValue(Integer obj) {
        return obj == null ? 1 : obj;
    }

    private String getXPath(Object obj) {
        if (obj instanceof ContainerContext) {
            ContainerContext context = (ContainerContext)obj;
            DesignElementHandle handle = context.getElement().getHandle(this.module);
            obj = context.isROMSlot() ? handle.getSlot(context.getSlotID()) : handle.getPropertyHandle(context.getPropertyName());
        }
        if (obj instanceof Structure) {
            Structure struct = (Structure)obj;
            obj = new StructureHandle(struct.getElement().getHandle(this.module), struct.getContext());
        }
        if (obj instanceof PropertyHandle || obj instanceof StructureHandle || obj instanceof SlotHandle) {
            return XPathUtil.getXPath(obj);
        }
        return null;
    }
}

