/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.timefunction.ITimeFunction;
import org.eclipse.birt.data.engine.api.timefunction.ITimePeriod;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;

public class QueryValidator {
    public static void validateTimeFunctionInCubeQuery(ICubeQueryDefinition query, CubeHandle cubeHandle) throws DataException, AdapterException {
        int i;
        IEdgeDefinition pageEdge;
        IEdgeDefinition rowEdge;
        if (cubeHandle == null) {
            return;
        }
        HashMap<String, IDimensionDefinition> dimensionMap = new HashMap<String, IDimensionDefinition>();
        IEdgeDefinition columnEdge = query.getEdge(2);
        if (columnEdge != null) {
            List dimensions = columnEdge.getDimensions();
            int i2 = 0;
            while (i2 < dimensions.size()) {
                dimensionMap.put(((IDimensionDefinition)dimensions.get(i2)).getName(), (IDimensionDefinition)dimensions.get(i2));
                ++i2;
            }
        }
        if ((rowEdge = query.getEdge(1)) != null) {
            List dimensions = rowEdge.getDimensions();
            int i3 = 0;
            while (i3 < dimensions.size()) {
                dimensionMap.put(((IDimensionDefinition)dimensions.get(i3)).getName(), (IDimensionDefinition)dimensions.get(i3));
                ++i3;
            }
        }
        if ((pageEdge = query.getEdge(3)) != null) {
            List dimensions = pageEdge.getDimensions();
            i = 0;
            while (i < dimensions.size()) {
                dimensionMap.put(((IDimensionDefinition)dimensions.get(i)).getName(), (IDimensionDefinition)dimensions.get(i));
                ++i;
            }
        }
        List bindingList = query.getBindings();
        i = 0;
        while (i < bindingList.size()) {
            IBinding binding = (IBinding)bindingList.get(i);
            if (binding.getTimeFunction() != null) {
                String dimensionName = binding.getTimeFunction().getTimeDimension();
                QueryValidator.validateTimeFunction(cubeHandle, binding.getTimeFunction());
                if (dimensionMap.containsKey(dimensionName) && binding.getTimeFunction().getReferenceDate() == null) {
                    QueryValidator.validateTimeFunction((IDimensionDefinition)dimensionMap.get(dimensionName), cubeHandle, binding.getTimeFunction());
                }
            }
            ++i;
        }
    }

    private static void validateTimeFunction(CubeHandle cube, ITimeFunction function) throws DataException, AdapterException {
        if (cube != null) {
            String timeType;
            String timeType2;
            String dimensionName = function.getTimeDimension();
            ITimePeriod basePeriod = function.getBaseTimePeriod();
            ITimePeriod relativePeriod = function.getRelativeTimePeriod();
            DimensionHandle handle = cube.getDimension(dimensionName);
            if (handle == null) {
                throw new AdapterException("cube.query.error.dimensionMiss", new Object[]{dimensionName});
            }
            TabularHierarchyHandle hierhandle = (TabularHierarchyHandle)handle.getDefaultHierarchy();
            List levels = hierhandle.getContents("levels");
            ArrayList<String> levelTypes = new ArrayList<String>();
            int i = 0;
            while (i < levels.size()) {
                TabularLevelHandle level = (TabularLevelHandle)levels.get(i);
                levelTypes.add(level.getDateTimeLevelType());
                ++i;
            }
            if (basePeriod != null && !levelTypes.contains(timeType2 = DataAdapterUtil.toModelTimeType(basePeriod.getType()))) {
                throw new AdapterException("cube.query.error.levelMiss", new Object[]{timeType2, dimensionName});
            }
            if (relativePeriod != null && !levelTypes.contains(timeType = DataAdapterUtil.toModelTimeType(relativePeriod.getType()))) {
                throw new AdapterException("cube.query.error.levelMiss", new Object[]{timeType, dimensionName});
            }
        }
    }

    private static void validateTimeFunction(IDimensionDefinition timeDimension, CubeHandle cubeHandle, ITimeFunction function) throws AdapterException, DataException {
        ArrayList<String> levelTypes = new ArrayList<String>();
        if (cubeHandle != null) {
            String timeType;
            String timeType2;
            String dimensionName = function.getTimeDimension();
            ITimePeriod basePeriod = function.getBaseTimePeriod();
            ITimePeriod relativePeriod = function.getRelativeTimePeriod();
            DimensionHandle handle = cubeHandle.getDimension(dimensionName);
            if (handle == null) {
                throw new AdapterException("cube.query.error.dimensionMiss", new Object[]{dimensionName});
            }
            TabularHierarchyHandle hierhandle = (TabularHierarchyHandle)handle.getDefaultHierarchy();
            List levels = hierhandle.getContents("levels");
            List queryLevels = ((IHierarchyDefinition)timeDimension.getHierarchy().get(0)).getLevels();
            String mostDetailedLevel = ((ILevelDefinition)queryLevels.get(queryLevels.size() - 1)).getName();
            int i = 0;
            while (i < levels.size()) {
                TabularLevelHandle level = (TabularLevelHandle)levels.get(i);
                if (mostDetailedLevel != null && level.getName().equals(mostDetailedLevel)) {
                    levelTypes.add(level.getDateTimeLevelType());
                    break;
                }
                levelTypes.add(level.getDateTimeLevelType());
                ++i;
            }
            if (basePeriod != null && !levelTypes.contains(timeType2 = DataAdapterUtil.toModelTimeType(basePeriod.getType()))) {
                throw new AdapterException("cube.edge.error.levelMiss", new Object[]{timeType2});
            }
            if (relativePeriod != null && !levelTypes.contains(timeType = DataAdapterUtil.toModelTimeType(relativePeriod.getType()))) {
                throw new AdapterException("cube.edge.error.levelMiss", new Object[]{timeType});
            }
        }
    }
}

