/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ods;

import java.awt.Color;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.ods.SheetData;
import org.eclipse.birt.report.engine.emitter.ods.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.ods.layout.OdsContainer;
import org.eclipse.birt.report.engine.emitter.ods.layout.OdsLayoutEngine;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.odf.style.StyleBuilder;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.odf.style.StyleManager;

public class StyleEngine {
    private OdsLayoutEngine engine;
    private Stack<StyleEntry> containerStyles = new Stack();
    private StyleManager styleManager;

    public StyleEngine(OdsLayoutEngine engine, StyleManager styleManager) {
        this.engine = engine;
        this.styleManager = styleManager;
    }

    public StyleEntry getDefaultEntry(int id) {
        StyleEntry entry = StyleBuilder.createEmptyStyleEntry((int)5);
        this.styleManager.addStyle(entry);
        return entry;
    }

    public StyleEntry createEntry(ContainerSizeInfo sizeInfo, IStyle style, StyleEntry parent) {
        if (style == null) {
            return StyleBuilder.createEmptyStyleEntry((int)5);
        }
        StyleEntry entry = this.initStyle(style, sizeInfo, parent);
        return entry;
    }

    public StyleEntry createCellEntry(ContainerSizeInfo sizeInfo, IStyle style, String diagonalLineColor, String diagonalLineStyle, int diagonalLineWidth, StyleEntry parent) {
        StyleEntry entry = style == null ? StyleBuilder.createEmptyStyleEntry((int)5) : this.initStyle(style, sizeInfo, parent);
        StyleBuilder.applyDiagonalLine((StyleEntry)entry, (Color)PropertyUtil.getColor((String)diagonalLineColor), (String)diagonalLineStyle, (int)diagonalLineWidth);
        return entry;
    }

    public StyleEntry createHorizontalStyle(ContainerSizeInfo rule) {
        StyleEntry entry = StyleBuilder.createEmptyStyleEntry((int)5);
        if (this.engine.getContainers().size() > 0) {
            OdsContainer container = this.engine.getCurrentContainer();
            ContainerSizeInfo crule = container.getSizeInfo();
            StyleEntry cEntry = container.getStyle();
            StyleBuilder.mergeInheritableProp((StyleEntry)cEntry, (StyleEntry)entry);
            if (rule.getStartCoordinate() == crule.getStartCoordinate()) {
                StyleBuilder.applyLeftBorder((StyleEntry)cEntry, (StyleEntry)entry);
            }
            if (rule.getEndCoordinate() == crule.getEndCoordinate()) {
                StyleBuilder.applyRightBorder((StyleEntry)cEntry, (StyleEntry)entry);
            }
        }
        return entry;
    }

    public StyleEntry getStyle(IStyle style, ContainerSizeInfo rule, StyleEntry parent) {
        return this.initStyle(style, null, rule, parent);
    }

    public StyleEntry getStyle(IStyle style, ContainerSizeInfo childSizeInfo, ContainerSizeInfo parentSizeInfo, StyleEntry parent) {
        return this.initStyle(style, childSizeInfo, parentSizeInfo, parent);
    }

    private StyleEntry initStyle(IStyle style, ContainerSizeInfo childSizeInfo, ContainerSizeInfo parentSizeInfo, StyleEntry parent) {
        StyleEntry entry = StyleBuilder.createStyleEntry((IStyle)style, (int)5);
        if (!this.containerStyles.isEmpty()) {
            StyleEntry centry = this.containerStyles.peek();
            StyleBuilder.mergeInheritableProp((StyleEntry)centry, (StyleEntry)entry);
        }
        if (this.engine.getContainers().size() > 0) {
            OdsContainer container = this.engine.getCurrentContainer();
            StyleEntry cEntry = container.getStyle();
            StyleBuilder.mergeInheritableProp((StyleEntry)cEntry, (StyleEntry)entry);
            if (childSizeInfo == null) {
                childSizeInfo = container.getSizeInfo();
            }
            this.applyHBorders(cEntry, entry, childSizeInfo, parentSizeInfo);
            this.applyTopBorderStyle(entry);
        }
        return entry;
    }

    private void applyTopBorderStyle(StyleEntry childStyle) {
        OdsContainer container = this.engine.getCurrentContainer();
        int rowIndex = container.getRowIndex();
        OdsContainer parent = container;
        while (parent != null && parent.getStartRowId() == rowIndex) {
            StyleBuilder.applyTopBorder((StyleEntry)parent.getStyle(), (StyleEntry)childStyle);
            parent = parent.getParent();
        }
    }

    private void applyHBorders(StyleEntry centry, StyleEntry entry, ContainerSizeInfo crule, ContainerSizeInfo rule) {
        if (crule == null || rule == null) {
            return;
        }
        if (crule.getStartCoordinate() == rule.getStartCoordinate()) {
            StyleBuilder.applyLeftBorder((StyleEntry)centry, (StyleEntry)entry);
        }
        if (crule.getEndCoordinate() == rule.getEndCoordinate()) {
            StyleBuilder.applyRightBorder((StyleEntry)centry, (StyleEntry)entry);
        }
    }

    private StyleEntry initStyle(IStyle style, ContainerSizeInfo rule, StyleEntry parent) {
        return this.initStyle(style, null, rule, parent);
    }

    public void addContainderStyle(IStyle computedStyle, StyleEntry parent) {
        StyleEntry entry = StyleBuilder.createStyleEntry((IStyle)computedStyle, (int)(parent != null ? parent.getType() : 5));
        if (!this.containerStyles.isEmpty()) {
            StyleEntry centry = this.containerStyles.peek();
            StyleBuilder.mergeInheritableProp((StyleEntry)centry, (StyleEntry)entry);
        }
        this.styleManager.addStyle(entry);
        this.containerStyles.add(entry);
    }

    public void removeForeignContainerStyle() {
        if (!this.containerStyles.isEmpty()) {
            this.containerStyles.pop();
        }
    }

    public void applyContainerBottomStyle() {
        this.applyContainerBottomStyle(this.engine.getCurrentContainer());
    }

    public void applyContainerBottomStyle(OdsContainer container) {
        ContainerSizeInfo rule = container.getSizeInfo();
        StyleEntry entry = container.getStyle();
        int start = rule.getStartCoordinate();
        int col = this.engine.getAxis().getColumnIndexByCoordinate(start);
        int span = this.engine.getAxis().getColumnIndexByCoordinate(rule.getEndCoordinate());
        int i = col;
        while (i < span) {
            StyleEntry originalStyle;
            StyleEntry newStyle;
            boolean isChanged;
            StyleEntry styleId;
            SheetData data = this.engine.getColumnLastData(i);
            if (data != null && (styleId = data.getStyleId()) != null && (isChanged = StyleBuilder.applyBottomBorder((StyleEntry)entry, (StyleEntry)(newStyle = (StyleEntry)(originalStyle = styleId).clone())))) {
                this.styleManager.addStyle(newStyle);
            }
            ++i;
        }
    }
}

