/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ExpressionPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.ExpressionSection;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.FormTextSection;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BookMarkExpressionPage
extends AttributePage {
    private static String MESSAGE_GENERAL = Messages.getString((String)"BookMarkPage.Modified.Note");
    private static String MESSAGE_WITHOUT_QUOTES = Messages.getString((String)"BookMarkPage.Modified.WithoutQuotes");
    private FormTextSection noteSection;
    private ExpressionSection bookMarkSection;
    private ExpressionPropertyDescriptorProvider bookMarkProvider;

    @Override
    public void buildUI(Composite parent) {
        super.buildUI(parent);
        this.container.setLayout((Layout)WidgetUtil.createGridLayout((int)2, (int)15));
        this.noteSection = new FormTextSection("", this.container, true);
        this.noteSection.setWidth(450);
        this.noteSection.setFillText(false);
        this.noteSection.setText(this.generateNoteSectionText(MESSAGE_GENERAL));
        this.noteSection.setImage("image", JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        this.noteSection.setColor("color", ColorManager.getColor((int)127, (int)127, (int)127));
        this.addSection("GENERAL_LIBRARY_NOTE", this.noteSection);
        this.bookMarkProvider = new ExpressionPropertyDescriptorProvider("bookmark", "ReportItem");
        this.bookMarkSection = new ExpressionSection(this.bookMarkProvider.getDisplayName(), this.container, true);
        this.bookMarkSection.setProvider(this.bookMarkProvider);
        this.bookMarkSection.setWidth(500);
        this.addSection("BOOKMARKEXPRESSION_BOOKMARK", this.bookMarkSection);
        this.createSections();
        this.layoutSections();
    }

    @Override
    public void createSections() {
        super.createSections();
        this.bookMarkSection.getExpressionControl().getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BookMarkExpressionPage.this.refreshMessage();
            }
        });
    }

    @Override
    public void refresh() {
        this.refreshMessage();
        super.refresh();
    }

    private void refreshMessage() {
        Text text = this.bookMarkSection.getExpressionControl().getTextControl();
        if (text != null && !text.isDisposed()) {
            boolean isHidden = this.noteSection.getTextControl().isVisible();
            if (!this.validateBookMark(text.getText().trim())) {
                this.noteSection.setHidden(false);
            } else {
                this.noteSection.setHidden(true);
            }
            if (this.noteSection.getTextControl().isVisible() != isHidden) {
                FormWidgetFactory.getInstance().paintFormStyle(this.container);
                FormWidgetFactory.getInstance().adapt(this.container);
                this.container.layout(true);
                this.container.redraw();
            }
        }
    }

    private boolean validateBookMark(String text) {
        boolean result = this.validateQuotes(text);
        if (result) {
            this.setNoteSectionMessage(MESSAGE_GENERAL);
            result = this.validateContents(text);
        }
        return result;
    }

    private boolean validateContents(String text) {
        if ((text = DEUtil.removeQuote((String)text).trim()).length() > 0) {
            return text.matches("[a-zA-Z0-9_\\-\\:\\.]+");
        }
        return true;
    }

    private boolean validateQuotes(String text) {
        String textTemp = DEUtil.removeQuote((String)text).trim();
        if (textTemp.length() > 0 && textTemp.equals(text)) {
            this.setNoteSectionMessage(MESSAGE_WITHOUT_QUOTES);
            return false;
        }
        return true;
    }

    private void setNoteSectionMessage(String message) {
        this.noteSection.setStringValue(this.generateNoteSectionText(message));
    }

    private String generateNoteSectionText(String detailMessage) {
        return "<form><p><img href=\"image\"/><span color=\"color\">" + detailMessage + "</span></p></form>";
    }
}

