/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.dnd;

import java.util.Collection;
import org.eclipse.wst.common.ui.internal.dnd.DefaultDragAndDropCommand;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.TopLevelNode;
import org.eclipse.wst.dtd.ui.internal.DTDUIMessages;

public class DragTopLevelNodesCommand
extends DefaultDragAndDropCommand {
    private static final String moveNode = DTDUIMessages._UI_MOVE_NODE;
    private static final String moveNodes = DTDUIMessages._UI_MOVE_NODES;

    public DragTopLevelNodesCommand(Object target, float location, int operations, int operation, Collection sources) {
        super(target, location, operations, operation, sources);
    }

    public boolean canExecute() {
        if (!(this.target instanceof TopLevelNode)) {
            return false;
        }
        for (Object source : this.sources) {
            if (source instanceof TopLevelNode) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        DTDNode referenceNode = (DTDNode)this.target;
        DTDFile dtdFile = referenceNode.getDTDFile();
        dtdFile.getDTDModel().beginRecording((Object)this, this.sources.size() > 1 ? moveNodes : moveNode);
        for (DTDNode node : this.sources) {
            if (!(node instanceof TopLevelNode)) continue;
            dtdFile.moveNode((Object)this, referenceNode, node, this.isAfter());
        }
        dtdFile.getDTDModel().endRecording((Object)this);
    }
}

