/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.samples;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.samples.SampleWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.ScrolledFormText;

public class ReviewPage
extends WizardPage {
    private final SampleWizard wizard;
    private ScrolledFormText formText;

    public ReviewPage(SampleWizard wizard) {
        super("last");
        this.wizard = wizard;
        this.setTitle(PDEUIMessages.ReviewPage_title);
        this.setDescription(PDEUIMessages.ReviewPage_desc);
    }

    public void setVisible(boolean visible) {
        this.setPageComplete(this.wizard.getSelection() != null);
        if (this.formText != null) {
            this.updateContent();
        }
        super.setVisible(visible);
    }

    private void updateContent() {
        StringBuilder buf = new StringBuilder();
        buf.append("<form>");
        IConfigurationElement selection = this.wizard.getSelection();
        if (selection != null) {
            this.setMessage(null);
            IConfigurationElement[] desc = selection.getChildren("description");
            if (desc.length == 1) {
                buf.append(NLS.bind((String)PDEUIMessages.ReviewPage_descContent, (Object[])new String[]{selection.getAttribute("name"), desc[0].getValue()}));
            } else {
                buf.append(NLS.bind((String)PDEUIMessages.ReviewPage_content, (Object)selection.getAttribute("name")));
            }
        } else {
            this.setMessage(PDEUIMessages.ReviewPage_noSampleFound, 2);
        }
        buf.append("</form>");
        this.formText.setText(buf.toString());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.formText = new ScrolledFormText(container, true);
        this.formText.setBackground(parent.getBackground());
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 300;
        this.formText.setLayoutData((Object)gd);
        HyperlinkSettings settings = new HyperlinkSettings(parent.getDisplay());
        this.formText.getFormText().setHyperlinkSettings(settings);
        this.setControl((Control)container);
        this.updateContent();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.review_page");
    }
}

