/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.pde.internal.junit.runtime.PlatformUITestHarness;
import org.eclipse.pde.internal.junit.runtime.RemotePluginTestRunner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class NonUIThreadTestApplication
implements IApplication {
    private static final String DEFAULT_HEADLESSAPP = "org.eclipse.pde.junit.runtime.coretestapplication";
    protected IApplication fApplication;
    protected Object fTestHarness;
    protected boolean runInUIThreadAndRequirePlatformUI = false;
    protected String defaultApplicationId = "org.eclipse.pde.junit.runtime.coretestapplication";

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        String appId = this.getApplicationToRun(args);
        IApplication app = Objects.requireNonNull(this.getApplication(appId));
        if (this.runInUIThreadAndRequirePlatformUI || !DEFAULT_HEADLESSAPP.equals(appId)) {
            this.installPlatformUITestHarness();
        }
        this.fApplication = app;
        return this.fApplication.start(context);
    }

    private void installPlatformUITestHarness() throws ReflectiveOperationException {
        Object testableObject;
        block4: {
            testableObject = NonUIThreadTestApplication.getRegisteredTestableObject();
            if (testableObject == null) {
                try {
                    Class<?> platformUIClass = Class.forName("org.eclipse.ui.PlatformUI", true, this.getClass().getClassLoader());
                    testableObject = platformUIClass.getMethod("getTestableObject", new Class[0]).invoke(null, new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    if (!this.runInUIThreadAndRequirePlatformUI) break block4;
                    throw e;
                }
            }
        }
        if (testableObject != null) {
            this.fTestHarness = new PlatformUITestHarness(testableObject, !this.runInUIThreadAndRequirePlatformUI);
        }
    }

    private static Object getRegisteredTestableObject() {
        BundleContext context = FrameworkUtil.getBundle(NonUIThreadTestApplication.class).getBundleContext();
        ServiceReference reference = context.getServiceReference("org.eclipse.ui.testing.TestableObject");
        if (reference != null) {
            try {
                Object object = context.getService(reference);
                return object;
            }
            finally {
                context.ungetService(reference);
            }
        }
        return null;
    }

    public void stop() {
        if (this.fApplication != null) {
            this.fApplication.stop();
        }
        if (this.fTestHarness != null) {
            this.fTestHarness = null;
        }
    }

    private IApplication getApplication(String appId) throws CoreException {
        Object runnable;
        IConfigurationElement[] runs;
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", appId);
        Objects.requireNonNull(extension);
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements.length > 0 && (runs = elements[0].getChildren("run")).length > 0 && (runnable = runs[0].createExecutableExtension("class")) instanceof IApplication) {
            return (IApplication)runnable;
        }
        return null;
    }

    private String getApplicationToRun(String[] args) {
        String testApp = RemotePluginTestRunner.getArgumentValue(args, "-testApplication");
        if (testApp != null) {
            return testApp;
        }
        IProduct product = Platform.getProduct();
        return product != null ? product.getApplication() : this.defaultApplicationId;
    }
}

