/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISummary;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SummaryWizardPage
extends WizardPage
implements ISummary {
    private static final String PAGE = "SummaryWizardPage";
    private static final String TITLE = "SummaryWizardPage.title";
    private static final String DESCRIPTION = "SummaryWizardPage.description";
    private static final String PROPERTY = "SummaryWizardPage.property";
    private static final String VALUE = "SummaryWizardPage.value";
    private String mPropertyCol = "";
    private String mValueCol = "";
    private ISummaryDataSource mSource;
    private Table mTable;

    public SummaryWizardPage() {
        super(PAGE);
        this.setTitle(ConnectivityUIPlugin.getDefault().getResourceString(TITLE));
        this.setDescription(ConnectivityUIPlugin.getDefault().getResourceString(DESCRIPTION));
        this.mPropertyCol = ConnectivityUIPlugin.getDefault().getResourceString(PROPERTY);
        this.mValueCol = ConnectivityUIPlugin.getDefault().getResourceString(VALUE);
    }

    public SummaryWizardPage(ISummaryDataSource source) {
        this();
        this.mSource = source;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        composite.setLayout((Layout)gl);
        this.mTable = new Table(composite, 2048);
        this.mTable.setLayoutData((Object)new GridData(1808));
        this.mTable.setHeaderVisible(true);
        this.mTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        this.mTable.setLayout((Layout)layout);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(163));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(245));
        TableColumn keyCol = new TableColumn(this.mTable, 0);
        keyCol.setText(this.mPropertyCol);
        TableColumn valueCol = new TableColumn(this.mTable, 0);
        valueCol.setText(this.mValueCol);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public void setVisible(boolean value) {
        super.setVisible(value);
        if (value) {
            this.loadSummaryData();
        }
    }

    public void setPropertyColTitle(String title) {
        this.mPropertyCol = title;
        if (this.mTable != null && this.mTable.getColumnCount() >= 2) {
            this.mTable.getColumn(0).setText(this.mPropertyCol);
        }
    }

    public void setValueColTitle(String title) {
        this.mValueCol = title;
        if (this.mTable != null && this.mTable.getColumnCount() >= 2) {
            this.mTable.getColumn(1).setText(this.mValueCol);
        }
    }

    public void setSummaryDataSource(ISummaryDataSource s) {
        this.mSource = s;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void loadSummaryData() {
        if (this.mSource == null) {
            return;
        }
        Object[] data = this.mSource.getSummaryData().toArray();
        this.mTable.removeAll();
        int i = 0;
        while (i < data.length) {
            TableItem item = new TableItem(this.mTable, 0);
            item.setText((String[])data[i]);
            ++i;
        }
    }
}

