/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.APISamples;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;

public class Sample2 {
    ReportDesignHandle designHandle = null;
    LibraryHandle libraryHandle = null;
    ElementFactory designFactory = null;
    ElementFactory libraryFactory = null;
    StructureFactory structFactory = null;

    public static void main(String[] args) throws SemanticException, IOException, DesignFileException {
        new Sample2().buildReport();
    }

    void buildReport() throws SemanticException, IOException, DesignFileException {
        SessionHandle session = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = session.createDesign();
        this.libraryHandle = session.createLibrary();
        this.designFactory = this.designHandle.getElementFactory();
        this.libraryFactory = this.libraryHandle.getElementFactory();
        this.structFactory = new StructureFactory();
        this.buildMasterPages();
        this.buildDataSource();
        this.buildDataSet();
        this.buildParameter();
        this.buildBody();
        this.designHandle.saveAs("Sample2.rptdesign");
    }

    void buildDataSource() throws SemanticException {
        OdaDataSourceHandle dsHandle = this.designFactory.newOdaDataSource("Data Source", "org.eclipse.birt.report.data.oda.jdbc");
        dsHandle.setProperty("odaDriverClass", (Object)"net.sourceforge.jtds.jdbc.Driver");
        dsHandle.setProperty("odaURL", (Object)"jdbc:jtds:sqlserver://spmdb:1433/gui");
        dsHandle.setProperty("odaUser", (Object)"sa");
        dsHandle.setProperty("odaPassword", (Object)"sa");
        this.designHandle.getDataSources().add((DesignElementHandle)dsHandle);
    }

    void buildDataSet() throws SemanticException {
        OdaDataSetHandle dsHandle = this.designFactory.newOdaDataSet("ds", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        dsHandle.setDataSource("Data Source");
        dsHandle.setQueryText("Select \"Transaction\".trans_id,\"Transaction\".trans_amt,Trans_desc.trans_ty,Account.account_nm,\"Transaction\".trand_dt,\"Transaction\".account_idFROM \"Transaction\" , Trans_desc , AccountWhere\"Transaction\".account_id = Account.account_idand \"Transaction\".trans_cd = Trans_desc.trans_cd)");
        this.designHandle.getDataSets().add((DesignElementHandle)dsHandle);
    }

    void buildParameter() throws SemanticException {
        ScalarParameterHandle param = this.designFactory.newScalarParameter("month");
        param.setValueType("dynamic");
        param.setDataType("dateTime");
        param.setAllowBlank(false);
        param.setControlType("list-box");
        param.setDataSetName("ds");
        param.setValueExpr("row[\"trand_dt\"]");
        param.setMustMatch(false);
        param.setFixedOrder(true);
        param.setCategory("Unformatted");
        this.designHandle.getParameters().add((DesignElementHandle)param);
    }

    void buildMasterPages() throws SemanticException, IOException {
        SimpleMasterPageHandle masterpage = this.designFactory.newSimpleMasterPage("Simple MasterPage");
        GridHandle grid = this.designFactory.newGridItem(null, 2, 1);
        grid.setProperty("marginBottom", (Object)"1cm");
        grid.setProperty("textAlign", (Object)"right");
        grid.setProperty("verticalAlign", (Object)"baseline");
        grid.setProperty("width", (Object)"100%");
        ColumnHandle column0 = (ColumnHandle)grid.getColumns().get(0);
        column0.setProperty("width", (Object)"4.26in");
        ColumnHandle column1 = (ColumnHandle)grid.getColumns().get(1);
        column1.setProperty("width", (Object)"1.625in");
        CellHandle cell0 = grid.getCell(0, 0);
        TextItemHandle text = this.designFactory.newTextItem("masterpage text");
        text.setProperty("fontSize", (Object)"14pt");
        text.setProperty("fontWeight", (Object)"bold");
        text.setProperty("display", (Object)"block");
        text.setProperty("contentType", (Object)"plain");
        text.setContent("Created by: Actuate");
        cell0.getContent().add((DesignElementHandle)text);
        CellHandle cell1 = grid.getCell(0, 1);
        EmbeddedImage image = StructureFactory.createEmbeddedImage();
        image.setType("image/jpeg");
        image.setData(this.load("images/actuate_logo.jpg"));
        image.setName("actuate_logo");
        this.designHandle.addImage(image);
        ImageHandle image1 = this.designFactory.newImage("Logo");
        image1.setImageName("actuate_logo");
        cell1.getContent().add((DesignElementHandle)image1);
        TextItemHandle text1 = this.designFactory.newTextItem("pageheader text");
        text1.setContentType("html");
        text1.setContent("<value-of>new Date()</value-of>");
        masterpage.getPageHeader().add((DesignElementHandle)grid);
        masterpage.getPageFooter().add((DesignElementHandle)text1);
        this.designHandle.getMasterPages().add((DesignElementHandle)masterpage);
    }

    public byte[] load(String fileName) throws IOException {
        BufferedInputStream is = new BufferedInputStream(this.getClass().getResourceAsStream(fileName));
        byte[] data = null;
        if (is != null) {
            data = new byte[((InputStream)is).available()];
            ((InputStream)is).read(data);
        }
        return data;
    }

    void buildBody() throws SemanticException, DesignFileException {
        this.buildLibrary();
        this.buildTheme();
        this.designHandle.includeLibrary("library", "library");
        LabelHandle label = (LabelHandle)this.libraryHandle.findElement("label");
        LabelHandle r_label = (LabelHandle)this.designFactory.newElementFrom((DesignElementHandle)label, "report_label");
        r_label.setProperty("fontSize", (Object)"x-large");
        r_label.setProperty("fontWeight", (Object)"bold");
        r_label.setProperty("marginBottom", (Object)"0.5cm");
        r_label.setProperty("paddingBottom", (Object)"0cm");
        r_label.setProperty("textAlign", (Object)"center");
        this.designHandle.getBody().add((DesignElementHandle)r_label);
        this.designHandle.setThemeName("theme1");
        this.buildStyles();
        this.buildTable();
        this.buildGroups();
    }

    void buildStyles() throws SemanticException {
        SharedStyleHandle style = this.designFactory.newStyle("table-detail");
        style.setBorderBottomStyle("solid");
        style.setProperty("borderBottomColor", (Object)"#000000");
        style.setProperty("borderBottomStyle", (Object)"solid");
        style.setProperty("borderBottomWidth", (Object)"thin");
        style.setProperty("borderLeftColor", (Object)"#000000");
        style.setProperty("borderLeftStyle", (Object)"solid");
        style.setProperty("borderLeftWidth", (Object)"thin");
        style.setProperty("borderRightColor", (Object)"#000000");
        style.setProperty("borderRightStyle", (Object)"solid");
        style.setProperty("borderRightWidth", (Object)"thin");
        style.setProperty("borderTopColor", (Object)"#000000");
        style.setProperty("borderTopStyle", (Object)"solid");
        style.setProperty("borderTopWidth", (Object)"thin");
        SharedStyleHandle style2 = this.designFactory.newStyle("table-footer");
        style.setBorderBottomStyle("solid");
        style.setProperty("borderBottomColor", (Object)"#000000");
        style.setProperty("borderBottomStyle", (Object)"solid");
        style.setProperty("borderBottomWidth", (Object)"thin");
        style.setProperty("borderLeftColor", (Object)"#000000");
        style.setProperty("borderLeftStyle", (Object)"solid");
        style.setProperty("borderLeftWidth", (Object)"thin");
        style.setProperty("borderRightColor", (Object)"#000000");
        style.setProperty("borderRightStyle", (Object)"solid");
        style.setProperty("borderRightWidth", (Object)"thin");
        style.setProperty("borderTopColor", (Object)"#000000");
        style.setProperty("borderTopStyle", (Object)"solid");
        style.setProperty("borderTopWidth", (Object)"thin");
        this.designHandle.getStyles().add((DesignElementHandle)style);
        this.designHandle.getStyles().add((DesignElementHandle)style2);
    }

    void buildTable() throws SemanticException {
        TableHandle table = this.designFactory.newTableItem("table", 7);
        table.setWidth("100%");
        table.setDataSet(this.designHandle.findDataSet("ds"));
        RowHandle tableheader = (RowHandle)table.getHeader().get(0);
        CellHandle cell = (CellHandle)tableheader.getCells().get(0);
        cell.setColumnSpan(2);
        cell.setRowSpan(1);
        cell = (CellHandle)tableheader.getCells().get(1);
        cell.setColumnSpan(5);
        cell.setRowSpan(1);
        RowHandle tabledetail = (RowHandle)table.getDetail().get(0);
        cell = (CellHandle)tabledetail.getCells().get(0);
        DataItemHandle data = this.designFactory.newDataItem("data");
        data.setValueExpr("row[\"trand_dt\"]");
        data.setStyleName("month");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)tabledetail.getCells().get(1);
        data = this.designFactory.newDataItem("data");
        data.setValueExpr("row[\"trand_dt\"]");
        data.setStyleName("day");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)tabledetail.getCells().get(2);
        data = this.designFactory.newDataItem("data");
        data.setValueExpr("row[\"trans_id\"]");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)tabledetail.getCells().get(3);
        data = this.designFactory.newDataItem("data");
        data.setValueExpr("row[\"trand_ty\"]");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)tabledetail.getCells().get(4);
        data = this.designFactory.newDataItem("data");
        data.setValueExpr("if (row[\"trans_amt\"]>=0)row[\"trans_amt\"];else null");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)tabledetail.getCells().get(5);
        data = this.designFactory.newDataItem("data");
        data.setValueExpr("if (row[\"trans_amt\"]&lt;=0)row[\"trans_amt\"];else null;");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)tabledetail.getCells().get(6);
        data = this.designFactory.newDataItem("data");
        data.setValueExpr("row[\"trans_amt\"]");
        data.setStyleName("TransactionType");
        cell.getContent().add((DesignElementHandle)data);
        RowHandle tablefooter = (RowHandle)table.getFooter().get(0);
        cell = (CellHandle)tablefooter.getCells().get(0);
        cell.setColumnSpan(4);
        cell.setRowSpan(1);
        LabelHandle label1 = this.designFactory.newLabel("label");
        label1.setProperty("fontWeight", (Object)"bold");
        label1.setText("Overall Balance:");
        cell.getContent().add((DesignElementHandle)label1);
        cell = (CellHandle)tablefooter.getCells().get(1);
        cell.setColumnSpan(2);
        cell.setRowSpan(1);
        DataItemHandle data1 = this.designFactory.newDataItem("data");
        data1.setProperty("textAlign", (Object)"left");
        data1.setValueExpr("Total.sum(row[\"trans_amt\"])");
        cell.getContent().add((DesignElementHandle)data1);
        cell = (CellHandle)tablefooter.getCells().get(2);
        DataItemHandle data2 = this.designFactory.newDataItem("data");
        data1.setStyleName("TransactionType");
        data1.setValueExpr("Total.sum(row[\"trans_amt\"])");
        cell.getContent().add((DesignElementHandle)data2);
        this.designHandle.getBody().add((DesignElementHandle)table);
    }

    void buildGroups() throws SemanticException {
        TableGroupHandle group1 = this.designFactory.newTableGroup();
        group1.setName("AccountName");
        group1.setInterval("interval");
        group1.setIntervalRange(3.0);
        group1.setSortDirection("asc");
        group1.setKeyExpr("row[\"account_id\"]");
        group1.setTocExpression("Account Name: row[\"account_id\"]");
        RowHandle groupheader1 = (RowHandle)group1.getHeader().get(0);
        groupheader1.setProperty("fontWeight", (Object)"bold");
        CellHandle cell = (CellHandle)groupheader1.getCells().get(0);
        cell.setColumnSpan(2);
        cell.setRowSpan(1);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        cell.setProperty("paddingTop", (Object)"0cm");
        LabelHandle label = this.designFactory.newLabel("label");
        label.setProperty("fontWeight", (Object)"bold");
        label.setText("Account Name:");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)groupheader1.getCells().get(1);
        cell.setColumnSpan(5);
        cell.setRowSpan(1);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        cell.setProperty("paddingTop", (Object)"0cm");
        DataItemHandle data = this.designFactory.newDataItem("data");
        data.setProperty("marginTop", (Object)"0.5pt");
        data.setValueExpr("row[\"account_id\"]");
        cell.getContent().add((DesignElementHandle)data);
        TableGroupHandle group2 = this.designFactory.newTableGroup();
        group2.setName("year");
        group2.setInterval("year");
        group2.setIntervalRange(1.0);
        group2.setSortDirection("asc");
        group2.setKeyExpr("row[\"trand_dt\"]");
        group2.setTocExpression("Year: row[\"trand_dt\"].getFullYear()");
        RowHandle groupheader2 = (RowHandle)group2.getHeader().get(0);
        groupheader2.setProperty("fontWeight", (Object)"bold");
        groupheader2.setProperty("backgroundColor", (Object)"#C0C0C0");
        cell = (CellHandle)groupheader2.getCells().get(0);
        cell.setColumnSpan(2);
        cell.setRowSpan(1);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        cell.setProperty("paddingTop", (Object)"0cm");
        label = this.designFactory.newLabel("label");
        label.setProperty("fontWeight", (Object)"bold");
        label.setText("Year:");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)groupheader2.getCells().get(1);
        cell.setColumnSpan(5);
        cell.setRowSpan(1);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        cell.setProperty("paddingTop", (Object)"0cm");
        data = this.designFactory.newDataItem("data");
        data.setStyleName("year");
        data.setValueExpr("row[\"trand_dt\"]");
        cell.getContent().add((DesignElementHandle)data);
        RowHandle groupfooter2 = (RowHandle)group2.getFooter().get(0);
        cell = (CellHandle)groupfooter2.getCells().get(0);
        cell.setColumnSpan(4);
        cell.setRowSpan(1);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        cell.setProperty("paddingTop", (Object)"0cm");
        label = this.designFactory.newLabel("label");
        label.setProperty("fontWeight", (Object)"bold");
        label.setText("Annual Balance:");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)groupfooter2.getCells().get(1);
        cell.setColumnSpan(2);
        cell.setRowSpan(1);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        data = this.designFactory.newDataItem("data");
        data.setProperty("textAlign", (Object)"left");
        data.setValueExpr("Total.sum(row[\"trans_amt\"])");
        cell = (CellHandle)groupfooter2.getCells().get(2);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        data = this.designFactory.newDataItem("data");
        data.setStyleName("TransactionType");
        data.setValueExpr("Total.sum(row[\"trans_amt\"])");
        TableGroupHandle group3 = this.designFactory.newTableGroup();
        group3.setName("month");
        group3.setInterval("month");
        group3.setIntervalRange(1.0);
        group3.setSortDirection("asc");
        group3.setKeyExpr("row[\"trand_dt\"]");
        group3.setTocExpression("Month: (row[\"trand_dt\"].getMonth()+1)");
        SortKey sort = StructureFactory.createSortKey();
        sort.setKey("row[\"trand_dt\"].getMonth()");
        FilterCondition filter = StructureFactory.createFilterCond();
        filter.setOperator("le");
        filter.setExpr("row[\"trand_dt\"].getMonth()");
        filter.setValue1("params[\"month\"].getMonth()");
        group3.getPropertyHandle("sort").addItem((IStructure)sort);
        group3.getPropertyHandle("filter").addItem((IStructure)filter);
        RowHandle groupheader3 = (RowHandle)group3.getHeader().get(0);
        groupheader3.setProperty("fontWeight", (Object)"bold");
        groupheader3.setProperty("backgroundColor", (Object)"#008040");
        groupheader3.setProperty("color", (Object)"#FFFFFF");
        cell = (CellHandle)groupheader3.getCells().get(0);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        cell.setProperty("paddingTop", (Object)"0cm");
        label = this.designFactory.newLabel("label");
        label.setText("Month");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)groupheader3.getCells().get(1);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        label = this.designFactory.newLabel("label");
        label.setText("Day");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)groupheader3.getCells().get(2);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        label = this.designFactory.newLabel("label");
        label.setText("Transaction Code");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)groupheader3.getCells().get(3);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        label = this.designFactory.newLabel("label");
        label.setText("Desc");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)groupheader3.getCells().get(4);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        label = this.designFactory.newLabel("label");
        label.setText("Credit");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)groupheader3.getCells().get(5);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        label = this.designFactory.newLabel("label");
        label.setText("Debit");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)groupheader3.getCells().get(6);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        label = this.designFactory.newLabel("label");
        label.setText("Transaction Type");
        cell.getContent().add((DesignElementHandle)label);
        RowHandle groupfooter3 = (RowHandle)group3.getFooter().get(0);
        cell = (CellHandle)groupfooter3.getCells().get(0);
        cell.setColumnSpan(4);
        cell.setRowSpan(1);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        label = this.designFactory.newLabel("label");
        label.setProperty("fontWeight", (Object)"bold");
        label.setText("Monthly Balance:");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)groupfooter3.getCells().get(1);
        cell.setColumnSpan(2);
        cell.setRowSpan(1);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        data = this.designFactory.newDataItem("data");
        data.setProperty("textAlign", (Object)"left");
        data.setValueExpr("Total.sum(row[\"trans_amt\"])");
        cell = (CellHandle)groupfooter3.getCells().get(2);
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
        data = this.designFactory.newDataItem("data");
        data.setStyleName("TransactionType");
        data.setValueExpr("Total.sum(row[\"trans_amt\"])");
        SlotHandle groups = ((TableHandle)this.designHandle.findElement("table")).getGroups();
        groups.add((DesignElementHandle)group1);
        groups.add((DesignElementHandle)group2);
        groups.add((DesignElementHandle)group3);
    }

    private void buildLibrary() throws SemanticException {
        this.libraryHandle.setName("library");
        LabelHandle label = this.libraryFactory.newLabel("label");
        label.setText("Personal Finacial Report");
        this.libraryHandle.getComponents().add((DesignElementHandle)label);
    }

    void buildTheme() throws SemanticException {
        ThemeHandle theme = this.libraryFactory.newTheme("theme1");
        this.libraryHandle.getThemes().add((DesignElementHandle)theme);
        SharedStyleHandle year = this.libraryFactory.newStyle("year");
        year.setDateTimeFormat("yyyy");
        year.setDateTimeFormatCategory("Custom");
        SharedStyleHandle month = this.libraryFactory.newStyle("month");
        month.setDateTimeFormat("MM");
        month.setDateTimeFormatCategory("Custom");
        SharedStyleHandle day = this.libraryFactory.newStyle("day");
        day.setDateTimeFormat("dd");
        day.setDateTimeFormatCategory("Custom");
        SharedStyleHandle transaction = this.libraryFactory.newStyle("TransactionType");
        MapRule map1 = StructureFactory.createMapRule();
        SimpleValueHandle value1 = (SimpleValueHandle)map1.getProperty(this.libraryHandle.getModule(), "display");
        MapRuleHandle maprule1 = (MapRuleHandle)map1.getHandle(value1);
        maprule1.setTestExpression("row[\"trans_amt\"]");
        maprule1.setOperator("lt");
        maprule1.setValue1("0");
        maprule1.setDisplay("D");
        PropertyHandle prophandle = transaction.getPropertyHandle("mapRules");
        prophandle.addItem((Object)maprule1);
        MapRule map2 = StructureFactory.createMapRule();
        SimpleValueHandle value2 = (SimpleValueHandle)map2.getProperty(this.libraryHandle.getModule(), "display");
        MapRuleHandle maprule2 = (MapRuleHandle)map1.getHandle(value2);
        maprule2.setTestExpression("row[\"trans_amt\"]");
        maprule2.setOperator("ge");
        maprule2.setValue1("0");
        maprule2.setDisplay("C");
        prophandle.addItem((Object)maprule2);
        theme.getStyles().add((DesignElementHandle)year);
        theme.getStyles().add((DesignElementHandle)month);
        theme.getStyles().add((DesignElementHandle)day);
        theme.getStyles().add((DesignElementHandle)transaction);
    }
}

