/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.editors;

import java.text.Bidi;
import java.util.ArrayList;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;

public class SQLUtility {
    public static void saveDataSetDesign(DataSetDesign design, IResultSetMetaData meta, IParameterMetaData paramMeta) {
        try {
            SQLUtility.setParameterMetaData(design, paramMeta);
            SQLUtility.setResultSetMetaData(design, meta);
        }
        catch (OdaException e) {
            design.setResultSets(null);
        }
    }

    private static void setParameterMetaData(DataSetDesign dataSetDesign, IParameterMetaData paramMeta) {
        try {
            SQLUtility.mergeParameterMetaData(dataSetDesign, paramMeta);
        }
        catch (OdaException odaException) {
            // empty catch block
        }
    }

    public static int[] getBidiLineSegments(String lineText) {
        int[] seg = null;
        if (lineText != null && lineText.length() > 0 && !new Bidi(lineText, 0).isLeftToRight()) {
            ArrayList<Object> list = new ArrayList<Object>();
            Object[] splits = lineText.split("\\p{Punct}");
            int i = 0;
            while (i < splits.length) {
                if (!splits[i].equals("")) {
                    list.add(splits[i]);
                }
                ++i;
            }
            splits = list.toArray();
            seg = new int[splits.length + 1];
            i = 0;
            while (i < splits.length) {
                seg[i + 1] = lineText.indexOf((String)splits[i], seg[i]) + ((String)splits[i]).length();
                ++i;
            }
        }
        return seg;
    }

    public static String getQueryPresetTextString(String extensionId) {
        String[] lines = SQLUtility.getQueryPresetTextArray(extensionId);
        StringBuilder result = new StringBuilder();
        if (lines != null && lines.length > 0) {
            int i = 0;
            while (i < lines.length) {
                result.append(lines[i]).append(i == lines.length - 1 ? " " : " \n");
                ++i;
            }
        }
        return result.toString();
    }

    public static String[] getQueryPresetTextArray(String extensionId) {
        String[] lines = extensionId.equals("org.eclipse.birt.report.data.oda.jdbc.SPSelectDataSet") ? new String[]{"{call procedure-name(arg1,arg2, ...)}"} : new String[]{"select", "from"};
        return lines;
    }

    private static void mergeParameterMetaData(DataSetDesign dataSetDesign, IParameterMetaData md) throws OdaException {
        if (md == null || dataSetDesign == null) {
            return;
        }
        DataSetParameters dataSetParameter = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)md, (ParameterMode)ParameterMode.IN_LITERAL);
        if (dataSetParameter != null) {
            for (ParameterDefinition defn : dataSetParameter.getParameterDefinitions()) {
                SQLUtility.proccessParamDefn(defn, dataSetParameter);
            }
        }
        dataSetDesign.setParameters(dataSetParameter);
    }

    private static void proccessParamDefn(ParameterDefinition defn, DataSetParameters parameters) {
        if (defn.getAttributes().getNativeDataTypeCode() == 0) {
            defn.getAttributes().setNativeDataTypeCode(1);
        }
    }

    private static void setResultSetMetaData(DataSetDesign dataSetDesign, IResultSetMetaData md) throws OdaException {
        if (md == null || dataSetDesign == null) {
            return;
        }
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        if (columns != null) {
            ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
            resultSetDefn.setResultSetColumns(columns);
            dataSetDesign.setPrimaryResultSet(resultSetDefn);
            dataSetDesign.getResultSets().setDerivedMetaData(true);
        } else {
            dataSetDesign.setResultSets(null);
        }
    }
}

