/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.querymodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.birt.data.oda.pojo.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.impl.Driver;
import org.eclipse.birt.data.oda.pojo.querymodel.ColumnReferenceNode;
import org.eclipse.birt.data.oda.pojo.querymodel.IMethodParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.MethodSource;
import org.eclipse.birt.data.oda.pojo.querymodel.PojoQuery;
import org.eclipse.birt.data.oda.pojo.querymodel.ReferenceGraph;
import org.eclipse.birt.data.oda.pojo.querymodel.ReferenceNode;
import org.eclipse.birt.data.oda.pojo.querymodel.VariableParameter;
import org.eclipse.birt.data.oda.pojo.util.MethodParameterType;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class QueryParameters {
    private QueryParameter[] qps;
    private Map<String, Integer> nameIndexMap = new HashMap<String, Integer>();

    public String getParamName(int index) {
        if (index >= 1 && index <= this.qps.length) {
            return this.qps[index - 1].name;
        }
        return null;
    }

    private QueryParameters(QueryParameter[] qps) {
        assert (qps != null);
        this.qps = qps;
        int i = 1;
        QueryParameter[] queryParameterArray = qps;
        int n = qps.length;
        int n2 = 0;
        while (n2 < n) {
            QueryParameter qp = queryParameterArray[n2];
            this.nameIndexMap.put(qp.name, i++);
            ++n2;
        }
    }

    public int findInParameter(String parameterName) throws OdaException {
        Integer index = this.nameIndexMap.get(parameterName);
        if (index == null) {
            throw new OdaException(Messages.getString("QueryParameters.InexistentParameter", parameterName));
        }
        return index;
    }

    public IParameterMetaData getParameterMetaData() {
        return new IParameterMetaData(){

            public int getParameterCount() throws OdaException {
                return QueryParameters.this.qps.length;
            }

            public int getParameterMode(int param) throws OdaException {
                return 1;
            }

            public String getParameterName(int param) throws OdaException {
                return QueryParameters.this.qps[param - 1].name;
            }

            public int getParameterType(int param) throws OdaException {
                return Driver.getNativeDataTypeCode(this.getParameterTypeName(param));
            }

            public String getParameterTypeName(int param) throws OdaException {
                return QueryParameters.this.qps[param - 1].nativeTypeName;
            }

            public int getPrecision(int param) throws OdaException {
                return -1;
            }

            public int getScale(int param) throws OdaException {
                return -1;
            }

            public int isNullable(int param) throws OdaException {
                return 0;
            }
        };
    }

    public static QueryParameters create(PojoQuery pq) throws OdaException {
        ReferenceGraph rg = pq.getReferenceGraph();
        ColumnReferenceNode[] crns = rg.getColumnReferences();
        HashMap<String, String> methodParamNameTypeMap = new HashMap<String, String>();
        ArrayList paramList = new ArrayList();
        ColumnReferenceNode[] columnReferenceNodeArray = crns;
        int n = crns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnReferenceNode crn = columnReferenceNodeArray[n2];
            Stack<List<QueryParameter>> params = QueryParameters.getQueryParameters(crn, methodParamNameTypeMap);
            while (!params.empty()) {
                paramList.addAll(params.pop());
            }
            ++n2;
        }
        return new QueryParameters(paramList.toArray(new QueryParameter[0]));
    }

    private static Stack<List<QueryParameter>> getQueryParameters(ColumnReferenceNode crn, Map<String, String> methodParamNameTypeMap) throws OdaException {
        Stack<List<QueryParameter>> params = new Stack<List<QueryParameter>>();
        ReferenceNode rn = crn;
        while (rn != null) {
            if (rn.getReference() instanceof MethodSource) {
                MethodSource ms = (MethodSource)rn.getReference();
                ArrayList<QueryParameter> ps = new ArrayList<QueryParameter>();
                IMethodParameter[] iMethodParameterArray = ms.getParameters();
                int n = iMethodParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethodParameter mp = iMethodParameterArray[n2];
                    if (mp instanceof VariableParameter) {
                        VariableParameter vp = (VariableParameter)mp;
                        String detectedType = methodParamNameTypeMap.get(vp.getName());
                        if (detectedType == null) {
                            methodParamNameTypeMap.put(vp.getName(), vp.getDataType());
                            ps.add(new QueryParameter(vp.getName(), MethodParameterType.getNativeOdaDataTypeName(vp.getDataType())));
                        } else if (!vp.getDataType().equals(detectedType)) {
                            throw new OdaException(Messages.getString("QueryParameters.OneMethodParameterWith2Types", vp.getName(), vp.getDataType(), detectedType));
                        }
                    }
                    ++n2;
                }
                params.push(ps);
            }
            rn = rn.getParent();
        }
        return params;
    }

    private static class QueryParameter {
        private String name;
        private String nativeTypeName;

        public QueryParameter(String name, String nativeTypeName) {
            this.name = name;
            this.nativeTypeName = nativeTypeName;
        }
    }
}

