/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.junit.Test;

public class ArchiveFileCacheTest
extends TestCase {
    @Test
    public void testMemoryCache() throws IOException {
        long used1 = ArchiveFile.getTotalUsedCache();
        System.out.println("INIT:" + used1);
        ArchiveFile[] afs = new ArchiveFile[10];
        int i = 0;
        while (i < afs.length) {
            afs[i] = this.createArchiveFile("utest/arc_" + i);
            ++i;
        }
        long used2 = ArchiveFile.getTotalUsedCache();
        System.out.println("OPEN 10 AFS:" + used2);
        ArchiveEntry[] entries = this.openEntries(afs[0], 100);
        long used3 = ArchiveFile.getTotalUsedCache();
        System.out.println("OPEN ENTRIES:" + used3);
        this.closeEntries(entries);
        long used4 = ArchiveFile.getTotalUsedCache();
        System.out.println("CLOSE ENTRIES:" + used4);
        int i2 = 0;
        while (i2 < afs.length) {
            afs[i2].close();
            ++i2;
        }
        long used5 = ArchiveFile.getTotalUsedCache();
        System.out.println("CLOSE FILES:" + used5);
    }

    protected ArchiveFile createArchiveFile(String name) throws IOException {
        ArchiveFile af = new ArchiveFile(name, "rwt");
        af.setCacheSize(40960L);
        int i = 0;
        while (i < 100) {
            ArchiveEntry entry = af.createEntry("STREAM_" + i);
            long position = 0L;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(buffer);
            output.writeUTF("STREAM_" + i + "[CONTENT]");
            byte[] bytes = buffer.toByteArray();
            int j = 0;
            while (j < 4096) {
                entry.write(position, bytes, 0, bytes.length);
                position += (long)bytes.length;
                ++j;
            }
            entry.close();
            ++i;
        }
        return af;
    }

    protected ArchiveEntry[] openEntries(ArchiveFile af, int size) throws IOException {
        ArchiveEntry[] entries = new ArchiveEntry[size];
        int i = 0;
        while (i < entries.length) {
            entries[i] = af.openEntry("STREAM_" + i);
            entries[i].read(0L, new byte[13], 0, 13);
            ++i;
        }
        return entries;
    }

    protected void closeEntries(ArchiveEntry[] entries) throws IOException {
        int i = 0;
        while (i < entries.length) {
            entries[i].close();
            ++i;
        }
    }
}

