/***********************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0/.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 *
 * Contributors:
 * Actuate Corporation - initial API and implementation
 ***********************************************************************/

package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.birt.chart.ui.swt.AbstractLineWidthChooserComposite;
import org.eclipse.birt.core.ui.swt.custom.ICustomChoice;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

/**
 * LineWidthChooserComposite
 */
public class LineWidthChooserComposite extends AbstractLineWidthChooserComposite {

	private static final Integer[] iLineWidths = { 1, 2, 3,
			4 };

	static class LineWidthChoice extends LineCanvas implements ICustomChoice {

		LineWidthChoice(Composite parent, int iStyle, int iLineWidth) {
			super(parent, iStyle, SWT.LINE_SOLID, iLineWidth);
		}

		@Override
		public Object getValue() {
			return Integer.valueOf(getLineWidth());
		}

		@Override
		public void setValue(Object value) {
			if (value != null) {
				setLineWidth(((Integer) value).intValue());
			}
		}

	}

	public LineWidthChooserComposite(Composite parent, int style, int iWidth) {
		super(parent, style, Integer.valueOf(iWidth));
		setItems(iLineWidths);
	}

	public LineWidthChooserComposite(Composite parent, int style, int iWidth, Integer[] lineWidths) {
		super(parent, style, Integer.valueOf(iWidth));
		setItems(lineWidths);
	}

	@Override
	protected ICustomChoice createChoice(Composite parent, Object choiceValue) {
		if (choiceValue == null) {
			choiceValue = Integer.valueOf(0);
		}
		return new LineWidthChoice(parent, SWT.NONE, ((Integer) choiceValue).intValue());
	}

	/**
	 * Returns the currently selected line width
	 *
	 * @return currently selected line width
	 */
	@Override
	public int getLineWidth() {
		return ((Integer) getChoiceValue()).intValue();
	}

	@Override
	public void setLineWidth(int iWidth) {
		setChoiceValue(Integer.valueOf(iWidth));
	}

	@Override
	public void setLineWidth(int iWidth, EObject eParent) {
		setLineWidth(iWidth);
	}

}
