/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.integration.wtp.ui.internal.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.integration.wtp.ui.internal.exception.ChartIntegrationException;
import org.eclipse.birt.chart.integration.wtp.ui.internal.i18n.BirtWTPMessages;
import org.eclipse.birt.chart.integration.wtp.ui.internal.util.Logger;
import org.eclipse.birt.chart.integration.wtp.ui.internal.util.WebArtifactUtil;
import org.eclipse.birt.chart.integration.wtp.ui.internal.webapp.WebAppBean;
import org.eclipse.birt.chart.integration.wtp.ui.internal.wizards.BirtWizardUtil;
import org.eclipse.birt.chart.integration.wtp.ui.internal.wizards.IBirtWizardConstants;
import org.eclipse.birt.chart.integration.wtp.ui.internal.wizards.SimpleImportOverwriteQuery;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class BirtWebProjectWizard
extends WebProjectWizard
implements IBirtWizardConstants {
    private IConfigurationElement wizardConfigElement;
    private Map properties;
    private String configFolder;

    public BirtWebProjectWizard() {
        this.setWindowTitle(BirtWTPMessages.BIRTProjectCreationWizard_title);
        this.setNeedsProgressMonitor(true);
        this.properties = new HashMap();
    }

    public BirtWebProjectWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(BirtWTPMessages.BIRTProjectCreationWizard_title);
        this.setNeedsProgressMonitor(true);
        this.properties = new HashMap();
    }

    protected IFacetedProjectTemplate getTemplate() {
        return ProjectFacetsManager.getTemplate((String)"template.birt.chart.runtime");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.wizardConfigElement = BirtWizardUtil.findConfigurationElementById("org.eclipse.ui.newWizards", "org.eclipse.birt.chart.integration.wtp.ui.internal.wizards.BirtWebProjectCreationWizard");
        String title = this.wizardConfigElement.getAttribute("name");
        if (title != null) {
            this.setWindowTitle(title);
        }
        BirtWizardUtil.initWebapp(this.properties);
    }

    protected void performFinish(IProgressMonitor monitor) throws CoreException {
        super.performFinish(monitor);
        this.configFolder = BirtWizardUtil.getConfigFolder(this.getDataModel());
        if (this.configFolder == null) {
            String message = BirtWTPMessages.BIRTErrors_wrong_webcontent;
            Logger.log(4, message);
            throw ChartIntegrationException.getException(message, null);
        }
        this.preConfiguration(monitor);
        this.processConfiguration(monitor);
        monitor.done();
    }

    protected void preConfiguration(IProgressMonitor monitor) throws CoreException {
        BirtWizardUtil.processCheckFolder(this.properties, this.getFacetedProject().getProject(), this.configFolder, monitor);
    }

    protected void processConfiguration(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getFacetedProject().getProject();
        SimpleImportOverwriteQuery query = new SimpleImportOverwriteQuery();
        WebArtifactUtil.configureWebApp((WebAppBean)this.properties.get("webapp"), project, query, monitor);
        WebArtifactUtil.configureContextParam((Map)this.properties.get("context-param"), project, query, monitor);
        WebArtifactUtil.configureListener((Map)this.properties.get("listener"), project, query, monitor);
        WebArtifactUtil.configureServlet((Map)this.properties.get("servlet"), project, query, monitor);
        WebArtifactUtil.configureServletMapping((Map)this.properties.get("servlet-mapping"), project, query, monitor);
        WebArtifactUtil.configureTaglib((Map)this.properties.get("taglib"), project, query, monitor);
    }
}

