/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;
import org.eclipse.birt.report.model.util.ResourceLocatorImpl;

public class DefaultSearchFileAlgorithmTest
extends BaseTestCase {
    private ResourceLocatorImpl rl;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ULocale locale = new ULocale("en_US");
        this.createDesign(locale);
        this.rl = new ResourceLocatorImpl();
    }

    private List dumpJarContentsToFile(List fileNames) throws Exception {
        ArrayList<String> filePaths = new ArrayList<String>();
        int i = 0;
        while (i < fileNames.size()) {
            String resourceName = (String)fileNames.get(i);
            filePaths.add(this.copyContentToFile(resourceName));
            ++i;
        }
        return filePaths;
    }

    public void testFindFile() throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add("input/MasterPageHandleTest.xml");
        fileNames.add("golden/CustomColorHandleTest_golden.xml");
        List diskFiles = this.dumpJarContentsToFile(fileNames);
        File f = new File((String)diskFiles.get(0));
        this.designHandle.getModule().setSystemId(f.getParentFile().toURL());
        URL url = this.rl.findResource((ModuleHandle)this.designHandle, "1.xml", 1);
        DefaultSearchFileAlgorithmTest.assertNull((Object)url);
        url = this.rl.findResource((ModuleHandle)this.designHandle, "MasterPageHandleTest.xml", 1);
        DefaultSearchFileAlgorithmTest.assertNotNull((Object)url);
        url = this.rl.findResource((ModuleHandle)this.designHandle, "1.xml", 1);
        DefaultSearchFileAlgorithmTest.assertNull((Object)url);
        f = new File((String)diskFiles.get(1));
        this.designHandle.getModule().setSystemId(f.getParentFile().toURL());
        url = this.rl.findResource((ModuleHandle)this.designHandle, "CustomColorHandleTest_golden.xml", 1);
        DefaultSearchFileAlgorithmTest.assertNotNull((Object)url);
        url = this.rl.findResource((ModuleHandle)this.designHandle, url.toString(), 1);
        DefaultSearchFileAlgorithmTest.assertNotNull((Object)url);
    }

    public void testFindMessageFiles() throws Exception {
        String testFile = "ResourceLocator";
        URL url = this.getResource("input/");
        this.designHandle.getModule().setSystemId(url);
        URL resource = this.designHandle.findResource(testFile, 5);
        String strResource = resource.toString();
        DefaultSearchFileAlgorithmTest.assertTrue((strResource.indexOf("en_US") != -1 ? 1 : 0) != 0);
    }

    public void testFindResourceInJar() throws Exception {
        String jarPath = this.copyContentToFile("input/testRead.jar");
        String resource = "jar:file:" + jarPath + "!/test/testRead.rptdesign";
        URL url = this.rl.findResource((ModuleHandle)this.designHandle, resource, 2);
        DefaultSearchFileAlgorithmTest.assertNotNull((Object)url);
        URLConnection jarConnection = url.openConnection();
        jarConnection.connect();
        InputStream inputStream = jarConnection.getInputStream();
        DefaultSearchFileAlgorithmTest.assertNotNull((Object)inputStream);
        inputStream.close();
    }

    public void testFindResourceInFragments() throws Exception {
        this.openDesign("SearchFragmentsTest.xml");
        DefaultSearchFileAlgorithmTest.assertNotNull((Object)this.designHandle);
        LabelHandle labelFromLib = (LabelHandle)this.designHandle.findElement("labelFromLib");
        DefaultSearchFileAlgorithmTest.assertNotNull((Object)labelFromLib);
        DefaultSearchFileAlgorithmTest.assertEquals((String)"library text", (String)labelFromLib.getDisplayText());
        LabelHandle externalizedLabel = (LabelHandle)this.designHandle.findElement("externalizedLabel");
        DefaultSearchFileAlgorithmTest.assertNotNull((Object)externalizedLabel);
        DefaultSearchFileAlgorithmTest.assertEquals((String)"label_localized", (String)externalizedLabel.getDisplayText());
        ImageHandle image = (ImageHandle)this.designHandle.findElement("image");
        URL url = this.rl.findResource((ModuleHandle)this.designHandle, image.getURI(), 1);
        DefaultSearchFileAlgorithmTest.assertEquals((String)"bundleresource", (String)url.getProtocol());
        DefaultSearchFileAlgorithmTest.assertEquals((String)"/images/20063201445066811.gif", (String)url.getPath());
        url = this.rl.findResource((ModuleHandle)this.designHandle, "libs/lib.rptlibrary", 2);
        DefaultSearchFileAlgorithmTest.assertNotNull((Object)url);
        DefaultSearchFileAlgorithmTest.assertNotNull((Object)this.sessionHandle);
        this.libraryHandle = this.sessionHandle.openLibrary(url.toString());
        DefaultSearchFileAlgorithmTest.assertNotNull((Object)this.libraryHandle);
    }

    public void testResourceFolder() throws Exception {
        String testFile = "CustomColorHandleTest_golden.xml";
        this.designHandle.setResourceFolder(this.getResource("input/").toString());
        URL resource = this.rl.findResource((ModuleHandle)this.designHandle, testFile, 1);
        DefaultSearchFileAlgorithmTest.assertNull((Object)resource);
        this.sessionHandle.setResourceFolder(this.getResource("golden/").toString());
        resource = this.rl.findResource((ModuleHandle)this.designHandle, testFile, 1);
        DefaultSearchFileAlgorithmTest.assertNotNull((Object)resource);
        DefaultSearchFileAlgorithmTest.assertTrue((boolean)resource.toString().endsWith(testFile));
    }

    public void testFindJarFiles() throws Exception {
        this.sessionHandle.setResourceFolder(this.getResource("input/").toString());
        String testFile = "Resourcelocator_test.jar";
        URL resource = this.rl.findResource((ModuleHandle)this.designHandle, testFile, 4);
        DefaultSearchFileAlgorithmTest.assertNotNull((Object)resource);
    }

    public void testMail() throws Exception {
        String mail = "mailto:dmurphy@classicmodelcars.com";
        URL resource = this.rl.findResource((ModuleHandle)this.designHandle, mail, -1);
        DefaultSearchFileAlgorithmTest.assertEquals((String)mail, (String)resource.toString());
    }
}

