/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_120293
extends BaseTestCase {
    static final String INPUT1 = "Library_1.xml";
    static final String INPUT2 = "DesignWithoutLibrary.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/Library_1.xml");
        this.copyInputToFile("input/DesignWithoutLibrary.xml");
    }

    public void test_regression_120293() throws Exception {
        this.openLibrary(INPUT1, true);
        Iterator imageIter = this.libraryHandle.imagesIterator();
        EmbeddedImageHandle baseImage = (EmbeddedImageHandle)imageIter.next();
        this.openDesign(INPUT2);
        this.designHandle.includeLibrary(INPUT1, "Lib1");
        EmbeddedImage newImage = StructureFactory.newEmbeddedImageFrom((EmbeddedImageHandle)baseImage, (String)"image1", (ModuleHandle)this.designHandle);
        Regression_120293.assertEquals((String)"image1", (String)newImage.getName());
        Regression_120293.assertNotNull((Object)newImage.getData((Module)this.design));
        this.designHandle.addImage(newImage);
        boolean added = false;
        Iterator iter = this.designHandle.imagesIterator();
        while (iter.hasNext()) {
            String name = ((EmbeddedImageHandle)iter.next()).getName();
            if (!"image1".equalsIgnoreCase(name)) continue;
            added = true;
        }
        Regression_120293.assertTrue((boolean)added);
    }
}

