/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.parameters;

import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class ParameterUtil {
    private static final Logger logger = Logger.getLogger(ParameterUtil.class.getName());
    public static final String LABEL_NULL = Messages.getString((String)"ParameterDialog.Label.Null");
    public static final String STANDARD_DATE_TIME_PATTERN = "MM/dd/yyyy hh:mm:ss a";

    private ParameterUtil() {
    }

    public static boolean isCustomCategory(String formatCategory) {
        return "Custom".equals(formatCategory) || "Custom".equals(formatCategory) || "Custom".equals(formatCategory) || "Custom".equals(formatCategory) || "Custom".equals(formatCategory);
    }

    public static String format(String value, String dataType, String formatCategory, String formatPattern, boolean canbeNull) {
        if (canbeNull && value == null) {
            return LABEL_NULL;
        }
        if (StringUtil.isBlank((String)value) || formatCategory == null) {
            return value;
        }
        try {
            String pattern = formatPattern;
            if (formatPattern == null) {
                if (ParameterUtil.isCustomCategory(formatCategory)) {
                    return value;
                }
                pattern = formatCategory;
            }
            if ("dateTime".equals(dataType)) {
                value = ParameterUtil.convertToStandardFormat(DataTypeUtil.toDate((Object)value));
            } else if ("date".equals(dataType)) {
                value = ParameterUtil.convertToStandardFormat(DataTypeUtil.toSqlDate((Object)value));
            } else if ("time".equals(dataType)) {
                value = ParameterUtil.convertToStandardFormat(DataTypeUtil.toSqlTime((Object)value));
            } else if ("float".equals(dataType)) {
                value = new NumberFormatter(pattern).format(DataTypeUtil.toDouble((Object)value).doubleValue());
            } else if ("decimal".equals(dataType)) {
                value = new NumberFormatter(pattern).format(DataTypeUtil.toBigDecimal((Object)value));
            } else if ("string".equals(dataType)) {
                value = new StringFormatter(pattern).format(value);
            }
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return value;
    }

    public static String convertToStandardFormat(Date date) {
        if (date == null) {
            return null;
        }
        return new DateFormatter(STANDARD_DATE_TIME_PATTERN, ULocale.getDefault()).format(date);
    }

    public static String format(ParameterHandle handle, String value) throws BirtException {
        if (handle instanceof ScalarParameterHandle) {
            ScalarParameterHandle sphandle = (ScalarParameterHandle)handle;
            value = ParameterUtil.format(value, sphandle.getDataType(), sphandle.getCategory(), sphandle.getPattern(), !sphandle.isRequired());
        }
        return value;
    }

    public static Object convert(Object value, String dataType) throws BirtException {
        if ("boolean".equals(dataType)) {
            return DataTypeUtil.toBoolean((Object)value);
        }
        if ("dateTime".equals(dataType)) {
            return DataTypeUtil.toDate((Object)value);
        }
        if ("date".equals(dataType)) {
            return DataTypeUtil.toSqlDate((Object)value);
        }
        if ("time".equals(dataType)) {
            return DataTypeUtil.toSqlTime((Object)value);
        }
        if ("decimal".equals(dataType)) {
            return DataTypeUtil.toBigDecimal((Object)value);
        }
        if ("float".equals(dataType)) {
            return DataTypeUtil.toDouble((Object)value);
        }
        if ("string".equals(dataType)) {
            return DataTypeUtil.toString((Object)value);
        }
        if ("integer".equals(dataType)) {
            return DataTypeUtil.toInteger((Object)value);
        }
        return value;
    }
}

