/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseStylePreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatNumberPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.StylePreferenceStore;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FormatNumberPreferencePage
extends BaseStylePreferencePage
implements IFormatChangeListener {
    private String name;
    private IFormatPage formatPage;
    private FormatChangeEvent event = null;
    private boolean firstCheck = false;

    public FormatNumberPreferencePage(Object model) {
        super(model);
        this.setTitle(Messages.getString((String)"FormatNumberPreferencePage.formatNumber.title"));
        this.setPreferenceName("NumberFormatValue");
    }

    private void setPreferenceName(String name) {
        this.name = name;
    }

    public String getPreferenceName() {
        return this.name;
    }

    protected void adjustGridLayout() {
        ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns = 1;
    }

    @Override
    protected void createFieldEditors() {
        super.createFieldEditors();
        Composite parent = this.getFieldEditorParent();
        this.formatPage = new FormatNumberPage(parent, 0);
        this.formatPage.addFormatChangeListener(this);
        ((Composite)this.formatPage).setLayoutData((Object)new GridData(768));
        this.initiateFormatPage();
        UIUtil.bindHelp((Control)this.getFieldEditorParent().getParent(), "org.eclipse.birt.cshelp.StyleBuilderFormatNumber_ID");
    }

    private void initiateFormatPage() {
        String category = ((StylePreferenceStore)this.getPreferenceStore()).getNumberFormatCategory();
        String pattern = ((StylePreferenceStore)this.getPreferenceStore()).getNumberFormat();
        ULocale locale = ((StylePreferenceStore)this.getPreferenceStore()).getNumberFormatLocale();
        this.formatPage.setInput(category, pattern, locale);
    }

    @Override
    public boolean performOk() {
        IPreferenceStore ps = this.getPreferenceStore();
        if (ps instanceof StylePreferenceStore) {
            ((StylePreferenceStore)ps).clearError();
        }
        boolean rt = this.doStore();
        if (ps instanceof StylePreferenceStore) {
            return !((StylePreferenceStore)ps).hasError();
        }
        return rt;
    }

    protected boolean doStore() {
        if (this.formatPage == null || !this.formatPage.isFormatModified() || !this.formatPage.isDirty()) {
            return true;
        }
        try {
            ((StylePreferenceStore)this.getPreferenceStore()).setNumberFormatCategory(this.formatPage.getCategory());
            ((StylePreferenceStore)this.getPreferenceStore()).setNumberFormat(this.formatPage.getPattern());
            ((StylePreferenceStore)this.getPreferenceStore()).setNumberFormatLocale(this.formatPage.getLocale());
            return true;
        }
        catch (SemanticException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    @Override
    protected String[] getPreferenceNames() {
        return new String[]{"numberFormat"};
    }

    @Override
    public void formatChange(FormatChangeEvent event) {
        if (this.getBuilder() != null) {
            this.event = event;
            this.getBuilder().refreshPagesStatus();
        }
    }

    @Override
    public boolean hasLocaleProperties() {
        if (!this.firstCheck) {
            this.firstCheck = true;
            String[] fields = this.getPreferenceNames();
            if (fields != null) {
                int i = 0;
                while (i < fields.length) {
                    StylePreferenceStore store;
                    if (this.getPreferenceStore() instanceof StylePreferenceStore && (store = (StylePreferenceStore)this.getPreferenceStore()).hasLocalValue(fields[i])) {
                        this.hasLocaleProperty = true;
                        return true;
                    }
                    ++i;
                }
            }
        } else if (this.event != null) {
            this.hasLocaleProperty = true;
        }
        return this.hasLocaleProperty;
    }
}

