/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import org.eclipse.birt.report.designer.internal.ui.util.SortMap;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PreviewPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.PreviewSection;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PreviewPropertyDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PreviewPage
extends AttributePage {
    private PreviewPropertyDescriptorProvider provider;
    private boolean isTabbed = false;
    PreviewPropertyDescriptor preview;
    private PreviewSection previewSection;
    private Composite composite;

    public PreviewPage(boolean isTabbed) {
        this.isTabbed = isTabbed;
    }

    @Override
    public void buildUI(Composite parent) {
        this.container = new ScrolledComposite(parent, 768);
        this.container.setLayoutData((Object)new GridData(1808));
        ((ScrolledComposite)this.container).setExpandHorizontal(true);
        ((ScrolledComposite)this.container).setExpandVertical(true);
        this.container.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PreviewPage.this.computeSize();
            }
        });
        this.composite = new Composite(this.container, 0);
        this.composite.setLayoutData((Object)new GridData(1808));
        if (this.sections == null) {
            this.sections = new SortMap();
        }
        this.composite.setLayout((Layout)WidgetUtil.createGridLayout((int)1));
        this.previewSection = new PreviewSection(this.provider.getDisplayName(), this.composite, true, this.isTabbed);
        this.previewSection.setPreview(this.preview);
        this.previewSection.setProvider(this.provider);
        this.previewSection.setHeight(160);
        this.previewSection.setFillPreview(true);
        this.addSection("PREVIEW_PREVIEW", this.previewSection);
        this.createSections();
        this.layoutSections();
        ((ScrolledComposite)this.container).setContent((Control)this.composite);
    }

    private void computeSize() {
        Point size = this.composite.computeSize(-1, -1);
        ((ScrolledComposite)this.container).setMinSize(size.x, size.y + 10);
        this.container.layout();
    }

    public void setProvider(PreviewPropertyDescriptorProvider provider) {
        this.provider = provider;
    }

    public void setPreview(PreviewPropertyDescriptor preview) {
        this.preview = preview;
    }

    private boolean checkControl(PreviewSection preview) {
        return preview != null && preview.getPreviewControl() != null && !preview.getPreviewControl().getControl().isDisposed();
    }

    @Override
    public void postElementEvent() {
        if (this.checkControl(this.previewSection)) {
            this.previewSection.getPreviewControl().postElementEvent();
        }
    }
}

