/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.joins.figures;

import org.eclipse.birt.report.designer.ui.cubebuilder.joins.figures.ColumnConnection;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.figures.ColumnConnectionAnchor;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ColumnConnectionRouter
extends AbstractRouter {
    public static final int END_LENGTH = 30;
    public static final int FIG1_HORIZONTAL_INTERSECT_FIG2 = 0;
    public static final int FIG1_LEFTOF_FIG2 = 1;
    public static final int FIG1_RIGHTOF_FIG2 = 2;

    protected Rectangle getChopRectangle(ConnectionAnchor anchor) {
        IFigure chopFigure = ((ColumnConnectionAnchor)anchor).getChopFigure();
        return chopFigure.getBounds().getCropped(chopFigure.getInsets());
    }

    protected IFigure getOwnerFigure(ConnectionAnchor anchor) {
        return anchor.getOwner();
    }

    public void route(Connection connection) {
        if (!(connection instanceof ColumnConnection)) {
            return;
        }
        ColumnConnection conn = (ColumnConnection)connection;
        Figure startFigure = null;
        Figure endFigure = null;
        if (conn.getSourceAnchor() instanceof ColumnConnectionAnchor) {
            startFigure = (Figure)((ColumnConnectionAnchor)conn.getSourceAnchor()).getChopFigure();
        }
        if (conn.getTargetAnchor() instanceof ColumnConnectionAnchor) {
            endFigure = (Figure)((ColumnConnectionAnchor)conn.getTargetAnchor()).getChopFigure();
        }
        if (startFigure != null && endFigure != null) {
            Rectangle startContainerRect = startFigure.getBounds();
            Rectangle endContainerRect = endFigure.getBounds();
            Point startPoint = conn.getSourceAnchor().getReferencePoint();
            startFigure.translateToRelative((Translatable)startPoint);
            Point endPoint = conn.getTargetAnchor().getReferencePoint();
            endFigure.translateToRelative((Translatable)endPoint);
            int startY = this.calcPos(startPoint.y, startContainerRect);
            int endY = this.calcPos(endPoint.y, endContainerRect);
            if (startFigure.equals(((ColumnConnectionAnchor)conn.getSourceAnchor()).getOwner()) || endFigure.equals(((ColumnConnectionAnchor)conn.getTargetAnchor()).getOwner())) {
                startY = startContainerRect.y + 10;
                endY = endContainerRect.y + 10;
            }
            conn.removeAllPoints();
            int position = this.getRelativeXPosition(startContainerRect, endContainerRect);
            if (position == 1) {
                conn.addPoint(new Point(startContainerRect.x + startContainerRect.width, startY));
                conn.addPoint(new Point(startContainerRect.x + startContainerRect.width + 30, startY));
                conn.addPoint(new Point(endContainerRect.x - 30, endY));
                conn.addPoint(new Point(endContainerRect.x - 1, endY));
            } else if (position == 2) {
                conn.addPoint(new Point(startContainerRect.x - 1, startY));
                conn.addPoint(new Point(startContainerRect.x - 30, startY));
                conn.addPoint(new Point(endContainerRect.x + endContainerRect.width + 30, endY));
                conn.addPoint(new Point(endContainerRect.x + endContainerRect.width, endY));
            } else {
                int xpos = Math.min(startContainerRect.x, endContainerRect.x) - 30;
                conn.addPoint(new Point(startContainerRect.x, startY));
                conn.addPoint(new Point(xpos, startY));
                conn.addPoint(new Point(xpos, endY));
                conn.addPoint(new Point(endContainerRect.x, endY));
            }
        }
    }

    private int calcPos(int pos, Rectangle rect) {
        if (pos < rect.y) {
            return rect.y + 5;
        }
        if (pos > rect.y + rect.height) {
            return rect.y + rect.height - 5;
        }
        return pos;
    }

    public Dimension getMinimumSize(IFigure parent) {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize(IFigure parent) {
        return this.getMinimumSize(parent);
    }

    private int getRelativeXPosition(Rectangle r1, Rectangle r2) {
        if (r2.x + r2.width < r1.x) {
            return 2;
        }
        if (r1.x + r1.width < r2.x) {
            return 1;
        }
        return 0;
    }

    public Point getStartPoint(Connection conn) {
        Rectangle rec = conn.getTargetAnchor().getOwner().getBounds();
        return conn.getSourceAnchor().getLocation(rec.getCenter());
    }

    public Point getEndPoint(Connection conn) {
        Rectangle rec = conn.getSourceAnchor().getOwner().getBounds();
        return conn.getTargetAnchor().getLocation(rec.getCenter());
    }
}

