/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.core.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.birt.data.engine.core.DataException;

public class FileSecurity {
    public static boolean createNewFile(File file) throws IOException {
        if (file == null) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (Exception typedException) {
            if (typedException instanceof IOException) {
                throw (IOException)typedException;
            }
            return false;
        }
    }

    public static RandomAccessFile createRandomAccessFile(String path, String type) throws FileNotFoundException, DataException {
        try {
            return new RandomAccessFile(path, type);
        }
        catch (Exception typedException) {
            if (typedException instanceof FileNotFoundException) {
                throw (FileNotFoundException)typedException;
            }
            throw new DataException(typedException.getLocalizedMessage());
        }
    }

    public static RandomAccessFile createRandomAccessFile(File file, String type) throws FileNotFoundException {
        try {
            return new RandomAccessFile(file, type);
        }
        catch (Exception typedException) {
            if (typedException instanceof FileNotFoundException) {
                throw (FileNotFoundException)typedException;
            }
            return null;
        }
    }

    public static FileReader createFileReader(File file) throws FileNotFoundException, DataException {
        try {
            return new FileReader(file);
        }
        catch (Exception typedException) {
            if (typedException instanceof FileNotFoundException) {
                throw (FileNotFoundException)typedException;
            }
            throw new DataException(typedException.getLocalizedMessage());
        }
    }

    public static FileOutputStream createFileOutputStream(File file) throws FileNotFoundException, DataException {
        return FileSecurity.createFileOutputStream(file, false);
    }

    public static FileOutputStream createFileOutputStream(File file, boolean append) throws FileNotFoundException, DataException {
        try {
            return new FileOutputStream(file, append);
        }
        catch (Exception typedException) {
            if (typedException instanceof FileNotFoundException) {
                throw (FileNotFoundException)typedException;
            }
            throw new DataException(typedException.getMessage());
        }
    }

    public static FileInputStream createFileInputStream(File file) throws FileNotFoundException, DataException {
        try {
            return new FileInputStream(file);
        }
        catch (Exception typedException) {
            if (typedException instanceof FileNotFoundException) {
                throw (FileNotFoundException)typedException;
            }
            throw new DataException(typedException.getMessage());
        }
    }

    public static boolean fileExist(File file) {
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public static boolean fileIsFile(File file) {
        if (file == null) {
            return false;
        }
        return file.isFile();
    }

    public static File[] fileListFiles(File file) {
        if (file == null) {
            return new File[0];
        }
        return file.listFiles();
    }

    public static boolean fileIsDirectory(File file) {
        if (file == null) {
            return false;
        }
        return file.isDirectory();
    }

    public static String fileGetAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public static String fileGetCanonicalPath(File file) throws IOException, DataException {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (Exception typedException) {
            if (typedException instanceof IOException) {
                throw (IOException)typedException;
            }
            throw new DataException(typedException.getMessage());
        }
    }

    public static boolean fileDelete(File file) {
        if (file == null) {
            return true;
        }
        return file.delete();
    }

    public static void fileDeleteOnExit(File file) {
        if (file == null) {
            return;
        }
        file.deleteOnExit();
    }

    public static boolean fileMakeDirs(File file) {
        if (file == null) {
            return false;
        }
        return file.mkdirs();
    }

    public static File fileGetCanonicalFile(File file) throws IOException, DataException {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (Exception typedException) {
            if (typedException instanceof IOException) {
                throw (IOException)typedException;
            }
            throw new DataException(typedException.getMessage());
        }
    }
}

