/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtilsCore;

public class ParentChecker {
    private IResource[] fResources;
    private IJavaElement[] fJavaElements;
    private IJarEntryResource[] fJarResources;

    public ParentChecker(IResource[] resources, IJavaElement[] javaElements) {
        this(resources, javaElements, new IJarEntryResource[0]);
    }

    public ParentChecker(IResource[] resources, IJavaElement[] javaElements, IJarEntryResource[] jarResources) {
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)javaElements);
        Assert.isNotNull((Object)jarResources);
        this.fResources = resources;
        this.fJavaElements = javaElements;
        this.fJarResources = jarResources;
    }

    public boolean haveCommonParent() {
        return this.getCommonParent() != null;
    }

    public Object getCommonParent() {
        IJavaElement commonParent;
        if (this.fJavaElements.length == 0 && this.fResources.length == 0 && this.fJarResources.length == 0) {
            return null;
        }
        if (!(this.resourcesHaveCommonParent() && this.javaElementsHaveCommonParent() && this.jarResourcesHaveCommonParent())) {
            return null;
        }
        if (this.fJavaElements.length == 0 && this.fResources.length == 0) {
            return this.getCommonJarResourceParent();
        }
        if (this.fJavaElements.length == 0 && this.fJarResources.length == 0) {
            IResource commonResourceParent = this.getCommonResourceParent();
            Assert.isNotNull((Object)commonResourceParent);
            IJavaElement convertedToJava = JavaCore.create((IResource)commonResourceParent);
            if (convertedToJava != null && convertedToJava.exists()) {
                return convertedToJava;
            }
            return commonResourceParent;
        }
        if (this.fResources.length == 0 && this.fJarResources.length == 0) {
            return this.getCommonJavaElementParent();
        }
        IJavaElement convertedToJava = null;
        IJavaElement commonJavaElementParent = null;
        Object commonJarResourcesParent = null;
        if (this.fResources.length != 0) {
            IResource commonResourceParent = this.getCommonResourceParent();
            Assert.isNotNull((Object)commonResourceParent);
            convertedToJava = JavaCore.create((IResource)commonResourceParent);
            if (convertedToJava == null || !convertedToJava.exists()) {
                return null;
            }
        }
        if (this.fJavaElements.length != 0) {
            commonJavaElementParent = this.getCommonJavaElementParent();
            Assert.isNotNull((Object)commonJavaElementParent);
            if (convertedToJava != null && !commonJavaElementParent.equals(convertedToJava)) {
                return null;
            }
        }
        IJavaElement iJavaElement = commonParent = convertedToJava == null ? commonJavaElementParent : convertedToJava;
        if (this.fJarResources.length != 0) {
            commonJarResourcesParent = this.getCommonJarResourceParent();
            Assert.isNotNull((Object)commonJarResourcesParent);
            if (!commonJarResourcesParent.equals(commonParent)) {
                return null;
            }
        }
        return commonParent;
    }

    private Object getCommonJarResourceParent() {
        Assert.isNotNull((Object)this.fJarResources);
        Assert.isTrue((this.fJarResources.length > 0 ? 1 : 0) != 0);
        return this.fJarResources[0].getParent();
    }

    private IJavaElement getCommonJavaElementParent() {
        Assert.isNotNull((Object)this.fJavaElements);
        Assert.isTrue((this.fJavaElements.length > 0 ? 1 : 0) != 0);
        return this.fJavaElements[0].getParent();
    }

    private IResource getCommonResourceParent() {
        Assert.isNotNull((Object)this.fResources);
        Assert.isTrue((this.fResources.length > 0 ? 1 : 0) != 0);
        return this.fResources[0].getParent();
    }

    private boolean javaElementsHaveCommonParent() {
        if (this.fJavaElements.length == 0) {
            return true;
        }
        IJavaElement firstParent = this.fJavaElements[0].getParent();
        Assert.isNotNull((Object)firstParent);
        int i = 1;
        while (i < this.fJavaElements.length) {
            if (!firstParent.equals(this.fJavaElements[i].getParent())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean resourcesHaveCommonParent() {
        if (this.fResources.length == 0) {
            return true;
        }
        IContainer firstParent = this.fResources[0].getParent();
        Assert.isNotNull((Object)firstParent);
        int i = 1;
        while (i < this.fResources.length) {
            if (!firstParent.equals((Object)this.fResources[i].getParent())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean jarResourcesHaveCommonParent() {
        if (this.fJarResources.length == 0) {
            return true;
        }
        Object firstParent = this.fJarResources[0].getParent();
        Assert.isNotNull((Object)firstParent);
        int i = 1;
        while (i < this.fJarResources.length) {
            if (!firstParent.equals(this.fJarResources[i].getParent())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IResource[] getResources() {
        return this.fResources;
    }

    public IJavaElement[] getJavaElements() {
        return this.fJavaElements;
    }

    public void removeElementsWithAncestorsOnList(boolean removeOnlyJavaElements) {
        if (!removeOnlyJavaElements) {
            this.removeResourcesDescendantsOfResources();
            this.removeResourcesDescendantsOfJavaElements();
        }
        this.removeJavaElementsDescendantsOfJavaElements();
    }

    private void removeResourcesDescendantsOfJavaElements() {
        Set<IResource> resourcesWithoutDescendants = ParentChecker.filterDescendants(this.fResources, this.fJavaElements);
        this.fResources = resourcesWithoutDescendants.toArray(new IResource[resourcesWithoutDescendants.size()]);
    }

    private static Set<IResource> filterDescendants(IResource[] resourcesToFilter, IJavaElement[] javaElements) {
        ArrayList<IResource> descendants = new ArrayList<IResource>();
        HashSet<IJavaElement> elements = new HashSet<IJavaElement>(Arrays.asList(javaElements));
        IResource[] iResourceArray = resourcesToFilter;
        int n = resourcesToFilter.length;
        int n2 = 0;
        while (n2 < n) {
            IResource currentResource = iResourceArray[n2];
            if (ParentChecker.hasAncestor(currentResource, elements)) {
                descendants.add(currentResource);
            }
            ++n2;
        }
        LinkedHashSet<IResource> filteredResources = new LinkedHashSet<IResource>(Arrays.asList(resourcesToFilter));
        filteredResources.removeAll(descendants);
        return filteredResources;
    }

    private void removeJavaElementsDescendantsOfJavaElements() {
        Set<IJavaElement> javaElementsWithoutDescendants = ParentChecker.filterDescendants(this.fJavaElements);
        this.fJavaElements = javaElementsWithoutDescendants.toArray(new IJavaElement[javaElementsWithoutDescendants.size()]);
    }

    private static Set<IJavaElement> filterDescendants(IJavaElement[] elementsToFilter) {
        ArrayList<IJavaElement> descendants = new ArrayList<IJavaElement>();
        LinkedHashSet<IJavaElement> elements = new LinkedHashSet<IJavaElement>(Arrays.asList(elementsToFilter));
        IJavaElement[] iJavaElementArray = elementsToFilter;
        int n = elementsToFilter.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement currentElement = iJavaElementArray[n2];
            if (ParentChecker.hasAncestor(currentElement, elements)) {
                descendants.add(currentElement);
            }
            ++n2;
        }
        elements.removeAll(descendants);
        return elements;
    }

    private void removeResourcesDescendantsOfResources() {
        ArrayList<IResource> subResources = new ArrayList<IResource>(3);
        IResource[] iResourceArray = this.fResources;
        int n = this.fResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource subResource = iResourceArray[n2];
            IResource[] iResourceArray2 = this.fResources;
            int n3 = this.fResources.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource superResource = iResourceArray2[n4];
                if (ParentChecker.isDescendantOf(subResource, superResource)) {
                    subResources.add(subResource);
                }
                ++n4;
            }
            ++n2;
        }
        this.removeFromSetToDelete(subResources.toArray(new IResource[subResources.size()]));
    }

    private static boolean hasAncestor(IResource resource, Set<IJavaElement> elements) {
        IContainer parent = resource.getParent();
        while (parent != null) {
            IJavaElement parentElement = JavaCore.create((IResource)parent);
            if (parentElement != null && parentElement.exists() && elements.contains(parentElement)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private static boolean hasAncestor(IJavaElement element, Set<IJavaElement> elements) {
        IJavaElement parent = element.getParent();
        while (parent != null) {
            if (elements.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isDescendantOf(IResource subResource, IResource superResource) {
        return !subResource.equals((Object)superResource) && superResource.getFullPath().isPrefixOf(subResource.getFullPath());
    }

    private void removeFromSetToDelete(IResource[] resourcesToNotDelete) {
        this.fResources = ReorgUtilsCore.setMinus(this.fResources, resourcesToNotDelete);
    }

    public static boolean isDescendantOf(IResource subResource, IJavaElement superElement) {
        return ParentChecker.hasAncestor(subResource, Collections.singleton(superElement));
    }

    public static boolean isDescendantOf(IJavaElement subElement, IJavaElement superElement) {
        return ParentChecker.hasAncestor(subElement, Collections.singleton(superElement));
    }
}

