/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sap.maxdb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableConstraintLoader;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;

public class MaxDBTableConstraintLoader
extends JDBCTableConstraintLoader {
    public MaxDBTableConstraintLoader() {
        super(null);
    }

    public MaxDBTableConstraintLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public MaxDBTableConstraintLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        assert (catalogObject instanceof Table);
    }

    public PrimaryKey loadPrimaryKey(PrimaryKey existingPK) throws SQLException {
        PrimaryKey primaryKey;
        block10: {
            ResultSet rs = null;
            try {
                TreeMap<Integer, Column> columns = new TreeMap<Integer, Column>();
                PrimaryKey pk = null;
                rs = this.createPrimaryKeyResultSet();
                while (rs.next()) {
                    if (pk == null) {
                        String pkName = rs.getString("PK_NAME");
                        if (pkName == null) {
                            pkName = String.valueOf(rs.getString("TABLE_NAME")) + "_PK";
                        }
                        if (existingPK != null && pkName.equals(existingPK.getName())) {
                            pk = existingPK;
                            pk.getMembers().clear();
                            if (existingPK instanceof ICatalogObject) {
                                ((ICatalogObject)pk).refresh();
                            }
                        } else {
                            pk = this.createPrimaryKey();
                            pk.setName(pkName);
                        }
                    }
                    columns.put(Integer.valueOf(rs.getShort("KEY_SEQ")), this.findColumn(rs.getString("COLUMN_NAME")));
                }
                Iterator it = columns.values().iterator();
                while (it.hasNext()) {
                    pk.getMembers().add(it.next());
                }
                primaryKey = pk;
                if (rs == null) break block10;
            }
            catch (Throwable throwable) {
                if (rs != null) {
                    this.closeResultSet(rs);
                }
                throw throwable;
            }
            this.closeResultSet(rs);
        }
        return primaryKey;
    }

    public void loadUniqueConstraints(PrimaryKey pk, List containmentList, Collection existingUCs) throws SQLException {
        ResultSet rs = null;
        if (pk != null) {
            existingUCs.remove(pk);
        }
        try {
            HashMap<String, UniqueConstraint> constraints = new HashMap<String, UniqueConstraint>();
            HashMap constraintColumns = new HashMap();
            rs = this.createUniqueConstraintResultSet();
            while (rs.next()) {
                String ucName = rs.getString("PK_NAME");
                if (ucName == null) {
                    ucName = String.valueOf(rs.getString("PKTABLE_NAME")) + "_PK";
                }
                if (ucName.equals(pk == null ? null : pk.getName())) continue;
                if (!constraints.containsKey(ucName)) {
                    UniqueConstraint uc = (UniqueConstraint)this.getAndRemoveSQLObject(existingUCs, ucName);
                    if (uc == null) {
                        uc = this.createUniqueConstraint();
                        uc.setName(ucName);
                    } else {
                        uc.getMembers().clear();
                        if (uc instanceof ICatalogObject) {
                            ((ICatalogObject)uc).refresh();
                        }
                    }
                    containmentList.add(uc);
                    constraints.put(ucName, uc);
                    constraintColumns.put(ucName, new TreeMap());
                }
                ((Map)constraintColumns.get(ucName)).put(Integer.valueOf(rs.getShort("KEY_SEQ")), this.findColumn(rs.getString("PKCOLUMN_NAME")));
            }
            for (Map.Entry entry : constraints.entrySet()) {
                UniqueConstraint uc = (UniqueConstraint)entry.getValue();
                Iterator colIt = ((Map)constraintColumns.get(uc.getName())).values().iterator();
                while (colIt.hasNext()) {
                    uc.getMembers().add(colIt.next());
                }
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                this.closeResultSet(rs);
            }
            throw throwable;
        }
        if (rs != null) {
            this.closeResultSet(rs);
        }
    }
}

