/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.win32;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractMergeViewer
extends Viewer {
    private Object input;
    private File leftFile;
    private File rightFile;
    private File resultFile;
    private final CompareConfiguration configuration;

    public AbstractMergeViewer(CompareConfiguration configuration) {
        this.configuration = configuration;
    }

    public Object getInput() {
        return this.input;
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    public void refresh() {
    }

    public void setInput(Object input) {
        this.input = input;
        this.reset();
    }

    protected void reset() {
        if (this.leftFile != null && this.leftFile.exists()) {
            this.leftFile.delete();
        }
        if (this.rightFile != null && this.rightFile.exists()) {
            this.rightFile.delete();
        }
        if (this.resultFile != null && this.resultFile.exists()) {
            this.resultFile.delete();
        }
        this.leftFile = null;
        this.rightFile = null;
        this.resultFile = null;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    protected boolean isOneSided() {
        if (this.input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)this.input;
            int type = ci.getKind() & 3;
            return type != 3;
        }
        return false;
    }

    protected File getFileForSingleSide() throws CoreException {
        File file = this.getFileForLeft();
        if (file != null && file.exists()) {
            return file;
        }
        return this.getFileForRight();
    }

    protected File getFileForRight() throws CoreException {
        if (this.rightFile != null) {
            return this.rightFile;
        }
        ICompareInput ci = this.getCompareInput();
        if (ci != null) {
            ITypedElement right = ci.getRight();
            File file = this.getLocalFile(right);
            if (file != null) {
                return file;
            }
            this.rightFile = this.cacheContents(right);
            return this.rightFile;
        }
        return null;
    }

    protected File getFileForLeft() throws CoreException {
        if (this.leftFile != null) {
            return this.leftFile;
        }
        ICompareInput ci = this.getCompareInput();
        if (ci != null) {
            ITypedElement left = ci.getLeft();
            File file = this.getLocalFile(left);
            if (file != null) {
                return file;
            }
            this.leftFile = this.cacheContents(left);
            return this.leftFile;
        }
        return null;
    }

    protected File getResultFile() throws IOException {
        if (this.resultFile != null) {
            return this.resultFile;
        }
        this.resultFile = File.createTempFile("merge", ".doc");
        this.resultFile.deleteOnExit();
        this.resultFile.delete();
        return this.resultFile;
    }

    protected boolean hasResultFile() {
        return this.resultFile != null;
    }

    private File cacheContents(ITypedElement element) throws CoreException {
        IStreamContentAccessor sca;
        InputStream contents;
        if (element instanceof IStreamContentAccessor && (contents = (sca = (IStreamContentAccessor)element).getContents()) != null) {
            try {
                File file = this.createTempFile(contents);
                return file;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.compare.win32", 0, e.getMessage(), (Throwable)e));
            }
            finally {
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private File createTempFile(InputStream contents) throws IOException {
        File file = File.createTempFile("compare", ".doc");
        file.deleteOnExit();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = contents.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            return file;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected ICompareInput getCompareInput() {
        if (this.input instanceof ICompareInput) {
            return (ICompareInput)this.input;
        }
        return null;
    }

    protected File getLocalFile(ITypedElement left) throws CoreException {
        URI uri;
        IFileStore store;
        IFile file = this.getEclipseFile(left);
        if (file != null && (store = EFS.getStore((URI)(uri = file.getLocationURI()))) != null) {
            return store.toLocalFile(0, null);
        }
        return null;
    }

    protected IFile getEclipseFile(Object element) {
        IResourceProvider rp;
        IResource resource;
        if (element instanceof IResourceProvider && (resource = (rp = (IResourceProvider)element).getResource()).getType() == 1) {
            return (IFile)resource;
        }
        if (element instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)element;
            Object result = a.getAdapter(IResource.class);
            if (result == null) {
                result = a.getAdapter(IFile.class);
            }
            if (result instanceof IFile) {
                return (IFile)result;
            }
        }
        return null;
    }

    protected IEditableContent getSaveTarget() {
        IEditableContent left = this.getEditableLeft();
        IEditableContent right = this.getEditableRight();
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        return null;
    }

    private IEditableContent getEditableLeft() {
        ITypedElement left;
        ICompareInput compareInput = this.getCompareInput();
        if (compareInput != null && (left = compareInput.getLeft()) instanceof IEditableContent && this.configuration.isLeftEditable()) {
            return (IEditableContent)left;
        }
        return null;
    }

    private IEditableContent getEditableRight() {
        ITypedElement right;
        ICompareInput compareInput = this.getCompareInput();
        if (compareInput != null && (right = compareInput.getRight()) instanceof IEditableContent && this.configuration.isRightEditable()) {
            return (IEditableContent)right;
        }
        return null;
    }

    protected byte[] asBytes(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            int length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            out.close();
            return out.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public CompareConfiguration getConfiguration() {
        return this.configuration;
    }
}

