/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class DataExtractionTaskTest
extends EngineCase {
    private String report_design;
    private String report_document;
    private IReportDocument reportDoc;
    static final String INPUT_table = "DataExtraction_table.rptdesign";
    static final String INPUT_subquery = "DataExtraction_subquery.rptdesign";
    static final String INPUT_nestquery = "DataExtraction_nestquery.rptdesign";
    static final String OUTPUT_table = "DataExtraction_table.rptdocument";
    static final String OUTPUT_subquery = "DataExtraction_subquery.rptdocument";
    static final String OUTPUT_nestquery = "DataExtraction_nestquery.rptdocument";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(INPUT_table, INPUT_table);
        this.copyResource_INPUT(INPUT_subquery, INPUT_subquery);
        this.copyResource_INPUT(INPUT_nestquery, INPUT_nestquery);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource();
    }

    public void testMethods() throws Exception {
        this.report_design = INPUT_table;
        this.report_document = OUTPUT_table;
        this.report_document = this.createReportDocument(this.report_design, this.report_document);
        this.reportDoc = this.engine.openReportDocument(this.report_document.replace('\\', '/'));
        IDataExtractionTask extractTask = this.engine.createDataExtractionTask(this.reportDoc);
        this.checkGetResultSetList(extractTask);
        this.checkSelectColumns(extractTask);
    }

    private void checkGetResultSetList(IDataExtractionTask task) {
        try {
            ArrayList results = (ArrayList)task.getResultSetList();
            DataExtractionTaskTest.assertEquals((int)1, (int)results.size());
        }
        catch (EngineException e) {
            e.printStackTrace();
            DataExtractionTaskTest.fail();
        }
    }

    private void checkSelectColumns(IDataExtractionTask task) {
        String[] columns = new String[]{"code", "territory"};
        task.selectResultSet("t1");
        task.selectColumns(columns);
        try {
            IExtractionResults result = task.extract();
            DataExtractionTaskTest.assertNotNull((Object)result);
            DataExtractionTaskTest.assertEquals((int)2, (int)result.getResultMetaData().getColumnCount());
            DataExtractionTaskTest.assertEquals((String)"code", (String)result.getResultMetaData().getColumnName(0));
            DataExtractionTaskTest.assertEquals((String)"territory", (String)result.getResultMetaData().getColumnName(1));
        }
        catch (Exception e) {
            e.printStackTrace();
            DataExtractionTaskTest.fail();
        }
    }

    public void testDataExtractionWithFilter() throws Exception {
        this.report_design = INPUT_table;
        this.report_document = OUTPUT_table;
        try {
            this.report_document = this.createReportDocument(this.report_design, this.report_document);
            this.reportDoc = this.engine.openReportDocument(this.report_document);
            IDataExtractionTask extractTask = this.engine.createDataExtractionTask(this.reportDoc);
            extractTask.selectResultSet("t1");
            IFilterDefinition[] filterExpression = new IFilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"territory\"]", 1, "\"EMEA\"", null))};
            extractTask.setFilters(filterExpression);
            IExtractionResults result = extractTask.extract();
            if (result != null) {
                int officecode = 0;
                IDataIterator data = result.nextResultIterator();
                if (data != null) {
                    data.next();
                    officecode = Integer.parseInt(data.getValue("code").toString());
                    DataExtractionTaskTest.assertEquals((String)"Fail to extract filtered data1", (int)4, (int)officecode);
                    if (data.next()) {
                        officecode = Integer.parseInt(data.getValue("code").toString());
                        DataExtractionTaskTest.assertEquals((String)"Fail to extract filtered data2", (int)7, (int)officecode);
                    }
                }
                data.close();
            } else {
                DataExtractionTaskTest.fail((String)"Fail to extract filtered data3");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DataExtractionTaskTest.fail((String)"Fail to extract filtered data4");
        }
    }

    public void testDataExtractionFromIID_subquery() throws Exception {
        this.report_design = INPUT_subquery;
        this.report_document = OUTPUT_subquery;
        try {
            IDataIterator data;
            this.report_document = this.createReportDocument(this.report_design, this.report_document);
            this.reportDoc = this.engine.openReportDocument(this.report_document);
            IDataExtractionTask extractTask = this.engine.createDataExtractionTask(this.reportDoc);
            ArrayList iids = this.findIID(this.report_document, "LIST");
            DataExtractionTaskTest.assertEquals((int)1, (int)iids.size());
            extractTask.setInstanceID((InstanceID)iids.get(0));
            IExtractionResults result = extractTask.extract();
            if (result != null) {
                String name = null;
                IDataIterator data2 = result.nextResultIterator();
                if (data2 != null) {
                    data2.next();
                    name = data2.getValue("name").toString();
                    DataExtractionTaskTest.assertTrue((boolean)name.equalsIgnoreCase("Atelier graphique"));
                    if (data2.next()) {
                        name = data2.getValue("name").toString();
                        DataExtractionTaskTest.assertTrue((boolean)name.equalsIgnoreCase("Signal Gift Stores"));
                    }
                }
                data2.close();
            } else {
                DataExtractionTaskTest.fail();
            }
            IFilterDefinition[] filterExpression = new IFilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"name\"]", 1, "\"Signal Gift Stores\"", null))};
            extractTask.setFilters(filterExpression);
            result = extractTask.extract();
            if (result != null) {
                String name = null;
                data = result.nextResultIterator();
                if (data != null) {
                    data.next();
                    name = data.getValue("name").toString();
                    DataExtractionTaskTest.assertTrue((boolean)name.equalsIgnoreCase("Signal Gift Stores"));
                }
                data.close();
            } else {
                DataExtractionTaskTest.fail();
            }
            iids = this.findIID(this.report_document, "TABLE");
            DataExtractionTaskTest.assertEquals((int)2, (int)iids.size());
            extractTask.setInstanceID((InstanceID)iids.get(0));
            result = extractTask.extract();
            if (result != null) {
                int num = 0;
                data = result.nextResultIterator();
                if (data != null) {
                    data.next();
                    num = Integer.parseInt(data.getValue("number").toString());
                    DataExtractionTaskTest.assertEquals((int)103, (int)num);
                    if (data.next()) {
                        num = Integer.parseInt(data.getValue("number").toString());
                        DataExtractionTaskTest.assertEquals((int)112, (int)num);
                    }
                }
                data.close();
            } else {
                DataExtractionTaskTest.fail();
            }
            extractTask.setInstanceID((InstanceID)iids.get(1));
            filterExpression = new IFilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"number\"]", 1, "112", null))};
            extractTask.setFilters(filterExpression);
            result = extractTask.extract();
            if (result != null) {
                IDataIterator data3 = result.nextResultIterator();
                IResultMetaData resultMetaData = result.getResultMetaData();
                int columnCount = resultMetaData.getColumnCount();
                if (data3 != null) {
                    data3.next();
                    DataExtractionTaskTest.assertEquals((String)"112", (String)data3.getValue("number").toString());
                }
                data3.close();
            } else {
                DataExtractionTaskTest.fail();
            }
            extractTask.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            DataExtractionTaskTest.fail((String)"Fail to extract data from subquery");
        }
    }

    public void testDataExtractionFromIID_nestquery() throws Exception {
        this.report_design = INPUT_nestquery;
        this.report_document = OUTPUT_nestquery;
        try {
            IDataIterator data;
            this.report_document = this.createReportDocument(this.report_design, this.report_document);
            this.reportDoc = this.engine.openReportDocument(this.report_document);
            IDataExtractionTask extractTask = this.engine.createDataExtractionTask(this.reportDoc);
            ArrayList iids = this.findIID(this.report_document, "LIST");
            DataExtractionTaskTest.assertEquals((int)1, (int)iids.size());
            extractTask.setInstanceID((InstanceID)iids.get(0));
            IExtractionResults result = extractTask.extract();
            if (result != null) {
                String name = null;
                IDataIterator data2 = result.nextResultIterator();
                if (data2 != null) {
                    data2.next();
                    name = data2.getValue("name").toString();
                    DataExtractionTaskTest.assertTrue((boolean)name.equalsIgnoreCase("Atelier graphique"));
                    if (data2.next()) {
                        name = data2.getValue("name").toString();
                        DataExtractionTaskTest.assertTrue((boolean)name.equalsIgnoreCase("Signal Gift Stores"));
                    }
                }
                data2.close();
            } else {
                DataExtractionTaskTest.fail((String)"Fail to extract data from subquery");
            }
            IFilterDefinition[] filterExpression = new IFilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"name\"]", 1, "\"Signal Gift Stores\"", null))};
            extractTask.setFilters(filterExpression);
            result = extractTask.extract();
            if (result != null) {
                String name = null;
                data = result.nextResultIterator();
                if (data != null) {
                    data.next();
                    name = data.getValue("name").toString();
                    DataExtractionTaskTest.assertTrue((boolean)name.equalsIgnoreCase("Signal Gift Stores"));
                }
                data.close();
            } else {
                DataExtractionTaskTest.fail();
            }
            iids = this.findIID(this.report_document, "TABLE");
            DataExtractionTaskTest.assertEquals((int)2, (int)iids.size());
            extractTask.setInstanceID((InstanceID)iids.get(0));
            result = extractTask.extract();
            if (result != null) {
                int num = 0;
                data = result.nextResultIterator();
                if (data != null) {
                    data.next();
                    num = Integer.parseInt(data.getValue("number").toString());
                    DataExtractionTaskTest.assertEquals((int)103, (int)num);
                    if (data.next()) {
                        num = Integer.parseInt(data.getValue("number").toString());
                        DataExtractionTaskTest.assertEquals((int)112, (int)num);
                    }
                }
                data.close();
            } else {
                DataExtractionTaskTest.fail((String)"Fail to extract data from subquery");
            }
            filterExpression = new IFilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"number\"]", 1, "112", null))};
            extractTask.setFilters(filterExpression);
            result = extractTask.extract();
            if (result != null) {
                int num = 0;
                data = result.nextResultIterator();
                if (data != null) {
                    data.next();
                    num = Integer.parseInt(data.getValue("number").toString());
                    DataExtractionTaskTest.assertEquals((int)112, (int)num);
                }
                data.close();
            } else {
                DataExtractionTaskTest.fail();
            }
            extractTask.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            DataExtractionTaskTest.fail((String)"Fail to extract data from nestquery");
        }
    }

    protected String createReportDocument(String reportdesign, String reportdocument) throws Exception {
        reportdesign = this.genInputFile(reportdesign);
        reportdocument = this.genOutputFile(reportdocument);
        FileArchiveWriter archive = new FileArchiveWriter(reportdocument);
        IReportRunnable report = this.engine.openReportDesign(reportdesign);
        IRunTask runTask = this.engine.createRunTask(report);
        runTask.setAppContext(new HashMap());
        runTask.run((IDocArchiveWriter)archive);
        runTask.close();
        return reportdocument;
    }

    private ArrayList findIID(String doc, String type) throws EngineException, UnsupportedEncodingException {
        ArrayList<InstanceID> iids = new ArrayList<InstanceID>();
        IReportDocument reportDoc = this.engine.openReportDocument(doc);
        IRenderTask task = this.engine.createRenderTask(reportDoc);
        HTMLRenderOption htmlRenderOptions = new HTMLRenderOption();
        HashMap appContext = new HashMap();
        task.setAppContext(appContext);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        htmlRenderOptions.setOutputStream((OutputStream)ostream);
        htmlRenderOptions.setOutputFormat("html");
        htmlRenderOptions.setEnableMetadata(true);
        task.setRenderOption((IRenderOption)htmlRenderOptions);
        task.render();
        task.close();
        String content = ostream.toString("utf-8");
        Pattern typePattern = DataExtractionTaskTest.buildPattern(type);
        Matcher matcher = typePattern.matcher(content);
        while (matcher.find()) {
            String tmp_type = null;
            String strIid = null;
            tmp_type = matcher.group(0);
            strIid = tmp_type.substring(tmp_type.indexOf("iid"));
            strIid = strIid.substring(5, strIid.indexOf("\"", 6));
            iids.add(InstanceID.parse((String)strIid));
        }
        return iids;
    }

    public static Pattern buildPattern(String type) {
        Pattern typePattern = Pattern.compile("(iid=\".*\".*element_type=\"" + type + "\")");
        return typePattern;
    }
}

