/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.widget;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider.CrosstabBindingComboPropertyDescriptorProvider;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CrosstabBindingComboPropertyDescriptor
extends PropertyDescriptor {
    protected CCombo combo;
    protected CubeHandle oldValue;
    private int style = 2048;
    private FocusAdapter focusListener;

    public CrosstabBindingComboPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    public Control getControl() {
        return this.combo;
    }

    public Control createControl(Composite parent) {
        if (this.isFormStyle()) {
            this.combo = FormWidgetFactory.getInstance().createCCombo(parent, true);
        } else {
            this.combo = new CCombo(parent, this.style | 8);
            this.combo.setVisibleItemCount(30);
        }
        this.addListeners();
        return this.combo;
    }

    protected void addListeners() {
        this.combo.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                CrosstabBindingComboPropertyDescriptor.this.combo.clearSelection();
            }

            public void controlResized(ControlEvent e) {
                CrosstabBindingComboPropertyDescriptor.this.combo.clearSelection();
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CrosstabBindingComboPropertyDescriptor.this.handleComboSelectEvent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CrosstabBindingComboPropertyDescriptor.this.handleComboSelectEvent();
            }
        });
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (CrosstabBindingComboPropertyDescriptor.this.combo.isEnabled()) {
                    CrosstabBindingComboPropertyDescriptor.this.handleComboSelectEvent();
                }
            }
        };
    }

    protected void handleComboSelectEvent() {
        CubeHandle newValue = ((CrosstabBindingComboPropertyDescriptorProvider)this.getDescriptorProvider()).getItems().get(this.combo.getSelectionIndex());
        try {
            this.save(newValue);
        }
        catch (SemanticException e) {
            int index = ((CrosstabBindingComboPropertyDescriptorProvider)this.getDescriptorProvider()).getItems().indexOf(this.oldValue);
            if (index > -1) {
                this.combo.select(index);
            } else {
                this.combo.deselectAll();
            }
            WidgetUtil.processError((Shell)this.combo.getShell(), (Exception)((Object)e));
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void load() {
        this.oldValue = (CubeHandle)this.getDescriptorProvider().load();
        this.refresh(this.oldValue);
    }

    public void addStyle(int style) {
        this.style |= style;
    }

    protected void setComboEditable(boolean isEditable) {
        this.combo.setEditable(isEditable);
        if (this.focusListener != null) {
            this.combo.removeFocusListener((FocusListener)this.focusListener);
            if (this.combo.getEditable()) {
                this.combo.addFocusListener((FocusListener)this.focusListener);
            }
        }
    }

    public void save(Object value) throws SemanticException {
        this.getDescriptorProvider().save(value);
    }

    public String getStringValue() {
        return this.combo.getText();
    }

    public void setStringValue(String value) {
        this.combo.setText(value);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.combo, (boolean)isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.combo.setVisible(isVisible);
    }

    protected void refresh(CubeHandle value) {
        int index;
        Object[] items = ((CrosstabBindingComboPropertyDescriptorProvider)this.getDescriptorProvider()).getItemNames();
        if (!Arrays.equals(this.combo.getItems(), items)) {
            this.combo.setItems((String[])items);
        }
        if ((index = ((CrosstabBindingComboPropertyDescriptorProvider)this.getDescriptorProvider()).getItems().indexOf(this.oldValue)) > -1) {
            this.combo.select(index);
        } else {
            this.combo.deselectAll();
        }
    }
}

