/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import java.text.MessageFormat;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.command.WrapperCommandStack;
import org.eclipse.birt.report.designer.internal.ui.editors.IReportEditor;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.AbstractMultiPageEditor;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.ActivityStackListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class StackWindowAction
implements IWorkbenchWindowActionDelegate {
    private ActivityStackListener commandStackListener = new ActivityStackListener(){

        public void stackChanged(ActivityStackEvent event) {
            StackWindowAction.this.setAction(StackWindowAction.this.iaction, StackWindowAction.this.canDo());
        }
    };
    private CommandStack commandStack;
    private ModuleHandle designHandle;
    private IAction iaction;

    protected String getLabelForCommand(Command command) {
        if (command == null || command.getLabel() == null) {
            return "";
        }
        return command.getLabel();
    }

    public ActivityStackListener getCommandStackListener() {
        return this.commandStackListener;
    }

    public void dispose() {
        WrapperCommandStack stack = (WrapperCommandStack)this.getCommandStack();
        if (stack != null) {
            stack.removeCommandStackListener(this.getCommandStackListener());
        }
    }

    public void init(IWorkbenchWindow window) {
        WrapperCommandStack stack = (WrapperCommandStack)this.getCommandStack();
        if (stack != null) {
            this.designHandle = this.getDesignHandle();
            stack.setActivityStack(this.getDesignHandle().getCommandStack());
            stack.addCommandStackListener(this.getCommandStackListener());
        }
    }

    private void resetCommandListener() {
        WrapperCommandStack stack = (WrapperCommandStack)this.getCommandStack();
        if (stack != null && this.getDesignHandle() != this.designHandle) {
            this.designHandle = this.getDesignHandle();
            stack.removeCommandStackListener(this.getCommandStackListener());
            stack.setActivityStack(this.getDesignHandle().getCommandStack());
            stack.addCommandStackListener(this.getCommandStackListener());
        }
    }

    protected CommandStack getCommandStack() {
        if (this.commandStack == null) {
            this.commandStack = new WrapperCommandStack();
        }
        return this.commandStack;
    }

    public void run(IAction action) {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Stack window action >> Run ...");
        }
        if (this.canDo()) {
            this.doStack();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.iaction = action;
        this.changeEnabled(action);
        this.resetCommandListener();
    }

    private void changeEnabled(IAction action) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] pages = window.getPages();
        boolean isEnabled = false;
        int i = 0;
        while (i < pages.length) {
            IEditorReference[] refs = pages[i].getEditorReferences();
            int j = 0;
            while (j < refs.length) {
                IEditorPart activeEditor;
                IEditorPart editor = refs[j].getEditor(false);
                if (editor instanceof AbstractMultiPageEditor) {
                    isEnabled = this.canDo();
                    break;
                }
                if (editor instanceof IReportEditor && (activeEditor = ((IReportEditor)editor).getEditorPart()) instanceof AbstractMultiPageEditor) {
                    isEnabled = this.canDo();
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.setAction(action, isEnabled);
    }

    private void setAction(IAction action, boolean isEnabled) {
        action.setEnabled(isEnabled);
        this.changeLabel(action);
    }

    protected ModuleHandle getDesignHandle() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle();
    }

    protected abstract boolean canDo();

    protected abstract void doStack();

    protected abstract void changeLabel(IAction var1);

    public static class RedoWindowAction
    extends StackWindowAction {
        @Override
        protected boolean canDo() {
            return this.getDesignHandle().getCommandStack().canRedo();
        }

        @Override
        protected void doStack() {
            this.getDesignHandle().getCommandStack().redo();
        }

        @Override
        protected void changeLabel(IAction action) {
            Command redoCmd = this.getCommandStack().getRedoCommand();
            action.setToolTipText(MessageFormat.format(Messages.getString((String)"RedoAction_Tooltip"), this.getLabelForCommand(redoCmd)).trim());
        }
    }

    public static class UndoWindowAction
    extends StackWindowAction {
        @Override
        protected boolean canDo() {
            return this.getDesignHandle().getCommandStack().canUndo();
        }

        @Override
        protected void doStack() {
            this.getDesignHandle().getCommandStack().undo();
        }

        @Override
        protected void changeLabel(IAction action) {
            Command undoCmd = this.getCommandStack().getUndoCommand();
            action.setToolTipText(MessageFormat.format(Messages.getString((String)"UndoAction_Tooltip"), this.getLabelForCommand(undoCmd)).trim());
        }
    }
}

