/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.birt.report.designer.internal.ui.views.SearchInputDialog;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewerAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;

public class SearchAction
extends AbstractViewerAction {
    private static final String SEARCH_ACTION_TEXT = Messages.getString((String)"SearchAction.text");
    private static final String PROPERTY_NAME_ID = "id";
    private static SearchInputDialog inputDialog;
    private final LinkedList<TreeItem[]> selectedItemsStack = new LinkedList();

    public SearchAction(TreeViewer sourceViewer) {
        this(sourceViewer, SEARCH_ACTION_TEXT);
    }

    public SearchAction(TreeViewer sourceViewer, String text) {
        super(sourceViewer, text);
        sourceViewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (inputDialog != null) {
                    inputDialog.close();
                }
            }
        });
    }

    public boolean isEnabled() {
        for (Object selectedObject : this.getSelectedObjects()) {
            if (!this.internalIsEnabled(selectedObject)) continue;
            return true;
        }
        return false;
    }

    public void run() {
        this.doSearch();
    }

    private void doSearch() {
        if (inputDialog == null) {
            Shell shell = this.getSourceViewer().getTree().getShell();
            inputDialog = new SearchInputDialog(shell, null, "org.eclipse.birt.cshelp.SearchInputDialog_ID", new SearchInputDialog.SearchActionServices(){
                private final IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                private final IPartListener2 partListener = new IPartListener2(){
                    private final IEditorPart activeEditor;
                    private final IWorkbenchPart activePart;
                    {
                        this.activeEditor = page.getActiveEditor();
                        this.activePart = page.getActivePart();
                    }

                    public void partHidden(IWorkbenchPartReference partRef) {
                        IWorkbenchPart part = partRef.getPart(false);
                        if (part == this.activeEditor || part == this.activePart) {
                            inputDialog.close();
                        }
                    }
                };
                private final ISelectionChangedListener selectionChangedListener = e -> inputDialog.updateProperties();
                {
                    SearchAction.this.getSourceViewer().addPostSelectionChangedListener(this.selectionChangedListener);
                    this.page.addPartListener(this.partListener);
                }

                @Override
                public List<SearchResult> search(SearchInputDialog.Search search) {
                    return SearchAction.this.saveChanges(search);
                }

                @Override
                public void close() {
                    inputDialog = null;
                    SearchAction.this.getSourceViewer().removePostSelectionChangedListener(this.selectionChangedListener);
                    this.page.removePartListener(this.partListener);
                }

                @Override
                public List<String> getPropertyNames(boolean recursive) {
                    return SearchAction.this.getPropertyNames(recursive);
                }

                @Override
                public boolean back() {
                    return SearchAction.this.back();
                }

                @Override
                public void select(Object data) {
                    SearchAction.this.select(data);
                }
            });
            inputDialog.create();
            inputDialog.open();
        } else {
            inputDialog.getShell().setActive();
        }
    }

    protected boolean back() {
        LinkedList<TreeItem[]> selectedItemsStack = this.selectedItemsStack;
        if (!selectedItemsStack.isEmpty()) {
            TreeItem[] selectedItems = selectedItemsStack.pop();
            ArrayList<Object> list = new ArrayList<Object>();
            TreeItem[] treeItemArray = selectedItems;
            int n = selectedItems.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                list.add(item.getData());
                ++n2;
            }
            StructuredSelection selection = new StructuredSelection(list);
            this.getSourceViewer().setSelection((ISelection)selection, true);
        }
        return selectedItemsStack.isEmpty();
    }

    public List<String> getPropertyNames(boolean recursive) {
        TreeSet<String> propNameSet = new TreeSet<String>();
        TreeItem[] treeItemArray = this.getSelectedItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data instanceof SlotHandle) {
                SlotHandle slotHandle = (SlotHandle)data;
                int count = slotHandle.getCount();
                int i = 0;
                while (i < count) {
                    DesignElementHandle handle = slotHandle.get(i);
                    this.getPropertyNames(handle, recursive, propNameSet);
                    ++i;
                }
            } else if (data instanceof DesignElementHandle) {
                DesignElementHandle handle = (DesignElementHandle)data;
                this.getPropertyNames(handle, recursive, propNameSet);
            }
            ++n2;
        }
        return new ArrayList<String>(propNameSet);
    }

    private void getPropertyNames(DesignElementHandle handle, boolean recursive, Set<String> propNameSet) {
        DesignElement element = handle.getElement();
        List defns = element.getPropertyDefns();
        for (IElementPropertyDefn defn : defns) {
            String name = defn.getName();
            propNameSet.add(name);
        }
        if (recursive) {
            IElementPropertyDefn defn;
            defn = handle.getDefn();
            int slotCount = defn.getSlotCount();
            int i = 0;
            while (i < slotCount) {
                ISlotDefn slotDefn = defn.getSlot(i);
                SlotHandle slotHandle = handle.getSlot(slotDefn.getSlotID());
                int count = slotHandle.getCount();
                int j = 0;
                while (j < count) {
                    DesignElementHandle child = slotHandle.get(j);
                    this.getPropertyNames(child, recursive, propNameSet);
                    ++j;
                }
                ++i;
            }
        }
        propNameSet.add(PROPERTY_NAME_ID);
    }

    private boolean internalIsEnabled(Object obj) {
        if (obj instanceof DesignElementHandle) {
            return true;
        }
        return obj instanceof SlotHandle;
    }

    private List<SearchResult> saveChanges(SearchInputDialog.Search search) {
        TreeItem[] selectedItems;
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        TreeItem[] treeItemArray = selectedItems = this.getSelectedItems();
        int n = selectedItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data instanceof SlotHandle) {
                SlotHandle slotHandle = (SlotHandle)data;
                int i = 0;
                int count = slotHandle.getCount();
                while (i < count) {
                    DesignElementHandle handle = slotHandle.get(i);
                    ArrayList<SearchPathMember> path = new ArrayList<SearchPathMember>();
                    path.add(new SlotSearchPathMember(slotHandle));
                    this.search(handle, search, path, searchResults);
                    ++i;
                }
            } else if (data instanceof DesignElementHandle) {
                DesignElementHandle handle = (DesignElementHandle)data;
                ArrayList<SearchPathMember> path = new ArrayList<SearchPathMember>();
                this.search(handle, search, path, searchResults);
            }
            ++n2;
        }
        if (!searchResults.isEmpty()) {
            this.select(searchResults);
        }
        return searchResults;
    }

    private void select(List<SearchResult> searchResults) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (SearchResult result : searchResults) {
            SearchPathMember member = result.path.get(result.path.size() - 1);
            list.add(member.getObject());
        }
        this.selectedItemsStack.push(this.getSelectedItems());
        StructuredSelection selection = new StructuredSelection(list);
        this.getSourceViewer().setSelection((ISelection)selection, true);
    }

    private void select(Object object) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (object instanceof SearchResult) {
            SearchResult searchResult = (SearchResult)object;
            object = searchResult.getObject();
        }
        list.add(object);
        this.selectedItemsStack.push(this.getSelectedItems());
        StructuredSelection selection = new StructuredSelection(list);
        this.getSourceViewer().setSelection((ISelection)selection, true);
    }

    private boolean isEntryRegistered(List<SearchResult> searchResults, SearchResult newResult) {
        for (SearchResult entry : searchResults) {
            if (!entry.getElementName().equals(newResult.getElementName()) || !entry.getElementId().equals(newResult.getElementId())) continue;
            return true;
        }
        return false;
    }

    private void search(DesignElementHandle designElementHandle, SearchInputDialog.Search search, List<SearchPathMember> path, List<SearchResult> searchResults) {
        SearchResult newResultEntry;
        path.add(new DesignElementSearchPathMember(designElementHandle));
        String propertyName = search.matches(designElementHandle);
        if (propertyName != null && !this.isEntryRegistered(searchResults, newResultEntry = new SearchResult(path, propertyName))) {
            searchResults.add(newResultEntry);
        }
        if (search.isRecursive()) {
            IElementDefn defn = designElementHandle.getDefn();
            int i = 0;
            int slotCount = defn.getSlotCount();
            while (i < slotCount) {
                ISlotDefn slotDefn = defn.getSlot(i);
                SlotHandle slotHandle = designElementHandle.getSlot(slotDefn.getSlotID());
                ArrayList<SearchPathMember> slotPath = new ArrayList<SearchPathMember>(path);
                slotPath.add(new SlotSearchPathMember(slotHandle));
                int j = 0;
                int count = slotHandle.getCount();
                while (j < count) {
                    DesignElementHandle child = slotHandle.get(j);
                    ArrayList<SearchPathMember> childPath = new ArrayList<SearchPathMember>(slotPath);
                    this.search(child, search, childPath, searchResults);
                    ++j;
                }
                ++i;
            }
        }
    }

    private static class DesignElementSearchPathMember
    implements SearchPathMember {
        private final DesignElementHandle handle;

        public DesignElementSearchPathMember(DesignElementHandle handle) {
            this.handle = handle;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("element #");
            sb.append(this.handle.getIndex());
            sb.append(" ");
            sb.append(this.handle.getClass().getName());
            sb.append(" ID=");
            sb.append(this.handle.getID());
            sb.append(" ");
            sb.append(this.handle.getDisplayLabel());
            return sb.toString();
        }

        @Override
        public String getName() {
            return this.handle.getDisplayLabel();
        }

        @Override
        public String getElementType() {
            return this.handle.getElement().getDefn().getDisplayName();
        }

        @Override
        public Long getElementId() {
            return this.handle.getID();
        }

        @Override
        public Object getObject() {
            return this.handle;
        }
    }

    private static interface SearchPathMember {
        public String getName();

        public String getElementType();

        public Long getElementId();

        public Object getObject();
    }

    public static class SearchResult {
        private final List<SearchPathMember> path;
        private final String propertyName;

        public SearchResult(List<SearchPathMember> path, String propertyName) {
            this.path = path;
            this.propertyName = propertyName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (SearchPathMember member : this.path) {
                sb.append(sep);
                sep = member instanceof SlotSearchPathMember ? ":" : " / ";
                sb.append(member.getName());
            }
            return sb.toString();
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getElementName() {
            if (this.path.isEmpty()) {
                return null;
            }
            SearchPathMember member = this.path.get(this.path.size() - 1);
            return member.getName();
        }

        public String getElementType() {
            if (this.path.isEmpty()) {
                return null;
            }
            SearchPathMember member = this.path.get(this.path.size() - 1);
            return member.getElementType();
        }

        public Long getElementId() {
            if (this.path.isEmpty()) {
                return null;
            }
            SearchPathMember member = this.path.get(this.path.size() - 1);
            return member.getElementId();
        }

        public Object getObject() {
            if (this.path.isEmpty()) {
                return null;
            }
            SearchPathMember member = this.path.get(this.path.size() - 1);
            return member.getObject();
        }
    }

    private static class SlotSearchPathMember
    implements SearchPathMember {
        private final SlotHandle slotHandle;

        public SlotSearchPathMember(SlotHandle slotHandle) {
            this.slotHandle = slotHandle;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("slot ");
            sb.append(this.slotHandle.getSlotID());
            sb.append(" ");
            sb.append(this.slotHandle.getDefn().getDisplayName());
            return sb.toString();
        }

        @Override
        public String getName() {
            return this.slotHandle.getDefn().getDisplayName();
        }

        @Override
        public String getElementType() {
            return this.slotHandle.getDefn().getDisplayName();
        }

        @Override
        public Long getElementId() {
            return this.slotHandle.getElement().getID();
        }

        @Override
        public Object getObject() {
            return this.slotHandle;
        }
    }
}

