/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.birt.report.designer.internal.ui.views.actions.SearchAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SearchInputDialog
extends BaseDialog {
    private static final int SEARCH_ID = 1025;
    private static final int BACK_ID = 1026;
    private static final String ANY = "(any)";
    private static final String PROPERTY_NAME_ID = "id";
    private static final String VALUE_LABEL = Messages.getString((String)"SearchInputDialog.ValueLabel");
    private static final String PROP_LABEL = Messages.getString((String)"SearchInputDialog.PropLabel");
    private final String value;
    private final String helpContextID;
    private Text valueText;
    private Combo propCombo;
    private Button ignoreCaseButton;
    private Button wholeWordButton;
    private Button regexButton;
    private Button recursiveButton;
    private Table table;
    private String errorMessage;
    private Label errorMessageText;
    private final SearchActionServices services;

    public SearchInputDialog(Shell parentShell, String initialValue, String helpContextID, SearchActionServices services) {
        super(Messages.getString((String)"SearchInputDialog.DialogTitle"));
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF);
        this.value = initialValue == null ? "" : initialValue;
        this.helpContextID = helpContextID;
        this.services = services;
    }

    public boolean close() {
        if (this.services != null) {
            this.services.close();
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        Composite textContainer = new Composite(composite, 0);
        GridData gd = new GridData(4, 0, true, false);
        textContainer.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        textContainer.setLayout((Layout)layout);
        Label label = new Label(textContainer, 64);
        label.setText(VALUE_LABEL);
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        label.setFont(parent.getFont());
        this.valueText = new Text(textContainer, 2048);
        this.valueText.setText(this.value);
        this.valueText.selectAll();
        gd = new GridData(768);
        gd.widthHint = 250;
        this.valueText.setLayoutData((Object)gd);
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = SearchInputDialog.this.valueText.getText().trim();
                if (text.length() == 0) {
                    SearchInputDialog.this.getButton(1025).setEnabled(false);
                    SearchInputDialog.this.setErrorMessage(Messages.getString((String)"SearchInputDialog.Message.BlankName"));
                } else {
                    SearchInputDialog.this.getButton(1025).setEnabled(true);
                    SearchInputDialog.this.setErrorMessage(null);
                }
                SearchInputDialog.this.getButton(1026).setEnabled(false);
            }
        });
        label = new Label(textContainer, 64);
        label.setText(PROP_LABEL);
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        label.setFont(parent.getFont());
        this.propCombo = new Combo(textContainer, 2048);
        gd = new GridData(768);
        gd.widthHint = 250;
        this.propCombo.setLayoutData((Object)gd);
        this.propCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = SearchInputDialog.this.propCombo.getText().trim();
                if (text.length() == 0 || SearchInputDialog.ANY.equals(text)) {
                    SearchInputDialog.this.setErrorMessage(Messages.getString((String)"SearchInputDialog.Message.AllProps"));
                } else {
                    SearchInputDialog.this.setErrorMessage(null);
                }
            }
        });
        Composite optionContainer = new Composite(composite, 0);
        gd = new GridData(0, 0, false, false);
        optionContainer.setLayoutData((Object)gd);
        this.ignoreCaseButton = new Button(optionContainer, 32);
        this.ignoreCaseButton.setText(Messages.getString((String)"SearchInputDialog.Message.IgnoreCase"));
        this.ignoreCaseButton.setToolTipText(Messages.getString((String)"SearchInputDialog.Message.IgnoreCase.ToolTip"));
        this.wholeWordButton = new Button(optionContainer, 32);
        this.wholeWordButton.setText(Messages.getString((String)"SearchInputDialog.Message.WholeWord"));
        this.wholeWordButton.setToolTipText(Messages.getString((String)"SearchInputDialog.Message.WholeWord.ToolTip"));
        this.regexButton = new Button(optionContainer, 32);
        this.regexButton.setText(Messages.getString((String)"SearchInputDialog.Message.RegularExpression"));
        this.regexButton.setToolTipText(Messages.getString((String)"SearchInputDialog.Message.RegularExpression.ToolTip"));
        this.recursiveButton = new Button(optionContainer, 32);
        this.recursiveButton.setText(Messages.getString((String)"SearchInputDialog.Message.Recursive"));
        this.recursiveButton.setToolTipText(Messages.getString((String)"SearchInputDialog.Message.Recursive.ToolTip"));
        this.recursiveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SearchInputDialog.this.updateProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SearchInputDialog.this.updateProperties();
            }
        });
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        optionContainer.setLayout((Layout)layout);
        this.errorMessageText = new Label(composite, 0);
        gd = new GridData(768);
        gd.verticalIndent = 5;
        gd.horizontalSpan = 2;
        this.errorMessageText.setLayoutData((Object)gd);
        Composite tableContainer = new Composite(composite, 0);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 250;
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        tableContainer.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        tableContainer.setLayout((Layout)layout);
        Table table = new Table(tableContainer, 0x10010800);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
        TableColumn pathColumn = new TableColumn(table, 0);
        pathColumn.setText(Messages.getString((String)"SearchInputDialog.ResultTableColumn.Property"));
        table.getColumn(0).pack();
        TableColumn propColumn = new TableColumn(table, 0);
        propColumn.setText(Messages.getString((String)"SearchInputDialog.ResultTableColumn.Element"));
        table.getColumn(1).pack();
        TableColumn typeColumn = new TableColumn(table, 0);
        typeColumn.setText(Messages.getString((String)"SearchInputDialog.ResultTableColumn.ElementType"));
        table.getColumn(2).pack();
        TableColumn idColumn = new TableColumn(table, 0);
        idColumn.setText(Messages.getString((String)"SearchInputDialog.ResultTableColumn.ElementId"));
        table.getColumn(3).pack();
        table.addListener(13, event -> this.itemSelected(event.item.getData()));
        this.table = table;
        this.setErrorMessage(this.errorMessage);
        SearchInputDialog.applyDialogFont((Control)composite);
        UIUtil.bindHelp((Control)parent, this.helpContextID);
        this.updateProperties();
        return composite;
    }

    public void updateProperties() {
        String text = this.propCombo.getText();
        this.propCombo.removeAll();
        this.propCombo.add(ANY);
        boolean found = text.equals(ANY);
        if (this.services != null) {
            boolean recursive = this.recursiveButton.getSelection();
            List<String> list = this.services.getPropertyNames(recursive);
            for (String name : list) {
                this.propCombo.add(name);
                if (found || text.trim().length() <= 0 || !name.equals(text)) continue;
                found = true;
            }
        }
        if (!found) {
            text = ANY;
        }
        this.propCombo.setText(text);
    }

    private void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
        }
    }

    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        if (this.valueText.getText().trim().length() == 0) {
            this.getButton(1025).setEnabled(false);
        }
        this.getButton(1026).setEnabled(false);
        return composite;
    }

    private void searchPressed() {
        Search search;
        String searchProp = this.propCombo.getText();
        if (searchProp != null && ((searchProp = searchProp.trim()).length() == 0 || ANY.equals(searchProp))) {
            searchProp = null;
        }
        try {
            search = new Search(this.valueText.getText().trim(), searchProp, this.ignoreCaseButton.getSelection(), this.wholeWordButton.getSelection(), this.regexButton.getSelection(), this.recursiveButton.getSelection());
        }
        catch (PatternSyntaxException e) {
            this.setErrorMessage(Messages.getFormattedString((String)"SearchInputDialog.Message.InvalidRegularExpression", (Object[])new Object[]{e.getLocalizedMessage()}));
            search = null;
        }
        if (this.services != null && search != null) {
            List<SearchAction.SearchResult> searchResults = this.services.search(search);
            int count = searchResults.size();
            this.setErrorMessage(count + " " + Messages.getString((String)"SearchInputDialog.Message.Found"));
            this.getButton(1026).setEnabled(count > 0);
            this.table.setItemCount(0);
            for (SearchAction.SearchResult searchResult : searchResults) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(0, searchResult.getPropertyName());
                item.setText(1, searchResult.getElementName());
                item.setText(2, searchResult.getElementType());
                item.setText(3, searchResult.getElementId().toString());
                item.setData((Object)searchResult);
            }
            TableColumn[] tableColumnArray = this.table.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn tableColumn = tableColumnArray[n2];
                tableColumn.pack();
                ++n2;
            }
            this.table.redraw();
        }
    }

    protected void itemSelected(Object data) {
        if (this.services != null) {
            this.services.select(data);
            this.getButton(1026).setEnabled(true);
        }
    }

    private void backPressed() {
        if (this.services != null) {
            boolean isEmpty = this.services.back();
            this.getButton(1026).setEnabled(!isEmpty);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.getString((String)"SearchInputDialog.Label.SearchButton"), true);
        this.createButton(parent, 1026, Messages.getString((String)"SearchInputDialog.Label.BackButton"), false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (1025 == buttonId) {
            this.searchPressed();
        } else if (1026 == buttonId) {
            this.backPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public static class Search {
        private final String searchProp;
        private final String searchValue;
        private final Pattern pattern;
        private final boolean ignoreCase;
        private final boolean wholeWord;
        private final boolean recursive;

        private Search(String searchValue, String searchProp, boolean ignoreCase, boolean wholeWord, boolean regex, boolean recursive) {
            this.searchProp = searchProp;
            this.searchValue = searchValue;
            this.ignoreCase = ignoreCase;
            this.wholeWord = wholeWord;
            this.recursive = recursive;
            Pattern pattern = null;
            if (regex) {
                int flags = 0;
                if (ignoreCase) {
                    flags |= 2;
                }
                Object patternString = searchValue;
                if (wholeWord) {
                    if (!((String)patternString).startsWith("^")) {
                        patternString = "^" + (String)patternString;
                    }
                    if (!((String)patternString).endsWith("$")) {
                        patternString = (String)patternString + "$";
                    }
                }
                pattern = Pattern.compile((String)patternString, flags);
            }
            this.pattern = pattern;
        }

        public String matches(DesignElementHandle designElementHandle) {
            if (this.searchProp == null) {
                DesignElement element = designElementHandle.getElement();
                List defns = element.getPropertyDefns();
                for (IElementPropertyDefn defn : defns) {
                    String name = defn.getName();
                    Object value = element.getProperty(designElementHandle.getModule(), name);
                    if (value == null || !this.matches(value)) continue;
                    return name;
                }
                if (this.matches(element.getID())) {
                    return SearchInputDialog.PROPERTY_NAME_ID;
                }
            } else {
                Object value = designElementHandle.getProperty(this.searchProp);
                if (value != null && this.matches(value)) {
                    return this.searchProp;
                }
            }
            return null;
        }

        private boolean matches(Object value) {
            Matcher matcher;
            String valueString = value.toString();
            return this.pattern != null ? (matcher = this.pattern.matcher(valueString)).find() : (this.ignoreCase ? (this.wholeWord ? valueString.equalsIgnoreCase(this.searchValue) : valueString.toLowerCase().contains(this.searchValue.toLowerCase())) : (this.wholeWord ? valueString.equals(this.searchValue) : valueString.contains(this.searchValue)));
        }

        public boolean isRecursive() {
            return this.recursive;
        }
    }

    public static interface SearchActionServices {
        public List<SearchAction.SearchResult> search(Search var1);

        public void close();

        public List<String> getPropertyNames(boolean var1);

        public boolean back();

        public void select(Object var1);
    }
}

