/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.testutil;

import junit.framework.TestCase;
import org.eclipse.birt.report.designer.tests.ITestConstants;
import org.eclipse.birt.report.designer.testutil.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class BirtUITestCase
extends TestCase
implements ITestConstants {
    protected IWorkbench tWorkbench;
    protected IWorkbenchWindow tWindow;
    protected IWorkbenchPage tPage;
    protected IPerspectiveDescriptor tPerspectiveDescriptor;
    protected IEditorPart tEditor = null;

    protected void setUp() throws Exception {
        this.tWorkbench = PlatformUI.getWorkbench();
        this.tWindow = this.tWorkbench.getActiveWorkbenchWindow();
        this.tPage = this.tWindow.getActivePage();
        this.tPerspectiveDescriptor = this.tWorkbench.getPerspectiveRegistry().findPerspectiveWithId("org.eclipse.birt.report.designer.ui.ReportPerspective");
    }

    protected void showPerspective() throws Exception {
        this.tWorkbench.showPerspective("org.eclipse.birt.report.designer.ui.ReportPerspective", this.tWindow);
    }

    protected IEditorPart openEditor() throws Exception {
        if (this.tEditor == null) {
            IProject p = FileUtil.createProject("Test");
            IFile f = FileUtil.createFile("test.rptdesign", p);
            this.tEditor = this.tPage.openEditor((IEditorInput)new FileEditorInput(f), "org.eclipse.birt.report.designer.ui.editors.ReportEditor");
        }
        return this.tEditor;
    }

    protected void saveEditor() {
        if (this.tEditor != null) {
            this.tEditor.doSave(null);
        }
    }

    protected void closeEditor() {
        if (this.tEditor != null) {
            this.tPage.closeEditor(this.tEditor, false);
            this.tEditor = null;
        }
    }

    protected IViewPart getView(String id) {
        IViewReference[] v = this.tPage.getViewReferences();
        int i = 0;
        while (i < v.length) {
            if (v[i].getId().equals(id)) {
                return (IViewPart)v[i].getPart(true);
            }
            ++i;
        }
        return null;
    }
}

