/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.core.vm.rm;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.eclipse.birt.report.debug.internal.core.vm.VMConstants;
import org.eclipse.birt.report.debug.internal.core.vm.VMException;
import org.eclipse.birt.report.debug.internal.core.vm.VMValue;
import org.eclipse.birt.report.debug.internal.core.vm.VMVariable;
import org.eclipse.birt.report.debug.internal.core.vm.rm.RMClient;
import org.eclipse.birt.report.debug.internal.core.vm.rm.RMVariable;

public class RMValue
implements VMValue,
Serializable,
VMConstants {
    private static final long serialVersionUID = 1L;
    private long rid;
    private String valueString;
    private String typeName;
    private VMVariable[] members;
    private transient RMClient vm;

    public RMValue(long id, String valueString, String typeName, VMVariable[] members) {
        this.rid = id;
        this.valueString = valueString;
        this.typeName = typeName;
        this.members = members;
    }

    public void attach(RMClient vm) {
        this.vm = vm;
    }

    public VMVariable[] getLocalMembers() {
        return this.members;
    }

    @Override
    public VMVariable[] getMembers() {
        if (this.members == null) {
            if (this.vm != null) {
                try {
                    this.members = this.vm.getMembers(this.rid);
                    this.hookVM(this.members);
                    return this.members;
                }
                catch (VMException e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    this.members = new VMVariable[]{new RMVariable(new RMValue(-1L, sw.toString(), e.getClass().getName(), NO_CHILD), "<error>", "null")};
                    return this.members;
                }
            }
            this.members = NO_CHILD;
        }
        this.hookVM(this.members);
        return this.members;
    }

    private void hookVM(VMVariable[] vars) {
        if (vars instanceof RMVariable[]) {
            RMVariable[] rvars = (RMVariable[])vars;
            int i = 0;
            while (i < rvars.length) {
                RMValue val = (RMValue)vars[i].getValue();
                if (val != null) {
                    val.attach(this.vm);
                    this.hookVM(val.getLocalMembers());
                }
                ++i;
            }
        }
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getValueString() {
        return this.valueString;
    }
}

