/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class NativeDateTimeSpanTest
extends TestCase {
    Context cx;
    Scriptable scope;
    boolean exceptionValue;

    @Before
    public void setUp() throws Exception {
        this.cx = Context.enter();
        this.scope = this.cx.initStandardObjects();
        new CoreJavaScriptInitializer().initialize(this.cx, this.scope);
    }

    @After
    public void tearDown() {
        Context.exit();
    }

    protected Object eval(String script) {
        Object result = null;
        try {
            result = this.cx.evaluateString(this.scope, script, "inline", 1, null);
        }
        catch (Exception ex) {
            this.exceptionValue = true;
        }
        return result;
    }

    protected Calendar getCalendarInstance() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        return cal;
    }

    @Test
    public void testYears() {
        String script2 = "var startDate=\"2/29/08 8:01 PM\" ;var endDate=\"2/28/09 8:01 PM\" ;DateTimeSpan.years(startDate,endDate);";
        Object value2 = this.eval(script2);
        NativeDateTimeSpanTest.assertEquals((int)1, (int)((Integer)value2));
        String script1 = "var startDate=\"2/3/08 8:01 PM\" ;var endDate=\"9/13/09 8:01 PM\" ;DateTimeSpan.years(startDate,endDate);";
        Object value1 = this.eval(script1);
        NativeDateTimeSpanTest.assertEquals((int)1, (int)((Integer)value1));
        String script3 = "var startDate=\"2/29/08 8:01 PM\" ;var endDate=\"3/1/09 8:01 PM\" ;DateTimeSpan.years(startDate,endDate);";
        Object value3 = this.eval(script3);
        NativeDateTimeSpanTest.assertEquals((int)1, (int)((Integer)value3));
        String script4 = "var startDate=\"2/29/08 8:01 PM\" ;var endDate=\"2/29/16 8:01 PM\" ;DateTimeSpan.years(startDate,endDate);";
        Object value4 = this.eval(script4);
        NativeDateTimeSpanTest.assertEquals((int)8, (int)((Integer)value4));
        String script5 = "var startDate=\"9/5/08 8:01 PM\" ;var endDate=\"4/30/10 8:01 PM\" ;DateTimeSpan.years(startDate,endDate);";
        Object value5 = this.eval(script5);
        NativeDateTimeSpanTest.assertEquals((int)1, (int)((Integer)value5));
    }

    @Test
    public void testMonths() {
        String script2 = "var startDate=\"2/29/08 8:01 PM\" ;var endDate=\"2/28/09 8:01 PM\" ;DateTimeSpan.months(startDate,endDate);";
        Object value2 = this.eval(script2);
        NativeDateTimeSpanTest.assertEquals((int)12, (int)((Integer)value2));
        String script11 = "var startDate=\"3/12/08 8:01 PM\" ;var endDate=\"3/12/09 8:00 PM\" ;DateTimeSpan.months(startDate,endDate);";
        Object value11 = this.eval(script11);
        NativeDateTimeSpanTest.assertEquals((int)11, (int)((Integer)value11));
        String script3 = "var startDate=\"2/29/08 8:01 PM\" ;var endDate=\"3/1/09 8:02 PM\" ;DateTimeSpan.months(startDate,endDate);";
        Object value3 = this.eval(script3);
        NativeDateTimeSpanTest.assertEquals((int)12, (int)((Integer)value3));
        String script9 = "var startDate=\"1/5/08 8:01 PM\" ;var endDate=\"1/5/09 8:05 PM\" ;DateTimeSpan.months(startDate,endDate);";
        Object value9 = this.eval(script9);
        if (value9 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)12, (int)((Integer)value9));
        }
        String script1 = "var startDate=\"2/3/08 8:01 PM\" ;var endDate=\"9/13/09 8:01 PM\" ;DateTimeSpan.months(startDate,endDate);";
        Object value1 = this.eval(script1);
        NativeDateTimeSpanTest.assertEquals((int)19, (int)((Integer)value1));
        String script4 = "var startDate=\"2/29/08 8:01 PM\" ;var endDate=\"2/29/16 8:01 PM\" ;DateTimeSpan.months(startDate,endDate);";
        Object value4 = this.eval(script4);
        NativeDateTimeSpanTest.assertEquals((int)96, (int)((Integer)value4));
        String script5 = "var startDate=\"1/5/08 8:01 PM\" ;var endDate=\"4/30/10 8:01 PM\" ;DateTimeSpan.months(startDate,endDate);";
        Object value5 = this.eval(script5);
        NativeDateTimeSpanTest.assertEquals((int)27, (int)((Integer)value5));
        String script6 = "var startDate=\"9/5/08 8:01 PM\" ;var endDate=\"4/30/09 8:01 PM\" ;DateTimeSpan.months(startDate,endDate);";
        Object value6 = this.eval(script6);
        NativeDateTimeSpanTest.assertEquals((int)7, (int)((Integer)value6));
        String script7 = "var startDate=\"9/5/08 8:01 PM\" ;var endDate=\"4/30/10 8:01 PM\" ;DateTimeSpan.months(startDate,endDate);";
        Object value7 = this.eval(script7);
        NativeDateTimeSpanTest.assertEquals((int)19, (int)((Integer)value7));
        String script8 = "var startDate=\"1/5/08 8:01 PM\" ;var endDate=\"4/30/08 8:01 PM\" ;DateTimeSpan.months(startDate,endDate);";
        Object value8 = this.eval(script8);
        NativeDateTimeSpanTest.assertEquals((int)3, (int)((Integer)value8));
        String script10 = "var startDate=\"3/12/08 8:01 PM\" ;var endDate=\"3/13/08 8:05 PM\" ;DateTimeSpan.months(startDate,endDate);";
        Object value10 = this.eval(script10);
        NativeDateTimeSpanTest.assertEquals((int)0, (int)((Integer)value10));
    }

    @Test
    public void testDays() {
        String script13;
        Object value13;
        String script12;
        Object value12;
        String script11;
        Object value11;
        String script10;
        Object value10;
        String script9;
        Object value9;
        String script8;
        Object value8;
        String script7;
        Object value7;
        String script6;
        Object value6;
        String script4;
        Object value4;
        String script5;
        Object value5;
        String script3;
        Object value3;
        String script2;
        Object value2;
        String script1 = "var startDate=\"1/2/04 8:01 PM\" ;var endDate=\"1/3/04 8:01 PM\" ;DateTimeSpan.days(startDate,endDate);";
        Object value1 = this.eval(script1);
        if (value1 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)1, (int)((Integer)value1));
        }
        if ((value2 = this.eval(script2 = "var startDate=\"1/2/04 8:01 PM\" ;var endDate=\"1/3/04 7:01 PM\" ;DateTimeSpan.days(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)0, (int)((Integer)value2));
        }
        if ((value3 = this.eval(script3 = "var startDate=\"1/2/04 8:01 PM\" ;var endDate=\"1/3/04 8:02 PM\" ;DateTimeSpan.days(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)1, (int)((Integer)value3));
        }
        if ((value5 = this.eval(script5 = "var startDate=\"1/2/04 8:01 PM\" ;var endDate=\"1/4/04 8:02 PM\" ;DateTimeSpan.days(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)2, (int)((Integer)value5));
        }
        if ((value4 = this.eval(script4 = "var startDate=\"1/2/04 8:01 PM\" ;var endDate=\"1/2/04 8:02 PM\" ;DateTimeSpan.days(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)0, (int)((Integer)value4));
        }
        if ((value6 = this.eval(script6 = "var startDate=\"1/2/04 8:01 PM\" ;var endDate=\"2/4/05 8:02 PM\" ;DateTimeSpan.days(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)399, (int)((Integer)value6));
        }
        if ((value7 = this.eval(script7 = "var startDate=\"1/2/04 8:01 PM\" ;var endDate=\"2/4/05 8:00 PM\" ;DateTimeSpan.days(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)398, (int)((Integer)value7));
        }
        if ((value8 = this.eval(script8 = "var startDate=\"1/2/04 8:01 PM\" ;var endDate=\"3/1/05 8:01 PM\" ;DateTimeSpan.days(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)424, (int)((Integer)value8));
        }
        if ((value9 = this.eval(script9 = "var startDate=\"2/2/04 8:01 PM\" ;var endDate=\"1/1/05 8:01 PM\" ;DateTimeSpan.days(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)334, (int)((Integer)value9));
        }
        if ((value10 = this.eval(script10 = "var startDate=\"1/1/04 8:01 PM\" ;var endDate=\"1/1/05 8:01 PM\" ;DateTimeSpan.days(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)366, (int)((Integer)value10));
        }
        if ((value11 = this.eval(script11 = "var startDate=\"1/1/04 8:01 PM\" ;var endDate=\"1/3/09 8:01 PM\" ;DateTimeSpan.days(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)1829, (int)((Integer)value11));
        }
        if ((value12 = this.eval(script12 = "var startDate=\"2/4/09 0:00 PM\" ;var endDate=\"2/2/10 8:01 PM\" ;DateTimeSpan.days(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)363, (int)((Integer)value12));
        }
        if ((value13 = this.eval(script13 = "var startDate=\"3/5/09 0:00 PM\" ;var endDate=\"2/1/10 8:01 PM\" ;DateTimeSpan.days(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)333, (int)((Integer)value13));
        }
    }

    @Test
    public void testHours() {
        String script11;
        Object value11;
        String script10;
        Object value10;
        String script9;
        Object value9;
        String script8;
        Object value8;
        String script7;
        Object value7;
        String script6;
        Object value6;
        String script5;
        Object value5;
        String script4;
        Object value4;
        String script2;
        Object value2;
        String script3;
        Object value3;
        String script1 = "var startDate=\"2/3/09 8:01 PM\" ;var endDate=\"2/4/09 8:01 PM\" ;DateTimeSpan.hours(startDate,endDate);";
        Object value1 = this.eval(script1);
        if (value1 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)24, (int)((Integer)value1));
        }
        if ((value3 = this.eval(script3 = "var startDate=\"2/29/08 8:01 PM\" ;var endDate=\"3/1/08 8:01 PM\" ;DateTimeSpan.hours(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)24, (int)((Integer)value3));
        }
        if ((value2 = this.eval(script2 = "var startDate=\"3/1/08 8:01 PM\" ;var endDate=\"3/1/08 9:02 PM\" ;DateTimeSpan.hours(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)1, (int)((Integer)value2));
        }
        if ((value4 = this.eval(script4 = "var startDate=\"2/2/08 8:01 PM\" ;var endDate=\"2/2/08 9:00 PM\" ;DateTimeSpan.hours(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)0, (int)((Integer)value4));
        }
        if ((value5 = this.eval(script5 = "var startDate=\"2/2/08 8:01 PM\" ;var endDate=\"2/2/08 9:02 PM\" ;DateTimeSpan.hours(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)1, (int)((Integer)value5));
        }
        if ((value6 = this.eval(script6 = "var startDate=\"2/2/08 8:01 PM\" ;var endDate=\"2/3/08 9:02 PM\" ;DateTimeSpan.hours(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)25, (int)((Integer)value6));
        }
        if ((value7 = this.eval(script7 = "var startDate=\"2/2/08 8:03 PM\" ;var endDate=\"2/3/08 8:02 PM\" ;DateTimeSpan.hours(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)23, (int)((Integer)value7));
        }
        if ((value8 = this.eval(script8 = "var startDate=\"2/2/09 8:01 PM\" ;var endDate=\"2/2/10 8:01 PM\" ;DateTimeSpan.hours(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)8760, (int)((Integer)value8));
        }
        if ((value9 = this.eval(script9 = "var startDate=\"2/2/08 8:01 PM\" ;var endDate=\"2/3/09 8:00 PM\" ;DateTimeSpan.hours(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)8807, (int)((Integer)value9));
        }
        if ((value10 = this.eval(script10 = "var startDate=\"2/2/09 9:01 PM\" ;var endDate=\"2/3/09 8:00 PM\" ;DateTimeSpan.hours(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)22, (int)((Integer)value10));
        }
        if ((value11 = this.eval(script11 = "var startDate=\"2/2/09 3:01 PM\" ;var endDate=\"2/3/09 8:00 PM\" ;DateTimeSpan.hours(startDate,endDate);")) instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)28, (int)((Integer)value11));
        }
        Calendar dateCal1 = this.getCalendarInstance();
        dateCal1.set(2008, 8, 13, 20, 1, 44);
        Date date1 = dateCal1.getTime();
        Object jsNumber1 = Context.javaToJS((Object)date1, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date1", (Object)jsNumber1);
        dateCal1 = this.getCalendarInstance();
        dateCal1.set(2008, 8, 13, 21, 1, 44);
        Date date2 = dateCal1.getTime();
        Object jsNumber2 = Context.javaToJS((Object)date2, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date2", (Object)jsNumber2);
        String script12 = "DateTimeSpan.hours(date1,date2)";
        Object value12 = this.eval(script12);
        if (value12 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)1, (int)((Integer)value12));
        }
    }

    @Test
    public void testMinutes() {
        Calendar dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 20, 1, 44);
        Date date1 = dateCal.getTime();
        Object jsNumber1 = Context.javaToJS((Object)date1, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date1", (Object)jsNumber1);
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 21, 1, 44);
        Date date2 = dateCal.getTime();
        Object jsNumber2 = Context.javaToJS((Object)date2, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date2", (Object)jsNumber2);
        String script1 = "DateTimeSpan.minutes(date1,date2)";
        Object value1 = this.eval(script1);
        if (value1 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)60, (int)((Integer)value1));
        }
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 20, 1, 45);
        Date date3 = dateCal.getTime();
        Object jsNumber3 = Context.javaToJS((Object)date3, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date3", (Object)jsNumber3);
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 21, 1, 44);
        Date date4 = dateCal.getTime();
        Object jsNumber4 = Context.javaToJS((Object)date4, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date4", (Object)jsNumber4);
        String script2 = "DateTimeSpan.minutes(date3,date4)";
        Object value2 = this.eval(script2);
        if (value2 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)59, (int)((Integer)value2));
        }
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 20, 1, 45);
        Date date5 = dateCal.getTime();
        Object jsNumber5 = Context.javaToJS((Object)date5, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date5", (Object)jsNumber5);
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 21, 2, 45);
        Date date6 = dateCal.getTime();
        Object jsNumber6 = Context.javaToJS((Object)date6, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date6", (Object)jsNumber6);
        String script3 = "DateTimeSpan.minutes(date5,date6)";
        Object value3 = this.eval(script3);
        if (value3 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)61, (int)((Integer)value3));
        }
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 1, 28, 20, 1, 45);
        Date date7 = dateCal.getTime();
        Object jsNumber7 = Context.javaToJS((Object)date7, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date7", (Object)jsNumber7);
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 2, 1, 20, 2, 45);
        Date date8 = dateCal.getTime();
        Object jsNumber8 = Context.javaToJS((Object)date8, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date8", (Object)jsNumber8);
        String script4 = "DateTimeSpan.minutes(date7,date8)";
        Object value4 = this.eval(script4);
        if (value4 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)2881, (int)((Integer)value4));
        }
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 1, 28, 20, 4, 45);
        Date date9 = dateCal.getTime();
        Object jsNumber9 = Context.javaToJS((Object)date9, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date9", (Object)jsNumber9);
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 1, 28, 21, 2, 45);
        Date date10 = dateCal.getTime();
        Object jsNumber10 = Context.javaToJS((Object)date10, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date10", (Object)jsNumber10);
        String script5 = "DateTimeSpan.minutes(date9,date10)";
        Object value5 = this.eval(script5);
        if (value5 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)58, (int)((Integer)value5));
        }
        dateCal = this.getCalendarInstance();
        dateCal.set(2007, 12, 31, 20, 4, 45);
        Date date11 = dateCal.getTime();
        Object jsNumber11 = Context.javaToJS((Object)date11, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date11", (Object)jsNumber11);
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 1, 1, 16, 2, 45);
        Date date12 = dateCal.getTime();
        Object jsNumber12 = Context.javaToJS((Object)date12, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date12", (Object)jsNumber12);
        String script6 = "DateTimeSpan.minutes(date11,date12)";
        Object value6 = this.eval(script6);
        if (value6 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)1198, (int)((Integer)value6));
        }
    }

    @Test
    public void testSeconds() {
        Calendar dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 20, 1, 44);
        Date date1 = dateCal.getTime();
        Object jsNumber1 = Context.javaToJS((Object)date1, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date1", (Object)jsNumber1);
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 20, 1, 45);
        Date date2 = dateCal.getTime();
        Object jsNumber2 = Context.javaToJS((Object)date2, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date2", (Object)jsNumber2);
        String script1 = "DateTimeSpan.seconds(date1,date2)";
        Object value1 = this.eval(script1);
        if (value1 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)1, (int)((Integer)value1));
        }
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 20, 1, 45);
        Date date3 = dateCal.getTime();
        Object jsNumber3 = Context.javaToJS((Object)date3, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date3", (Object)jsNumber3);
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 20, 2, 44);
        Date date4 = dateCal.getTime();
        Object jsNumber4 = Context.javaToJS((Object)date4, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date4", (Object)jsNumber4);
        String script2 = "DateTimeSpan.seconds(date3,date4)";
        Object value2 = this.eval(script2);
        if (value2 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)59, (int)((Integer)value2));
        }
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 20, 1, 45);
        Date date5 = dateCal.getTime();
        Object jsNumber5 = Context.javaToJS((Object)date5, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date5", (Object)jsNumber5);
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 20, 2, 46);
        Date date6 = dateCal.getTime();
        Object jsNumber6 = Context.javaToJS((Object)date6, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date6", (Object)jsNumber6);
        String script3 = "DateTimeSpan.seconds(date5,date6)";
        Object value3 = this.eval(script3);
        if (value3 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)61, (int)((Integer)value3));
        }
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 1, 28, 20, 1, 45);
        Date date7 = dateCal.getTime();
        Object jsNumber7 = Context.javaToJS((Object)date7, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date7", (Object)jsNumber7);
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 2, 1, 20, 1, 45);
        Date date8 = dateCal.getTime();
        Object jsNumber8 = Context.javaToJS((Object)date8, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date8", (Object)jsNumber8);
        String script4 = "DateTimeSpan.seconds(date7,date8)";
        Object value4 = this.eval(script4);
        if (value4 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)172800, (int)((Integer)value4));
        }
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 1, 28, 20, 6, 45);
        Date date9 = dateCal.getTime();
        Object jsNumber9 = Context.javaToJS((Object)date9, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date9", (Object)jsNumber9);
        dateCal = this.getCalendarInstance();
        dateCal.set(2008, 1, 28, 21, 5, 40);
        Date date10 = dateCal.getTime();
        Object jsNumber10 = Context.javaToJS((Object)date10, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date10", (Object)jsNumber10);
        String script5 = "DateTimeSpan.seconds(date9,date10)";
        Object value5 = this.eval(script5);
        if (value5 instanceof Integer) {
            NativeDateTimeSpanTest.assertEquals((int)3535, (int)((Integer)value5));
        }
    }

    @Test
    public void testAddDate() {
        String script1 = "var startDate=\"2/3/08 8:01 PM\" ;var years=1;var months=0;var days=0;DateTimeSpan.addDate(startDate,years,months,days);";
        Object value1 = this.eval(script1);
        Calendar cal = this.getCalendarInstance();
        cal.setTime((Date)value1);
        NativeDateTimeSpanTest.assertEquals((int)2009, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)1, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)3, (int)cal.get(5));
        System.out.println("1");
        Calendar dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 20, 1, 44);
        Date date1 = dateCal.getTime();
        Object jsNumber1 = Context.javaToJS((Object)date1, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date1", (Object)jsNumber1);
        String script2 = "DateTimeSpan.addDate(date1,1,0,0);";
        Object value2 = this.eval(script2);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value2);
        NativeDateTimeSpanTest.assertEquals((int)2009, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)8, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)13, (int)cal.get(5));
        System.out.println("2");
        String script3 = "var startDate=\"2/29/08 8:01 PM\" ;var years=1;var months=0;var days=0;DateTimeSpan.addDate(startDate,years,months,days);";
        Object value3 = this.eval(script3);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value3);
        NativeDateTimeSpanTest.assertEquals((int)2009, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)1, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)28, (int)cal.get(5));
        System.out.println("3");
        String script4 = "var startDate=\"1/31/07 8:01 PM\" ;var years=0;var months=1;var days=0;DateTimeSpan.addDate(startDate,years,months,days);";
        Object value4 = this.eval(script4);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value4);
        NativeDateTimeSpanTest.assertEquals((int)2007, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)1, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)28, (int)cal.get(5));
        System.out.println("4");
        dateCal.set(2004, 11, 31, 20, 1, 44);
        Date date2 = dateCal.getTime();
        Object jsNumber2 = Context.javaToJS((Object)date2, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date2", (Object)jsNumber2);
        String script5 = "DateTimeSpan.addDate(date2,1,0,0);";
        String script6 = "DateTimeSpan.addDate(date2,0,1,0);";
        String script7 = "DateTimeSpan.addDate(date2,0,0,1);";
        String script8 = "DateTimeSpan.addDate(date2,1,1,1);";
        Object value5 = this.eval(script5);
        Object value6 = this.eval(script6);
        Object value7 = this.eval(script7);
        Object value8 = this.eval(script8);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value5);
        NativeDateTimeSpanTest.assertEquals((int)2005, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)11, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)31, (int)cal.get(5));
        System.out.println("5");
        cal = this.getCalendarInstance();
        cal.setTime((Date)value6);
        NativeDateTimeSpanTest.assertEquals((int)2005, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)0, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)31, (int)cal.get(5));
        System.out.println("6");
        cal = this.getCalendarInstance();
        cal.setTime((Date)value7);
        NativeDateTimeSpanTest.assertEquals((int)2005, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)0, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)1, (int)cal.get(5));
        System.out.println("7");
        cal = this.getCalendarInstance();
        cal.setTime((Date)value8);
        NativeDateTimeSpanTest.assertEquals((int)2006, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)1, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)1, (int)cal.get(5));
        System.out.println("8");
        String script9 = "var startDate=\"1/31/07 8:01 PM\" ;var years=-1;var months=-1;var days=0;DateTimeSpan.addDate(startDate,years,months,days);";
        Object value9 = this.eval(script9);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value9);
        NativeDateTimeSpanTest.assertEquals((int)2005, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)11, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)31, (int)cal.get(5));
        System.out.println("9");
    }

    @Test
    public void testAddTime() {
        Calendar dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 20, 1, 44);
        Date date1 = dateCal.getTime();
        Object jsNumber1 = Context.javaToJS((Object)date1, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date1", (Object)jsNumber1);
        String script1 = "DateTimeSpan.addTime(date1,1,1,1);";
        Object value1 = this.eval(script1);
        Calendar cal = this.getCalendarInstance();
        cal.setTime((Date)value1);
        NativeDateTimeSpanTest.assertEquals((int)2008, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)8, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)13, (int)cal.get(5));
        NativeDateTimeSpanTest.assertEquals((int)21, (int)cal.get(11));
        NativeDateTimeSpanTest.assertEquals((int)2, (int)cal.get(12));
        NativeDateTimeSpanTest.assertEquals((int)45, (int)cal.get(13));
        System.out.println("1");
        String script2 = "DateTimeSpan.addTime(date1,25,1,1);";
        Object value2 = this.eval(script2);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value2);
        NativeDateTimeSpanTest.assertEquals((int)2008, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)8, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)14, (int)cal.get(5));
        NativeDateTimeSpanTest.assertEquals((int)21, (int)cal.get(11));
        NativeDateTimeSpanTest.assertEquals((int)2, (int)cal.get(12));
        NativeDateTimeSpanTest.assertEquals((int)45, (int)cal.get(13));
        System.out.println("2");
        String script3 = "DateTimeSpan.addTime(date1,0,61,61);";
        Object value3 = this.eval(script3);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value3);
        NativeDateTimeSpanTest.assertEquals((int)2008, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)8, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)13, (int)cal.get(5));
        NativeDateTimeSpanTest.assertEquals((int)21, (int)cal.get(11));
        NativeDateTimeSpanTest.assertEquals((int)3, (int)cal.get(12));
        NativeDateTimeSpanTest.assertEquals((int)45, (int)cal.get(13));
        System.out.println("3");
        String script4 = "DateTimeSpan.addTime(date1,4,61,61);";
        Object value4 = this.eval(script4);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value4);
        NativeDateTimeSpanTest.assertEquals((int)2008, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)8, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)14, (int)cal.get(5));
        NativeDateTimeSpanTest.assertEquals((int)1, (int)cal.get(11));
        NativeDateTimeSpanTest.assertEquals((int)3, (int)cal.get(12));
        NativeDateTimeSpanTest.assertEquals((int)45, (int)cal.get(13));
        System.out.println("4");
        String script5 = "DateTimeSpan.addTime(date1,-1,-1,-1);";
        Object value5 = this.eval(script5);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value5);
        NativeDateTimeSpanTest.assertEquals((int)2008, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)8, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)13, (int)cal.get(5));
        NativeDateTimeSpanTest.assertEquals((int)19, (int)cal.get(11));
        NativeDateTimeSpanTest.assertEquals((int)0, (int)cal.get(12));
        NativeDateTimeSpanTest.assertEquals((int)43, (int)cal.get(13));
        System.out.println("5");
        String script6 = "DateTimeSpan.addTime(date1,-1,-1,-61);";
        Object value6 = this.eval(script6);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value6);
        NativeDateTimeSpanTest.assertEquals((int)2008, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)8, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)13, (int)cal.get(5));
        NativeDateTimeSpanTest.assertEquals((int)18, (int)cal.get(11));
        NativeDateTimeSpanTest.assertEquals((int)59, (int)cal.get(12));
        NativeDateTimeSpanTest.assertEquals((int)43, (int)cal.get(13));
        System.out.println("6");
    }

    @Test
    public void testSubDate() {
        String script1 = "var startDate=\"2/3/08 8:01 PM\" ;var years=1;var months=0;var days=0;DateTimeSpan.subDate(startDate,years,months,days);";
        Object value1 = this.eval(script1);
        Calendar cal = this.getCalendarInstance();
        cal.setTime((Date)value1);
        NativeDateTimeSpanTest.assertEquals((int)2007, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)1, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)3, (int)cal.get(5));
        System.out.println("1");
        Calendar dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 20, 1, 44);
        Date date1 = dateCal.getTime();
        Object jsNumber1 = Context.javaToJS((Object)date1, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date1", (Object)jsNumber1);
        String script2 = "DateTimeSpan.subDate(date1,1,0,0);";
        Object value2 = this.eval(script2);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value2);
        NativeDateTimeSpanTest.assertEquals((int)2007, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)8, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)13, (int)cal.get(5));
        System.out.println("2");
        String script3 = "var startDate=\"2/29/08 8:01 PM\" ;var years=1;var months=0;var days=0;DateTimeSpan.subDate(startDate,years,months,days);";
        Object value3 = this.eval(script3);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value3);
        NativeDateTimeSpanTest.assertEquals((int)2007, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)1, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)28, (int)cal.get(5));
        System.out.println("3");
        String script4 = "var startDate=\"3/30/07 8:01 PM\" ;var years=0;var months=1;var days=3;DateTimeSpan.subDate(startDate,years,months,days);";
        Object value4 = this.eval(script4);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value4);
        NativeDateTimeSpanTest.assertEquals((int)2007, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)1, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)25, (int)cal.get(5));
        System.out.println("4");
    }

    @Test
    public void testSubTime() {
        Calendar dateCal = this.getCalendarInstance();
        dateCal.set(2008, 8, 13, 20, 1, 44);
        Date date1 = dateCal.getTime();
        Object jsNumber1 = Context.javaToJS((Object)date1, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"date1", (Object)jsNumber1);
        String script1 = "DateTimeSpan.subTime(date1,-1,-1,-1);";
        Object value1 = this.eval(script1);
        Calendar cal = this.getCalendarInstance();
        cal.setTime((Date)value1);
        NativeDateTimeSpanTest.assertEquals((int)2008, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)8, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)13, (int)cal.get(5));
        NativeDateTimeSpanTest.assertEquals((int)21, (int)cal.get(11));
        NativeDateTimeSpanTest.assertEquals((int)2, (int)cal.get(12));
        NativeDateTimeSpanTest.assertEquals((int)45, (int)cal.get(13));
        System.out.println("1");
        String script2 = "DateTimeSpan.subTime(date1,-25,-1,-1);";
        Object value2 = this.eval(script2);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value2);
        NativeDateTimeSpanTest.assertEquals((int)2008, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)8, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)14, (int)cal.get(5));
        NativeDateTimeSpanTest.assertEquals((int)21, (int)cal.get(11));
        NativeDateTimeSpanTest.assertEquals((int)2, (int)cal.get(12));
        NativeDateTimeSpanTest.assertEquals((int)45, (int)cal.get(13));
        System.out.println("2");
        String script5 = "DateTimeSpan.subTime(date1,1,1,1);";
        Object value5 = this.eval(script5);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value5);
        NativeDateTimeSpanTest.assertEquals((int)2008, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)8, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)13, (int)cal.get(5));
        NativeDateTimeSpanTest.assertEquals((int)19, (int)cal.get(11));
        NativeDateTimeSpanTest.assertEquals((int)0, (int)cal.get(12));
        NativeDateTimeSpanTest.assertEquals((int)43, (int)cal.get(13));
        System.out.println("5");
        String script6 = "DateTimeSpan.subTime(date1,1,1,61);";
        Object value6 = this.eval(script6);
        cal = this.getCalendarInstance();
        cal.setTime((Date)value6);
        NativeDateTimeSpanTest.assertEquals((int)2008, (int)cal.get(1));
        NativeDateTimeSpanTest.assertEquals((int)8, (int)cal.get(2));
        NativeDateTimeSpanTest.assertEquals((int)13, (int)cal.get(5));
        NativeDateTimeSpanTest.assertEquals((int)18, (int)cal.get(11));
        NativeDateTimeSpanTest.assertEquals((int)59, (int)cal.get(12));
        NativeDateTimeSpanTest.assertEquals((int)43, (int)cal.get(13));
        System.out.println("6");
    }
}

