/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SYSSCHEMASRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSSCHEMAS";
    public static final int SYSSCHEMAS_COLUMN_COUNT = 3;
    public static final int SYSSCHEMAS_SCHEMAID = 1;
    public static final int SYSSCHEMAS_SCHEMANAME = 2;
    public static final int SYSSCHEMAS_SCHEMAAID = 3;
    protected static final int SYSSCHEMAS_INDEX1_ID = 0;
    protected static final int SYSSCHEMAS_INDEX2_ID = 1;
    private static final int[][] indexColumnPositions = new int[][]{{2}, {1}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"80000022-00d0-fd77-3ed8-000a0a0b1900", "8000002a-00d0-fd77-3ed8-000a0a0b1900", "80000024-00d0-fd77-3ed8-000a0a0b1900", "80000026-00d0-fd77-3ed8-000a0a0b1900"};

    SYSSCHEMASRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(3, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String name = null;
        UUID oid = null;
        String uuid = null;
        String aid = null;
        if (td != null) {
            SchemaDescriptor schemaDescriptor = (SchemaDescriptor)td;
            name = schemaDescriptor.getSchemaName();
            oid = schemaDescriptor.getUUID();
            if (oid == null) {
                oid = this.getUUIDFactory().createUUID();
                schemaDescriptor.setUUID(oid);
            }
            uuid = oid.toString();
            aid = schemaDescriptor.getAuthorizationId();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(3);
        row.setColumn(1, new SQLChar(uuid));
        row.setColumn(2, new SQLVarchar(name));
        row.setColumn(3, new SQLVarchar(aid));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        SanityManager.ASSERT(row.nColumns() == 3, "Wrong number of columns for a SYSSCHEMAS row");
        DataValueDescriptor col = row.getColumn(1);
        String uuid = col.getString();
        UUID id = this.getUUIDFactory().recreateUUID(uuid);
        col = row.getColumn(2);
        String name = col.getString();
        col = row.getColumn(3);
        String aid = col.getString();
        SchemaDescriptor descriptor = ddg.newSchemaDescriptor(name, aid, id);
        return descriptor;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getIdentifierColumn("SCHEMANAME", false), SystemColumnImpl.getIdentifierColumn("AUTHORIZATIONID", false)};
    }
}

