/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.client.am.ClientBlob;

class BlobOutputStream
extends OutputStream {
    private ClientBlob blob_;
    private long offset_;

    BlobOutputStream(ClientBlob blob, long offset) {
        this.blob_ = blob;
        this.offset_ = offset;
        if (this.offset_ - 1L > (long)(this.blob_.binaryString_.length - this.blob_.dataOffset_)) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] ba = new byte[]{(byte)b};
        this.writeX(ba, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.writeX(b, off, len);
    }

    private void writeX(byte[] b, int off, int len) {
        byte[] newbuf = new byte[(int)this.offset_ - 1 + len + this.blob_.dataOffset_];
        System.arraycopy(this.blob_.binaryString_, 0, newbuf, 0, (int)this.offset_ - 1 + this.blob_.dataOffset_);
        this.blob_.binaryString_ = newbuf;
        int i = 0;
        while (i < len) {
            this.blob_.binaryString_[(int)this.offset_ + this.blob_.dataOffset_ - 1] = b[off + i];
            ++i;
            ++this.offset_;
        }
        this.blob_.binaryStream_ = new ByteArrayInputStream(this.blob_.binaryString_);
        this.blob_.setSqlLength(this.blob_.binaryString_.length - this.blob_.dataOffset_);
    }
}

