/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.IAbsoluteFontSizeValueProvider;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.core.DesignSessionImpl;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

class CSSLengthValueHandler {
    static final String[] ABSOLUTE_FONT_SIZE_CONSTANTS = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"};
    static DimensionValue defaultFontSizeValue = null;
    IAbsoluteFontSizeValueProvider provider;
    DimensionHandle dimensionHandle;

    CSSLengthValueHandler(DimensionHandle dimensionHandle) {
        this.dimensionHandle = dimensionHandle;
        DesignSessionImpl session = dimensionHandle.getElementHandle().getModule().getSession();
        this.provider = session.getPredefinedFontSizeProvider();
    }

    DimensionValue getDefaultFontSizeValue() {
        if (defaultFontSizeValue == null) {
            ElementDefn styleDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement("Style");
            ElementPropertyDefn fontSizePropDefn = (ElementPropertyDefn)styleDefn.getProperty("fontSize");
            Object defaultValue = fontSizePropDefn.getDefault();
            defaultFontSizeValue = defaultValue instanceof DimensionValue ? (DimensionValue)defaultValue : this.provider.getValueOf((String)defaultValue);
        }
        return defaultFontSizeValue;
    }

    DimensionValue computeRelativeValue(DimensionValue fontSizeValue, DimensionValue relativeValue) {
        assert (CSSLengthValueHandler.isAbsoluteUnit(fontSizeValue.getUnits()));
        if (!CSSLengthValueHandler.isAbsoluteUnit(fontSizeValue.getUnits())) {
            throw new IllegalArgumentException("The argument \"fontSizeValue\" should be absolute.");
        }
        if (relativeValue == null) {
            throw new IllegalArgumentException("The argument \"relativeValue\" should not be null.");
        }
        if (CSSLengthValueHandler.isAbsoluteUnit(relativeValue.getUnits())) {
            return relativeValue;
        }
        if ("em".equals(relativeValue.getUnits())) {
            return new DimensionValue(fontSizeValue.getMeasure() * relativeValue.getMeasure(), fontSizeValue.getUnits());
        }
        if ("ex".equals(relativeValue.getUnits())) {
            return new DimensionValue(fontSizeValue.getMeasure() * relativeValue.getMeasure() / 2.0, fontSizeValue.getUnits());
        }
        if ("%".equals(relativeValue.getUnits())) {
            return new DimensionValue(fontSizeValue.getMeasure() * relativeValue.getMeasure() / 100.0, fontSizeValue.getUnits());
        }
        assert (false);
        return null;
    }

    static boolean isAbsoluteUnit(String unit) {
        return DimensionUtil.isAbsoluteUnit(unit) || "px".equalsIgnoreCase(unit);
    }
}

