/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.io.IOException;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.toc.ITOCConstants;
import org.eclipse.birt.report.engine.toc.ITOCWriter;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCEntry;
import org.eclipse.birt.report.engine.toc.TOCWriter;
import org.eclipse.birt.report.engine.toc.document.MemTOCWriter;

public class TOCBuilder
implements ITOCConstants {
    private ITOCWriter writer;
    int nextChildId;

    public TOCBuilder() {
        this.writer = new MemTOCWriter();
    }

    public TOCBuilder(ITOCWriter writer) throws IOException {
        this.writer = writer == null ? new MemTOCWriter() : writer;
    }

    public TOCBuilder(ExecutionContext context) throws IOException {
        ReportDocumentWriter document = context.getReportDocWriter();
        if (document != null) {
            IDocArchiveWriter archive = document.getArchive();
            this.writer = new TOCWriter(archive);
        } else {
            this.writer = new MemTOCWriter();
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public TOCEntry startGroupEntry(TOCEntry parent, Object tocValue, String bookmark, String hiddenFormats, long elementId) {
        return this.startEntry(parent, tocValue, bookmark, hiddenFormats, true, elementId);
    }

    public void closeGroupEntry(TOCEntry group) {
        this.closeEntry(group);
    }

    public TOCEntry startEntry(TOCEntry parent, Object tocValue, String bookmark, String hiddenFormats, long elementId) {
        return this.startEntry(parent, tocValue, bookmark, hiddenFormats, false, elementId);
    }

    public TOCEntry startEntry(TOCEntry parent, Object tocValue, String bookmark, long elementId) {
        return this.startEntry(parent, tocValue, bookmark, null, false, elementId);
    }

    public TOCEntry startDummyEntry(TOCEntry parent, String hiddenFormats) {
        return this.startEntry(parent, null, null, hiddenFormats, false, -1L);
    }

    public TOCEntry createEntry(TOCEntry parent, Object tocValue, String bookmark, long elementId) {
        TOCEntry entry = this.startEntry(parent, tocValue, bookmark, null, false, elementId);
        this.closeEntry(entry);
        return entry;
    }

    private String getNextId(TOCEntry parent) {
        if (parent == null) {
            return "__TOC_" + this.nextChildId++;
        }
        return parent.getNodeId() + "_" + parent.nextChildId++;
    }

    private TOCEntry startEntry(TOCEntry parent, Object tocValue, String bookmark, String hiddenFormats, boolean isGroup, long elementId) {
        TOCEntry entry = new TOCEntry();
        entry.setParent(parent);
        entry.setNodeId(this.getNextId(parent));
        entry.setBookmark(bookmark == null ? entry.getNodeId() : bookmark);
        entry.setHiddenFormats(hiddenFormats);
        entry.setGroup(isGroup);
        entry.setTOCValue(tocValue);
        entry.setElementId(elementId);
        if (tocValue != null) {
            this.writeTOCEntry(entry);
        }
        return entry;
    }

    public void closeEntry(TOCEntry entry) {
        if (entry.getTreeNode() != null) {
            try {
                this.writer.closeTOCEntry(entry);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeTOCEntry(TOCEntry entry) {
        TOCEntry parent = entry.getParent();
        if (parent != null && parent.getTreeNode() == null) {
            parent.setTOCValue("");
            this.writeTOCEntry(parent);
        }
        try {
            this.writer.startTOCEntry(entry);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ITreeNode getTOCTree() {
        return this.writer.getTree();
    }
}

