/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.table;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.elements.table.LayoutRow;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;
import org.eclipse.birt.report.model.elements.Cell;

public class LayoutCell {
    protected static final LayoutCell EMPTY_CELL = new LayoutCell(0);
    public static final int CELL_EMPTY = 0;
    public static final int CELL_USED = 1;
    public static final int DROP_SPANNED = 2;
    private int cellId = 0;
    private boolean isEffectualDrop = false;
    private int status;
    private Cell content;
    private int colSpanOffset;
    private int rowSpanOffset;
    private int rowSpanForDrop;
    private LayoutRow container = null;

    LayoutCell(LayoutRow container, int cellId, Cell content, int rowSpanOffset, int colSpanOffset, boolean isEffectualDrop) {
        this(cellId, 1);
        this.container = container;
        this.content = content;
        this.colSpanOffset = colSpanOffset;
        this.rowSpanOffset = rowSpanOffset;
        this.isEffectualDrop = isEffectualDrop;
    }

    LayoutCell(LayoutRow container, int cellId, Cell content, int rowSpanOffset, int colSpanOffset) {
        this(cellId, 2);
        this.container = container;
        this.content = content;
        this.colSpanOffset = colSpanOffset;
        this.rowSpanOffset = rowSpanOffset;
        this.isEffectualDrop = true;
    }

    private LayoutCell(int cellId, int status) {
        this.cellId = cellId;
        this.status = status;
    }

    private LayoutCell(int status) {
        this.status = status;
    }

    public boolean isUsed() {
        return this.status != 0;
    }

    public boolean isDropSpanned() {
        return this.status == 2;
    }

    protected Cell getContent() {
        return this.content;
    }

    public int getColumnSpanOffset() {
        return this.colSpanOffset;
    }

    public int getRowSpanOffset() {
        return this.rowSpanOffset;
    }

    public String getLayoutString() {
        StringBuilder sb = new StringBuilder();
        switch (this.status) {
            case 1: {
                sb.append(this.cellId);
                break;
            }
            case 2: {
                sb.append(this.cellId);
                sb.append('.');
                break;
            }
            default: {
                sb.append(0);
            }
        }
        sb.append("     ");
        return sb.toString();
    }

    public boolean isEffectualDrop() {
        return this.isEffectualDrop;
    }

    protected boolean isCellStartPosition() {
        return this.colSpanOffset == 0 && this.rowSpanOffset == 0;
    }

    public CellHandle getCell() {
        return this.getCellRegardlessStartPosition();
    }

    protected CellHandle getCellRegardlessStartPosition() {
        if (!this.isUsed()) {
            return null;
        }
        LayoutTable table = this.container.getContainer().tableContainer;
        if (table.getModule() != null) {
            return (CellHandle)this.content.getHandle(table.getModule());
        }
        assert (false);
        return null;
    }

    protected int getCellId() {
        return this.cellId;
    }

    protected boolean isEmptyContent() {
        return this.isUsed() && this.content.getSlot(0).getCount() == 0;
    }

    protected boolean isDropSet() {
        if (this.content == null) {
            return false;
        }
        String drop = (String)this.content.getLocalProperty(null, "drop");
        return drop != null && !"none".equalsIgnoreCase(drop);
    }

    public int getRowSpanForDrop() {
        return this.rowSpanForDrop;
    }

    protected void setRowSpanForDrop(int rowSpanForDrop) {
        this.rowSpanForDrop = rowSpanForDrop;
    }

    protected void setEffectualDrop(boolean isEffectualDrop) {
        this.isEffectualDrop = isEffectualDrop;
    }

    protected int getColumnPosn() {
        int i = 0;
        while (i < this.container.getColumnCount()) {
            if (this.container.getLayoutCell(i) == this) {
                return i + 1;
            }
            ++i;
        }
        assert (false);
        return -1;
    }

    protected LayoutRow getLayoutContainer() {
        return this.container;
    }
}

