/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.text.Collator;
import java.util.TreeMap;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;

public abstract class FormatAdapter {
    public static final String NONE = Messages.getString((String)"FormatAdapter.DisplayName.None");
    public static final TreeMap<String, ULocale> LOCALE_TABLE = new TreeMap(Collator.getInstance());

    static {
        ULocale[] locales = ULocale.getAvailableLocales();
        if (locales != null) {
            int i = 0;
            while (i < locales.length) {
                ULocale locale = locales[i];
                if (locale != null) {
                    LOCALE_TABLE.put(locale.getDisplayName(), locale);
                }
                ++i;
            }
        }
    }

    public static String getLocaleDisplayName(ULocale locale) {
        if (locale == null) {
            return NONE;
        }
        return locale.getDisplayName();
    }

    public static String[] getLocaleDisplayNames() {
        String[] oldNames = LOCALE_TABLE.keySet().toArray(new String[0]);
        String[] newNames = new String[oldNames.length + 1];
        newNames[0] = NONE;
        System.arraycopy(oldNames, 0, newNames, 1, oldNames.length);
        return newNames;
    }

    public static ULocale getLocaleByDisplayName(String localeDisplayName) {
        if (NONE.equals(localeDisplayName) || localeDisplayName == null) {
            return null;
        }
        return LOCALE_TABLE.get(localeDisplayName);
    }

    public static String[][] getChoiceArray(String structName, String popertyName) {
        String[][] ca;
        IChoiceSet set = ChoiceSetFactory.getStructChoiceSet(structName, popertyName);
        IChoice[] choices = set.getChoices();
        if (choices.length > 0) {
            ca = new String[choices.length][2];
            int i = 0;
            int j = 0;
            while (i < choices.length) {
                ca[j][0] = choices[i].getDisplayName();
                ca[j][1] = choices[i].getName();
                ++j;
                ++i;
            }
        } else {
            ca = new String[0][0];
        }
        return ca;
    }

    public abstract String[][] initChoiceArray();

    public abstract String[] getFormatTypes(ULocale var1);

    public abstract int getIndexOfCategory(String var1);

    public abstract String getDisplayName4Category(String var1);

    public abstract String getCategory4DisplayName(String var1);

    public abstract String getPattern4DisplayName(String var1, ULocale var2);
}

