/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.birt.report.data.oda.jdbc.CallStatement;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Ignore tests that cannot be executed in JUnit plugin mode")
public class CallStatementTest {
    private Connection conn = null;
    private CallStatement stmt = null;

    @Before
    public void callStatementSetUp() throws Exception {
        TestUtil.createTestData();
        TestUtil.createTestProcedure();
        this.conn = TestUtil.openConnection();
        this.stmt = (CallStatement)this.conn.newQuery("org.eclipse.birt.report.data.oda.jdbc.SPSelectDataSet");
        TestUtil.openJDBCConnection();
    }

    @Test
    public void testGetMetaData() throws Exception {
        try {
            this.stmt.getMetaData();
            Assert.fail((String)"Should throw DriverException");
        }
        catch (OdaException e) {
            Assert.assertTrue((boolean)(e instanceof JDBCException));
        }
    }

    @Test
    public void testSetBigDecimalintBigDecimal() throws Exception {
        this.stmt.prepare("call testProc0(?,?)");
        this.stmt.setBigDecimal(1, new BigDecimal("1111"));
        this.stmt.registerOutParameter(2, 3);
        this.stmt.executeQuery();
        assert (this.stmt.getBigDecimal(2).equals(new BigDecimal("2222")));
    }

    @Test
    public void testSetDateintDate() throws Exception {
        this.stmt.prepare("call testProc1(?,?)");
        this.stmt.setDate(1, Date.valueOf("2000-01-01"));
        this.stmt.registerOutParameter(2, 91);
        this.stmt.executeQuery();
        assert (this.stmt.getDate(2).equals(Date.valueOf("2000-01-02")));
    }

    @Test
    public void testSetDoubleintdouble() throws Exception {
        this.stmt.prepare("call testProc2(?,?)");
        this.stmt.setDouble(1, 0.0);
        this.stmt.registerOutParameter(2, 8);
        this.stmt.executeQuery();
        assert (this.stmt.getDouble(2) == 1.0);
    }

    @Test
    public void testSetIntintint() throws Exception {
        this.stmt.prepare("call testProc3(?,?)");
        this.stmt.setInt(1, 0);
        this.stmt.registerOutParameter(2, -6);
        this.stmt.executeQuery();
        assert (this.stmt.getInt(2) == 1);
    }

    @Test
    public void testSetStringintString() throws Exception {
        this.stmt.prepare("call testProc4(?,?)");
        this.stmt.setString(1, "00");
        this.stmt.registerOutParameter(2, 12);
        this.stmt.executeQuery();
        assert (this.stmt.getString(2).equals("11"));
    }

    @Test
    public void testSetTimeintTime() throws Exception {
        this.stmt.prepare("call testProc5(?,?)");
        this.stmt.setTime(1, Time.valueOf("12:00:00"));
        this.stmt.registerOutParameter(2, 92);
        this.stmt.executeQuery();
        assert (this.stmt.getTime(2).equals(Time.valueOf("12:00:01")));
    }

    @Test
    public void testSetTimestampintTimestamp() throws Exception {
        this.stmt.prepare("call testProc6(?,?)");
        this.stmt.setTimestamp(1, Timestamp.valueOf("2000-01-01 12:00:00.0000"));
        this.stmt.registerOutParameter(2, 93);
        this.stmt.executeQuery();
        assert (this.stmt.getTimestamp(2).equals(Timestamp.valueOf("2000-01-02 12:00:00.0000")));
    }

    @Test
    public void testGetParameterMetaData() throws Exception {
        this.stmt.prepare("call testProc0(?,?)");
        IParameterMetaData md = this.stmt.getParameterMetaData();
        Assert.assertNotNull((Object)md);
    }

    @Test
    public void testClearInParameters() throws Exception {
        this.stmt.prepare("call testProc3(?,?)");
        this.stmt.setInt(1, 0);
        this.stmt.registerOutParameter(2, 4);
        this.stmt.executeQuery();
        this.stmt.clearInParameters();
        try {
            this.stmt.executeQuery();
            Assert.fail();
        }
        catch (JDBCException jDBCException) {
            // empty catch block
        }
    }
}

