/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.expression.InvalidExpression;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ExpressionCompilerTest {
    private ExpressionCompiler compiler;
    private ArrayList aggrExprs = new ArrayList();
    private AggregateRegistry aggrReg = new AggregateRegistry(){

        public int register(AggregateExpression aggregationExpr) throws DataException {
            ExpressionCompilerTest.this.aggrExprs.add(aggregationExpr);
            return ExpressionCompilerTest.this.aggrExprs.size() - 1;
        }
    };
    ScriptContext cx;
    Scriptable scope;

    @Before
    public void expressionCompilerSetUp() throws Exception {
        this.compiler = new ExpressionCompiler();
        this.cx = new ScriptContext();
        this.cx.compile("javascript", null, 0, "1 == 1;");
        this.scope = Context.getCurrentContext().initStandardObjects();
    }

    @After
    public void expressionCompilerTearDown() throws Exception {
        this.cx.close();
    }

    @Test
    public void testDirectColRefByName() throws Exception {
        CompiledExpression expr = this.compiler.compile("row.col", null, this.cx);
        int type = expr.getType();
        Assert.assertEquals((long)type, (long)1L);
        String strColumnName = ((ColumnReferenceExpression)expr).getColumnName();
        Assert.assertEquals((Object)"col", (Object)strColumnName);
        expr = this.compiler.compile("r.col", null, this.cx);
        type = expr.getType();
        Assert.assertEquals((long)type, (long)3L);
        expr = this.compiler.compile("row_a_boat.col", null, this.cx);
        type = expr.getType();
        Assert.assertEquals((long)type, (long)3L);
        expr = this.compiler.compile("row.col.prop", null, this.cx);
        type = expr.getType();
        Assert.assertEquals((long)type, (long)3L);
    }

    @Test
    public void testDirectColRefByName1() throws Exception {
        CompiledExpression expr = this.compiler.compile("row[\"col\"]", null, this.cx);
        int type = expr.getType();
        Assert.assertEquals((long)type, (long)1L);
        String strColumnName = ((ColumnReferenceExpression)expr).getColumnName();
        Assert.assertEquals((Object)"col", (Object)strColumnName);
    }

    @Test
    public void testDirectColRefByIndex() throws Exception {
        CompiledExpression expr = this.compiler.compile("row[1]", null, this.cx);
        int type = expr.getType();
        Assert.assertEquals((long)type, (long)1L);
        Assert.assertEquals((long)((ColumnReferenceExpression)expr).getColumnindex(), (long)1L);
    }

    @Test
    public void testAggregateExpression() throws Exception {
        this.aggrExprs.clear();
        CompiledExpression expr = this.compiler.compile("Total.Sum( row.x )", this.aggrReg, this.cx);
        Assert.assertTrue((this.aggrExprs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.aggrExprs.get(0) == expr ? 1 : 0) != 0);
        Assert.assertTrue((expr.getType() == 2 ? 1 : 0) != 0);
        AggregateExpression aggr = (AggregateExpression)expr;
        Assert.assertTrue((aggr.getArguments().size() == 1 ? 1 : 0) != 0);
        CompiledExpression arg1 = (CompiledExpression)aggr.getArguments().get(0);
        Assert.assertTrue((arg1.getType() == 1 ? 1 : 0) != 0);
        this.aggrExprs.clear();
        expr = this.compiler.compile("Total.Sum( row[1], row.y > row.z, \"Group1\" )", this.aggrReg, this.cx);
        Assert.assertTrue((this.aggrExprs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.aggrExprs.get(0) == expr ? 1 : 0) != 0);
        Assert.assertTrue((expr.getType() == 2 ? 1 : 0) != 0);
        aggr = (AggregateExpression)expr;
        Assert.assertTrue((aggr.getArguments().size() == 3 ? 1 : 0) != 0);
        arg1 = (CompiledExpression)aggr.getArguments().get(0);
        Assert.assertTrue((arg1.getType() == 1 ? 1 : 0) != 0);
        CompiledExpression arg2 = (CompiledExpression)aggr.getArguments().get(1);
        Assert.assertTrue((arg2.getType() == 3 ? 1 : 0) != 0);
        CompiledExpression arg3 = (CompiledExpression)aggr.getArguments().get(0);
        Assert.assertTrue((arg3.getType() == 1 ? 1 : 0) != 0);
        this.aggrExprs.clear();
        expr = this.compiler.compile("Total.Sum( Total.Max(row.y), null, 1 )", this.aggrReg, this.cx);
        Assert.assertTrue((this.aggrExprs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((this.aggrExprs.get(0) == expr || this.aggrExprs.get(1) == expr ? 1 : 0) != 0);
        Assert.assertTrue((expr.getType() == 2 ? 1 : 0) != 0);
        aggr = (AggregateExpression)expr;
        Assert.assertTrue((aggr.getArguments().size() == 3 ? 1 : 0) != 0);
        arg1 = (CompiledExpression)aggr.getArguments().get(0);
        Assert.assertTrue((this.aggrExprs.get(0) == arg1 || this.aggrExprs.get(1) == arg1 ? 1 : 0) != 0);
        Assert.assertTrue((arg1.getType() == 2 ? 1 : 0) != 0);
        arg2 = (CompiledExpression)aggr.getArguments().get(1);
        Assert.assertTrue((arg2.getType() == 4 ? 1 : 0) != 0);
        arg3 = (CompiledExpression)aggr.getArguments().get(2);
        Assert.assertTrue((arg3.getType() == 4 ? 1 : 0) != 0);
        this.aggrExprs.clear();
        expr = this.compiler.compile(" row[\"x\"] / Total.Sum( 1 )", this.aggrReg, this.cx);
        Assert.assertTrue((this.aggrExprs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((expr.getType() == 3 ? 1 : 0) != 0);
        this.aggrExprs.clear();
        expr = this.compiler.compile("Total.MovingAve( row.x, myfunc(), null, 1 )", this.aggrReg, this.cx);
        Assert.assertTrue((this.aggrExprs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.aggrExprs.get(0) == expr ? 1 : 0) != 0);
        Assert.assertTrue((expr.getType() == 2 ? 1 : 0) != 0);
        aggr = (AggregateExpression)expr;
        Assert.assertTrue((aggr.getArguments().size() == 4 ? 1 : 0) != 0);
        arg1 = (CompiledExpression)aggr.getArguments().get(0);
        Assert.assertTrue((arg1.getType() == 1 ? 1 : 0) != 0);
        arg2 = (CompiledExpression)aggr.getArguments().get(1);
        Assert.assertTrue((arg2.getType() == 3 ? 1 : 0) != 0);
        arg3 = (CompiledExpression)aggr.getArguments().get(2);
        Assert.assertTrue((arg3.getType() == 4 ? 1 : 0) != 0);
        CompiledExpression arg4 = (CompiledExpression)aggr.getArguments().get(3);
        Assert.assertTrue((arg4.getType() == 4 ? 1 : 0) != 0);
        this.aggrExprs.clear();
        expr = this.compiler.compile("Total.Invalid( row.x )", this.aggrReg, this.cx);
        Assert.assertTrue((boolean)(expr instanceof InvalidExpression));
    }

    @Test
    public void testMultiExpression() throws Exception {
        this.aggrExprs.clear();
        CompiledExpression expr = this.compiler.compile("a=1; b=a+1; b+1;", this.aggrReg, this.cx);
        Assert.assertEquals((long)expr.getType(), (long)3L);
        Assert.assertTrue((this.aggrExprs.size() == 0 ? 1 : 0) != 0);
        Object result = expr.evaluate(this.cx, this.scope);
        Assert.assertEquals((Object)DataTypeUtil.convert((Object)result, (int)2), (Object)new Integer(3));
        this.aggrExprs.clear();
        expr = this.compiler.compile("a=true; if ( ! a && Total.Count() > 0 ) b=Total.Sum(row.x); else b=1 ; b", this.aggrReg, this.cx);
        Assert.assertEquals((long)expr.getType(), (long)3L);
        result = expr.evaluate(this.cx, this.scope);
        Assert.assertEquals((Object)DataTypeUtil.convert((Object)result, (int)2), (Object)new Integer(1));
        Assert.assertTrue((this.aggrExprs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((AggregateExpression)this.aggrExprs.get(0)).getAggregation().getName().equalsIgnoreCase("COUNT"));
        Assert.assertTrue((((AggregateExpression)this.aggrExprs.get(0)).getArguments().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((AggregateExpression)this.aggrExprs.get(1)).getAggregation().getName().equalsIgnoreCase("SUM"));
        Assert.assertTrue((((AggregateExpression)this.aggrExprs.get(1)).getArguments().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testSCR75905() {
        ExpressionCompiler compiler = new ExpressionCompiler();
        CompiledExpression expr = compiler.compile("", null, this.cx);
        Assert.assertTrue((boolean)(expr instanceof InvalidExpression));
    }
}

