/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfStructureElement;
import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.LocalProperties;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;
import org.eclipse.birt.report.engine.nLayout.area.style.BackgroundImageInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.BorderInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.BoxStyle;
import org.eclipse.birt.report.engine.util.ResourceLocatorWrapper;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.core.Module;
import org.w3c.dom.css.CSSValue;

public abstract class ContainerArea
extends AbstractArea
implements IContainerArea {
    public static final String PDF_VERTICAL_TAB = "PdfEmitter.VerticalTab";
    protected transient LocalProperties localProperties = LocalProperties.DEFAULT;
    protected BoxStyle boxStyle = BoxStyle.DEFAULT;
    protected transient int maxAvaWidth = 0;
    protected transient int currentBP = 0;
    protected transient int currentIP = 0;
    protected transient int specifiedHeight = 0;
    protected transient int specifiedWidth = 0;
    protected transient boolean canShrink = false;
    protected transient CSSValue textAlign = null;
    protected transient int textIndent = 0;
    protected boolean needClip;
    protected ArrayList<IArea> children = new ArrayList();
    protected transient boolean isInlineStacking = false;
    protected transient boolean hasStyle = true;
    protected transient IContent content;
    protected transient LayoutContext context;
    protected transient boolean isInInlineStacking = false;
    protected transient boolean first = true;
    protected transient SplitTrackingData splitTracking = null;
    PdfStructureElement structureElement;
    protected transient boolean finished = false;
    protected CSSValue pageBreakAfter = null;
    protected CSSValue pageBreakBefore = null;
    protected CSSValue pageBreakInside = null;
    protected boolean isChildrenRemoved = false;

    public void setArtifact() {
        if (this.splitTracking == null) {
            this.splitTracking = new SplitTrackingData();
            this.splitTracking.artifact = true;
        }
    }

    public boolean isArtifact() {
        if (this.splitTracking == null) {
            return false;
        }
        return this.splitTracking.artifact;
    }

    protected void setPreviousPart(ContainerArea previousPart) {
        if (this.splitTracking == null) {
            this.splitTracking = new SplitTrackingData();
        }
        previousPart.splitTracking = new SplitTrackingData();
        if (this.splitTracking.partNumber == 1) {
            this.splitTracking.firstPart = previousPart;
        } else {
            previousPart.splitTracking.firstPart = this.splitTracking.firstPart;
        }
        previousPart.splitTracking.partNumber = this.splitTracking.firstPart.splitTracking.lastPartNumber;
        this.splitTracking.partNumber = this.splitTracking.firstPart.splitTracking.lastPartNumber = (short)(this.splitTracking.firstPart.splitTracking.lastPartNumber + 1);
    }

    public boolean isFirstPart() {
        if (this.splitTracking == null) {
            return true;
        }
        return this.splitTracking.partNumber == 1;
    }

    public ContainerArea getFirstPart() {
        if (this.splitTracking == null) {
            return null;
        }
        return this.splitTracking.firstPart;
    }

    public short getLastPartNumber() {
        if (this.splitTracking == null) {
            return 1;
        }
        return this.splitTracking.lastPartNumber;
    }

    public PdfStructureElement getStructureElement() {
        return this.structureElement;
    }

    public void setStructureElement(PdfStructureElement structureElement) throws BirtException {
        if (!this.isFirstPart()) {
            throw new BirtException("Can only store a PdfStructureElement for the first part of a split Area");
        }
        this.structureElement = structureElement;
    }

    public ContainerArea(ContainerArea parent, LayoutContext context, IContent content) {
        this.parent = parent;
        this.context = context;
        this.content = content;
        this.first = true;
        this.finished = false;
    }

    ContainerArea() {
    }

    ContainerArea(ContainerArea area) {
        super(area);
        this.first = area.first;
        this.boxStyle = area.getBoxStyle();
        this.needClip = area.needClip();
        this.hasStyle = area.hasStyle;
        this.localProperties = area.localProperties;
        this.content = area.content;
        this.context = area.context;
        this.specifiedHeight = area.specifiedHeight;
        this.specifiedWidth = area.specifiedWidth;
    }

    public boolean autoPageBreak() throws BirtException {
        if (this.context.isFixedLayout() && this.specifiedHeight > 0 && this.specifiedHeight + this.parent.getAbsoluteBP() <= this.context.getMaxBP()) {
            return false;
        }
        if (this.parent != null) {
            return this.parent.autoPageBreak();
        }
        return false;
    }

    public int getAbsoluteBP() {
        if (this.parent != null) {
            return this.currentBP + this.getOffsetY() + this.parent.getAbsoluteBP();
        }
        return this.currentBP;
    }

    public int getMaxAvaHeight() {
        if (this.parent != null) {
            return this.getContentHeight(this.parent.getMaxAvaHeight());
        }
        return this.context.getMaxBP();
    }

    public int getCurrentBP() {
        return this.currentBP;
    }

    public void setCurrentBP(int currentBP) {
        this.currentBP = currentBP;
    }

    public void setCurrentIP(int currentIP) {
        this.currentIP = currentIP;
    }

    public int getCurrentIP() {
        return this.currentIP;
    }

    public void setMaxAvaWidth(int maxAvaWidth) {
        this.maxAvaWidth = maxAvaWidth;
    }

    public int getMaxAvaWidth() {
        return this.maxAvaWidth;
    }

    public IContent getContent() {
        return this.content;
    }

    public int getSpecifiedHeight() {
        return this.specifiedHeight;
    }

    public int getSpecifiedWidth() {
        return this.specifiedWidth;
    }

    public boolean isCanShrink() {
        return this.canShrink;
    }

    public CSSValue getTextAlign() {
        return this.textAlign;
    }

    public int getTextIndent() {
        return this.textIndent;
    }

    public void setInlineStacking(boolean isInlineStacking) {
        this.isInlineStacking = isInlineStacking;
    }

    public boolean isInlineStacking() {
        return this.isInlineStacking;
    }

    @Override
    public Iterator<IArea> getChildren() {
        return this.children.iterator();
    }

    @Override
    public void addChild(IArea area) {
        this.children.add(area);
    }

    public IArea getChild(int index) {
        if (index >= 0 && index < this.children.size()) {
            return this.children.get(index);
        }
        return null;
    }

    public void addChild(int index, IArea area) {
        this.children.add(index, area);
    }

    public int indexOf(IArea area) {
        return this.children.indexOf(area);
    }

    public void removeAll() {
        this.children.clear();
    }

    public void removeChild(IArea area) {
        this.children.remove(area);
    }

    @Override
    public void accept(IAreaVisitor visitor) {
        visitor.visitContainer(this);
    }

    @Override
    public int getChildrenCount() {
        return this.children.size();
    }

    @Override
    public boolean needClip() {
        return this.needClip;
    }

    @Override
    public void setNeedClip(boolean needClip) {
        this.needClip = needClip;
    }

    @Override
    public BoxStyle getBoxStyle() {
        return this.boxStyle;
    }

    public void setBoxStyle(BoxStyle boxStyle) {
        this.boxStyle = boxStyle;
    }

    public CSSValue getPageBreakAfter() {
        return this.pageBreakAfter;
    }

    public void setPageBreakAfter(CSSValue pageBreakAfter) {
        this.pageBreakAfter = pageBreakAfter;
    }

    public CSSValue getPageBreakBefore() {
        return this.pageBreakBefore;
    }

    public void setPageBreakBefore(CSSValue pageBreakBefore) {
        this.pageBreakBefore = pageBreakBefore;
    }

    public CSSValue getPageBreakInside() {
        return this.pageBreakInside;
    }

    public void setPageBreakInside(CSSValue pageBreakInside) {
        this.pageBreakInside = pageBreakInside;
    }

    public abstract void close() throws BirtException;

    public abstract void initialize() throws BirtException;

    public abstract SplitResult splitLines(int var1) throws BirtException;

    public abstract SplitResult split(int var1, boolean var2) throws BirtException;

    public void relayout() {
    }

    protected void checkDisplayNone() {
        if (this.context.isDisplayNone()) {
            int aHeight = this.getAllocatedHeight();
            this.parent.setCurrentBP(this.parent.currentBP - aHeight);
            this.height = 0;
        }
    }

    protected void updateBackgroundImage() {
        BackgroundImageInfo bgi = this.boxStyle.getBackgroundImage();
        Image img = null;
        if (bgi != null && (img = bgi.getImageInstance()) != null) {
            int resolutionX = img.getDpiX();
            int resolutionY = img.getDpiY();
            if (resolutionX == 0 || resolutionY == 0) {
                resolutionX = 96;
                resolutionY = 96;
            }
            float imageWidth = img.getPlainWidth() / (float)resolutionX * 72.0f;
            float imageHeight = img.getPlainHeight() / (float)resolutionY * 72.0f;
            if (this.content != null) {
                IStyle style = this.content.getComputedStyle();
                int ox = this.getDimensionValue(style.getProperty(51), this.width - (int)(imageWidth * 1000.0f));
                int oy = this.getDimensionValue(style.getProperty(62), this.height - (int)(imageHeight * 1000.0f));
                bgi.setXOffset(ox);
                bgi.setYOffset(oy);
            }
        }
    }

    public int getLineHeight() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getComputedStyle();
            return PropertyUtil.getDimensionValueConsiderDpi(contentStyle.getProperty(64), this.content);
        }
        return 0;
    }

    protected void calculateSpecifiedWidth(IContent content) {
        if (content == null) {
            return;
        }
        DimensionType width = content.getWidth();
        if (width != null) {
            this.specifiedWidth = this.parent != null ? this.getDimensionValue(content, content.getWidth(), this.parent.getWidth()) : this.getDimensionValue(content, content.getWidth());
        }
    }

    protected void calculateSpecifiedHeight(IContent content) {
        if (content == null) {
            return;
        }
        DimensionType height = content.getHeight();
        if (height != null) {
            this.specifiedHeight = this.getDimensionValue(content, height);
        }
    }

    @Override
    public void setAllocatedY(int ay) {
        this.y = this.hasStyle ? ay + this.localProperties.getMarginTop() : ay;
    }

    @Override
    public void setAllocatedX(int ax) {
        this.x = this.hasStyle ? ax + this.localProperties.getMarginLeft() : ax;
    }

    @Override
    public void setAllocatedPosition(int ax, int ay) {
        if (this.hasStyle) {
            this.x = ax + this.localProperties.getMarginLeft();
            this.y = ay + this.localProperties.getMarginTop();
        } else {
            this.x = ax;
            this.y = ay;
        }
    }

    public void setAllocatedHeight(int aHeight) {
        this.height = this.hasStyle ? aHeight - this.localProperties.getMarginBottom() - this.localProperties.getMarginTop() : aHeight;
    }

    public int getContentHeight(int allocatedHeight) {
        if (this.hasStyle) {
            return allocatedHeight - this.localProperties.getPaddingBottom() - this.localProperties.getPaddingTop() - this.localProperties.getMarginTop() - this.localProperties.getMarginBottom() - this.boxStyle.getBottomBorderWidth() - this.boxStyle.getTopBorderWidth();
        }
        return allocatedHeight;
    }

    public int getContentY() {
        if (this.hasStyle) {
            return this.localProperties.getPaddingTop() + this.boxStyle.getTopBorderWidth();
        }
        return 0;
    }

    public int getContentX() {
        if (this.hasStyle) {
            return this.localProperties.getPaddingLeft() + this.boxStyle.getLeftBorderWidth();
        }
        return 0;
    }

    public int getMaxYPosition() {
        if (this.hasStyle) {
            return this.y + this.height + this.localProperties.getMarginBottom();
        }
        return this.y + this.height;
    }

    public int getMinYPosition() {
        return this.y + this.height;
    }

    public void setAllocatedWidth(int aWidth) {
        if (this.hasStyle) {
            int totalMarginWidth = this.localProperties.getMarginLeft() + this.localProperties.getMarginRight();
            if (totalMarginWidth >= aWidth) {
                this.localProperties.setMarginLeft(0);
                this.localProperties.setMarginRight(0);
                this.width = aWidth;
            } else {
                this.width = aWidth - totalMarginWidth;
            }
        } else {
            this.width = aWidth;
        }
    }

    public void setContentHeight(int cHeight) {
        this.height = this.hasStyle ? cHeight + this.localProperties.getPaddingBottom() + this.localProperties.getPaddingTop() + this.boxStyle.getBottomBorderWidth() + this.boxStyle.getTopBorderWidth() : cHeight;
    }

    public void setContentWidth(int cWidth) {
        this.width = this.hasStyle ? cWidth + this.localProperties.getPaddingLeft() + this.localProperties.getPaddingRight() + this.boxStyle.getLeftBorderWidth() + this.boxStyle.getRightBorderWidth() : cWidth;
    }

    @Override
    public int getAllocatedX() {
        if (this.hasStyle) {
            return this.x - this.localProperties.getMarginLeft();
        }
        return this.x;
    }

    @Override
    public int getAllocatedY() {
        if (this.hasStyle) {
            return this.y - this.localProperties.getMarginTop();
        }
        return this.y;
    }

    public int getContentWidth() {
        if (this.hasStyle) {
            int totalPaddngWidth = this.localProperties.getPaddingLeft() + this.localProperties.getPaddingRight();
            int totalBorderWidth = this.boxStyle.getLeftBorderWidth() + this.boxStyle.getRightBorderWidth();
            if (this.width <= totalPaddngWidth) {
                this.localProperties.setPaddingLeft(0);
                this.localProperties.setPaddingRight(0);
                return this.width - totalBorderWidth;
            }
            return this.width - totalPaddngWidth - totalBorderWidth;
        }
        return this.width;
    }

    public int getContentHeight() {
        if (this.hasStyle) {
            return this.height - this.boxStyle.getTopBorderWidth() - this.boxStyle.getBottomBorderWidth() - this.localProperties.getPaddingBottom() - this.localProperties.getPaddingTop();
        }
        return this.height;
    }

    @Override
    public int getAllocatedWidth() {
        if (this.hasStyle) {
            return this.width + this.localProperties.getMarginLeft() + this.localProperties.getMarginRight();
        }
        return this.width;
    }

    @Override
    public int getAllocatedHeight() {
        if (this.hasStyle) {
            return this.height + this.localProperties.getMarginBottom() + this.localProperties.getMarginTop();
        }
        return this.height;
    }

    public int getCurrentMaxContentWidth() {
        return this.maxAvaWidth - this.currentIP;
    }

    public boolean isEmpty() {
        return this.children.size() == 0;
    }

    public abstract void update(AbstractArea var1) throws BirtException;

    public abstract void add(AbstractArea var1);

    protected boolean checkPageBreak() throws BirtException {
        boolean ret = false;
        if (!this.isInInlineStacking && this.context.isAutoPageBreak()) {
            int aHeight = this.getAllocatedHeight();
            while (aHeight + this.parent.getAbsoluteBP() - 3000 > this.context.getMaxBP()) {
                if (!this.parent.autoPageBreak()) {
                    return false;
                }
                aHeight = this.getAllocatedHeight();
                ret = true;
            }
        }
        return ret;
    }

    public int getOffsetX() {
        if (this.hasStyle) {
            return this.localProperties.getPaddingLeft() + this.boxStyle.getLeftBorderWidth();
        }
        return 0;
    }

    public int getOffsetY() {
        if (this.hasStyle) {
            return this.localProperties.getPaddingTop() + this.boxStyle.getTopBorderWidth();
        }
        return 0;
    }

    protected int getResolution() {
        return PropertyUtil.getRenderDpi(this.content, this.context.getDpi());
    }

    protected int getDimensionValue(IContent content, DimensionType d) {
        return this.getDimensionValue(content, d, 0);
    }

    protected int getDimensionValue(IContent content, DimensionType d, int referenceLength) {
        return this.getDimensionValue(content, d, 0, referenceLength);
    }

    protected int getDimensionValue(IContent content, DimensionType d, int dpi, int referenceLength) {
        if (d == null) {
            return 0;
        }
        try {
            String units = d.getUnits();
            if (units.equals("pt") || units.equals("cm") || units.equals("mm") || units.equals("pc") || units.equals("in")) {
                double point = d.convertTo("pt") * 1000.0;
                return (int)point;
            }
            if (units.equals("px")) {
                if (dpi == 0) {
                    dpi = this.getResolution();
                }
                double point = d.getMeasure() / (double)dpi * 72000.0;
                return (int)point;
            }
            if (units.equals("%")) {
                double point = (double)referenceLength * d.getMeasure() / 100.0;
                return (int)point;
            }
            if (units.equals("em") || units.equals("ex")) {
                int size = 9000;
                if (content != null) {
                    IStyle style = content.getComputedStyle();
                    CSSValue fontSize = style.getProperty(54);
                    size = this.getDimensionValue(fontSize);
                }
                double point = (double)size * d.getMeasure();
                return (int)point;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
            return 0;
        }
        return 0;
    }

    protected int getDimensionValue(CSSValue value) {
        return this.getDimensionValue(value, 0);
    }

    protected int getDimensionValue(CSSValue value, int referenceLength) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            switch (fv.getPrimitiveType()) {
                case 6: {
                    return (int)((double)(v * 72000.0f) / 2.54);
                }
                case 8: {
                    return (int)(v * 72000.0f);
                }
                case 7: {
                    return (int)((double)(v * 7200.0f) / 2.54);
                }
                case 10: {
                    return (int)(v * 12.0f * 1000.0f);
                }
                case 5: {
                    float dpi = this.getResolution();
                    return (int)(v / dpi * 72000.0f);
                }
                case 9: {
                    return (int)(v * 1000.0f);
                }
                case 1: {
                    return (int)v;
                }
                case 2: {
                    return (int)((double)((float)referenceLength * v) / 100.0);
                }
            }
        }
        return 0;
    }

    protected void validateBoxProperty(IStyle style, int maxWidth, int maxHeight) {
        int leftMargin = this.getDimensionValue(style.getProperty(0), maxWidth);
        int rightMargin = this.getDimensionValue(style.getProperty(1), maxWidth);
        int topMargin = this.getDimensionValue(style.getProperty(6), maxWidth);
        int bottomMargin = this.getDimensionValue(style.getProperty(2), maxWidth);
        int leftPadding = Math.max(0, this.getDimensionValue(style.getProperty(12), maxWidth));
        int rightPadding = Math.max(0, this.getDimensionValue(style.getProperty(16), maxWidth));
        int topPadding = Math.max(0, this.getDimensionValue(style.getProperty(19), maxWidth));
        int bottomPadding = Math.max(0, this.getDimensionValue(style.getProperty(13), maxWidth));
        int leftBorder = Math.max(0, this.getDimensionValue(style.getProperty(59), 0));
        int rightBorder = Math.max(0, this.getDimensionValue(style.getProperty(9), 0));
        int topBorder = Math.max(0, this.getDimensionValue(style.getProperty(35), 0));
        int bottomBorder = Math.max(0, this.getDimensionValue(style.getProperty(10), 0));
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[2] = 16;
        nArray[3] = 12;
        nArray[4] = 9;
        nArray[5] = 59;
        int[] vsStyle = nArray;
        int[] vs = new int[]{rightMargin, leftMargin, rightPadding, leftPadding, rightBorder, leftBorder};
        boolean[] vsConflicted = this.resolveBoxConflict(vs, maxWidth);
        int[] hsStyle = new int[]{2, 6, 13, 19, 10, 35};
        int[] hs = new int[]{bottomMargin, topMargin, bottomPadding, topPadding, bottomBorder, topBorder};
        boolean[] hsConflicted = this.resolveBoxConflict(hs, maxHeight);
        int i = 0;
        while (i < vsStyle.length) {
            if (vsConflicted[i]) {
                style.setProperty(vsStyle[i], new FloatValue(9, (float)vs[i] / 1000.0f));
            }
            ++i;
        }
        i = 0;
        while (i < hsStyle.length) {
            if (hsConflicted[i]) {
                style.setProperty(hsStyle[i], new FloatValue(9, (float)hs[i] / 1000.0f));
            }
            ++i;
        }
    }

    private void resolveConflict(int[] values, int maxTotal, int total, int start, boolean[] conflicted) {
        int length = values.length - start;
        if (length == 0) {
            return;
        }
        assert (length > 0);
        if (total > maxTotal || total < 0) {
            int othersTotal = total;
            if (start == 0 && total > maxTotal) {
                int i = 0;
                while (i < values.length) {
                    if (values[i] >= maxTotal) {
                        othersTotal -= values[i];
                        values[i] = 0;
                        conflicted[i] = true;
                    }
                    ++i;
                }
                if (othersTotal < maxTotal) {
                    return;
                }
            }
            othersTotal -= values[start];
            if (values[start] > 0) {
                values[start] = 0;
                conflicted[start] = true;
            }
            this.resolveConflict(values, maxTotal, othersTotal, start + 1, conflicted);
        }
    }

    protected boolean[] resolveBoxConflict(int[] vs, int max) {
        int vTotal = 0;
        boolean[] conflicted = new boolean[vs.length];
        int i = 0;
        while (i < vs.length) {
            vTotal += vs[i];
            ++i;
        }
        this.resolveConflict(vs, max, vTotal, 0, conflicted);
        return conflicted;
    }

    protected ReportDesignHandle getCurrentDesignHandle() {
        return this.content.getReportContent().getDesign().getReportDesign();
    }

    protected Module getCurrentModule() {
        return this.getCurrentDesignHandle().getModule();
    }

    protected void buildProperties(IContent content, LayoutContext context) {
        Color color;
        IStyle style = content.getComputedStyle();
        this.localProperties = new LocalProperties();
        int maw = this.parent.getMaxAvaWidth();
        this.localProperties.setMarginBottom(this.getDimensionValue(style.getProperty(2), maw));
        this.localProperties.setMarginLeft(this.getDimensionValue(style.getProperty(0), maw));
        this.localProperties.setMarginTop(this.getDimensionValue(style.getProperty(6), maw));
        this.localProperties.setMarginRight(this.getDimensionValue(style.getProperty(1), maw));
        this.localProperties.setPaddingBottom(this.getDimensionValue(style.getProperty(13), maw));
        this.localProperties.setPaddingLeft(this.getDimensionValue(style.getProperty(12), maw));
        this.localProperties.setPaddingTop(this.getDimensionValue(style.getProperty(19), maw));
        this.localProperties.setPaddingRight(this.getDimensionValue(style.getProperty(16), maw));
        if (!this.isInlineStacking) {
            this.pageBreakAfter = style.getProperty(67);
            if (this.pageBreakInside == null) {
                this.pageBreakInside = style.getProperty(52);
            }
            this.pageBreakBefore = style.getProperty(30);
        }
        this.boxStyle = new BoxStyle();
        int borderWidth = this.getDimensionValue(style.getProperty(59), maw);
        if (borderWidth > 0) {
            this.boxStyle.setLeftBorder(new BorderInfo(style.getProperty(57), style.getProperty(65), borderWidth));
        }
        if ((borderWidth = this.getDimensionValue(style.getProperty(9), maw)) > 0) {
            this.boxStyle.setRightBorder(new BorderInfo(style.getProperty(4), style.getProperty(20), borderWidth));
        }
        if ((borderWidth = this.getDimensionValue(style.getProperty(35), maw)) > 0) {
            this.boxStyle.setTopBorder(new BorderInfo(style.getProperty(23), style.getProperty(45), borderWidth));
        }
        if ((borderWidth = this.getDimensionValue(style.getProperty(10), maw)) > 0) {
            this.boxStyle.setBottomBorder(new BorderInfo(style.getProperty(5), style.getProperty(21), borderWidth));
        }
        if ((color = PropertyUtil.getColor(style.getProperty(41))) != null) {
            this.boxStyle.setBackgroundColor(color);
        }
        CSSValue url = style.getProperty(56);
        if (!CSSValueConstants.NONE_VALUE.equals(style.getProperty(56))) {
            ResourceLocatorWrapper rl = null;
            ExecutionContext exeContext = ((ReportContent)content.getReportContent()).getExecutionContext();
            if (exeContext != null) {
                rl = exeContext.getResourceLocator();
            }
            BackgroundImageInfo backgroundImage = new BackgroundImageInfo(this.getImageUrl(url.getCssText()), style.getProperty(24), PropertyUtil.getDimensionValue(style.getProperty(51)), PropertyUtil.getDimensionValue(style.getProperty(62)), 0, 0, rl, this.getCurrentModule(), style.getProperty(58));
            backgroundImage.setImageSize(style);
            this.boxStyle.setBackgroundImage(backgroundImage);
        }
        this.action = content.getHyperlinkAction();
        this.bookmark = content.getBookmark();
    }

    protected void buildLogicContainerProperties(IContent content) {
        IStyle style = content.getStyle();
        if (style != null && !style.isEmpty()) {
            String url;
            this.boxStyle = new BoxStyle();
            IStyle cs = content.getComputedStyle();
            Color color = PropertyUtil.getColor(cs.getProperty(41));
            if (color != null) {
                this.boxStyle.setBackgroundColor(color);
            }
            if ((url = style.getBackgroundImage()) != null) {
                ResourceLocatorWrapper rl = null;
                ExecutionContext exeContext = ((ReportContent)content.getReportContent()).getExecutionContext();
                if (exeContext != null) {
                    rl = exeContext.getResourceLocator();
                }
                BackgroundImageInfo backgroundImage = new BackgroundImageInfo(this.getImageUrl(url), cs.getProperty(24), PropertyUtil.getDimensionValue(cs.getProperty(51)), PropertyUtil.getDimensionValue(cs.getProperty(62)), 0, 0, rl, this.getCurrentModule(), cs.getProperty(58));
                backgroundImage.setImageSize(cs);
                this.boxStyle.setBackgroundImage(backgroundImage);
            }
            if (!this.isInlineStacking) {
                this.pageBreakAfter = cs.getProperty(67);
                if (this.pageBreakInside == null) {
                    this.pageBreakInside = cs.getProperty(52);
                }
                this.pageBreakBefore = cs.getProperty(30);
            }
        } else {
            this.hasStyle = false;
            this.boxStyle = BoxStyle.DEFAULT;
            this.localProperties = LocalProperties.DEFAULT;
        }
        this.bookmark = content.getBookmark();
        this.action = content.getHyperlinkAction();
    }

    public abstract void updateChildrenPosition();

    protected TableArea getTable() {
        ContainerArea p = this.parent;
        while (!(p instanceof TableArea)) {
            p = p.getParent();
        }
        return (TableArea)p;
    }

    @Override
    public ContainerArea deepClone() {
        ContainerArea result = (ContainerArea)this.cloneArea();
        for (AbstractArea abstractArea : this.children) {
            AbstractArea cloneChild = abstractArea.deepClone();
            result.children.add(cloneChild);
            cloneChild.setParent(result);
        }
        return result;
    }

    public boolean isPageBreakInsideAvoid() {
        if (this.pageBreakInside != null) {
            return CSSValueConstants.AVOID_VALUE == this.pageBreakInside;
        }
        return false;
    }

    protected String getImageUrl(String imageUri) {
        URL url;
        String imageUrl = imageUri;
        ReportDesignHandle reportDesign = this.context.getReport().getDesign().getReportDesign();
        if (reportDesign != null && (url = reportDesign.findResource(imageUri, 1, this.context.getReport().getReportContext() == null ? null : this.context.getReport().getReportContext().getAppContext())) != null) {
            imageUrl = url.toExternalForm();
        }
        return imageUrl;
    }

    public boolean isPageBreakAfterAvoid() {
        if (this.localProperties != null && CSSValueConstants.AVOID_VALUE == this.pageBreakAfter) {
            return true;
        }
        IArea lastChild = this.getLastChild();
        if (lastChild instanceof ContainerArea) {
            ContainerArea lastContainer = (ContainerArea)lastChild;
            if (!lastContainer.isInInlineStacking) {
                return lastContainer.isPageBreakAfterAvoid();
            }
        }
        return false;
    }

    public boolean isPageBreakBeforeAvoid() {
        if (this.localProperties != null && CSSValueConstants.AVOID_VALUE == this.pageBreakBefore) {
            return true;
        }
        IArea firstChild = this.getFirstChild();
        if (firstChild instanceof ContainerArea) {
            ContainerArea firstContainer = (ContainerArea)firstChild;
            if (!firstContainer.isInInlineStacking) {
                return firstContainer.isPageBreakBeforeAvoid();
            }
        }
        return false;
    }

    public IArea getLastChild() {
        int size = this.children.size();
        if (size > 0) {
            return this.children.get(size - 1);
        }
        return null;
    }

    public IArea getFirstChild() {
        int size = this.children.size();
        if (size > 0) {
            return this.children.get(0);
        }
        return null;
    }

    protected void flipPositionForRtl() {
        if (this.parent != null) {
            this.setAllocatedX(this.parent.getAllocatedWidth() - this.getAllocatedX() - this.getAllocatedWidth());
        }
    }

    protected void updateContentHeight(int height) {
        this.setContentHeight(height);
    }

    @Override
    public String getHelpText() {
        return null;
    }

    @Override
    public String getTagType() {
        IContent content = this.getContent();
        String tagType = null;
        if (content != null) {
            tagType = content.getTagType();
        }
        return tagType;
    }

    protected static class SplitResult {
        public static final int SPLIT_SUCCEED_WITH_PART = 0;
        public static final int SPLIT_SUCCEED_WITH_NULL = 1;
        public static final int SPLIT_BEFORE_AVOID_WITH_NULL = 2;
        public static SplitResult BEFORE_AVOID_WITH_NULL = new SplitResult(null, 2);
        public static SplitResult SUCCEED_WITH_NULL = new SplitResult(null, 1);
        protected ContainerArea result = null;
        protected int status;

        public SplitResult(ContainerArea result, int status) {
            this.result = result;
            this.status = status;
        }

        public ContainerArea getResult() {
            return this.result;
        }

        public boolean isEmpty() {
            return this.result == null;
        }
    }

    public static class SplitTrackingData {
        public ContainerArea firstPart = null;
        public short partNumber = 1;
        public short lastPartNumber = 1;
        public boolean artifact = false;
    }
}

