/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.index.v1;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.content.impl.BookmarkContent;
import org.eclipse.birt.report.engine.internal.index.IDocumentIndexReader;

public class DocumentIndexReaderV1
implements IDocumentIndexReader,
ReportDocumentConstants {
    private HashMap<String, Long> bookmarks;
    private HashMap<String, Long> reportlets;
    private HashMap<String, Long> pageNumbers;

    public DocumentIndexReaderV1(HashMap<String, Long> bookmarks, HashMap<String, Long> reportlets, HashMap<String, Long> pageNumbers) throws IOException {
        this.bookmarks = bookmarks;
        this.reportlets = reportlets;
        this.pageNumbers = pageNumbers;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void close() {
    }

    @Override
    public long getOffsetOfBookmark(String bookmark) throws IOException {
        Long offset;
        if (this.bookmarks != null && (offset = this.bookmarks.get(bookmark)) != null) {
            return offset;
        }
        return -1L;
    }

    @Override
    public long getOffsetOfInstance(String instanceId) throws IOException {
        Long offset;
        if (this.reportlets != null && (offset = this.reportlets.get(instanceId)) != null) {
            return offset;
        }
        return -1L;
    }

    @Override
    public long getPageOfBookmark(String bookmark) throws IOException {
        Long pageNumber;
        if (this.pageNumbers != null && (pageNumber = this.pageNumbers.get(bookmark)) != null) {
            return pageNumber;
        }
        return -1L;
    }

    @Override
    public List<String> getBookmarks() throws IOException {
        if (this.pageNumbers != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String bookmark : this.pageNumbers.keySet()) {
                if (bookmark == null || bookmark.startsWith("__TOC_")) continue;
                list.add(bookmark);
            }
            return list;
        }
        return null;
    }

    @Override
    public BookmarkContent getBookmark(String bookmark) {
        return null;
    }

    @Override
    public List<BookmarkContent> getBookmarkContents() throws IOException {
        return null;
    }
}

